/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.http;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileEntrySoap;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.FolderSoap;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class DLAppServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(DLAppServiceSoap.class);

    public static FileEntrySoap addFileEntry(long repositoryId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, byte[] bytes, ServiceContext serviceContext) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.addFileEntry(repositoryId, folderId, sourceFileName, mimeType, title, description, changeLog, bytes, serviceContext);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap addFolder(long repositoryId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            Folder returnValue = DLAppServiceUtil.addFolder(repositoryId, parentFolderId, name, description, serviceContext);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void cancelCheckOut(long fileEntryId) throws RemoteException {
        try {
            DLAppServiceUtil.cancelCheckOut(fileEntryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static void checkInFileEntry(long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws RemoteException {
        try {
            DLAppServiceUtil.checkInFileEntry(fileEntryId, majorVersion, changeLog, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void checkInFileEntry(long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws RemoteException {
        try {
            DLAppServiceUtil.checkInFileEntry(fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void checkInFileEntry(long fileEntryId, String lockUuid, ServiceContext serviceContext) throws RemoteException {
        try {
            DLAppServiceUtil.checkInFileEntry(fileEntryId, lockUuid, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws RemoteException {
        try {
            DLAppServiceUtil.checkOutFileEntry(fileEntryId, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap copyFolder(long repositoryId, long sourceFolderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            Folder returnValue = DLAppServiceUtil.copyFolder(repositoryId, sourceFolderId, parentFolderId, name, description, serviceContext);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntry(long fileEntryId) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFileEntry(fileEntryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileEntryByTitle(long repositoryId, long folderId, String title) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFileEntryByTitle(repositoryId, folderId, title);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileShortcut(long fileShortcutId) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFileShortcut(fileShortcutId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileVersion(long fileVersionId) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFileVersion(fileVersionId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFileVersion(long fileEntryId, String version) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFileVersion(fileEntryId, version);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFolder(long folderId) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFolder(folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteFolder(long repositoryId, long parentFolderId, String name) throws RemoteException {
        try {
            DLAppServiceUtil.deleteFolder(repositoryId, parentFolderId, name);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTempFileEntry(long groupId, long folderId, String folderName, String fileName) throws RemoteException {
        try {
            DLAppServiceUtil.deleteTempFileEntry(groupId, folderId, folderName, fileName);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, int start, int end) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, start, end);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, start, end, obc);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, long fileEntryTypeId) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, fileEntryTypeId);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, fileEntryTypeId, start, end);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, fileEntryTypeId, start, end, obc);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, String[] mimeTypes) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, mimeTypes);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getFileEntries(long repositoryId, long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getFileEntries(repositoryId, folderId, mimeTypes, start, end, obc);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFileEntriesAndFileShortcutsCount(repositoryId, folderId, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, mimeTypes);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long repositoryId, long folderId) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFileEntriesCount(repositoryId, folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long repositoryId, long folderId, long fileEntryTypeId) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFileEntriesCount(repositoryId, folderId, fileEntryTypeId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFileEntriesCount(long repositoryId, long folderId, String[] mimeTypes) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFileEntriesCount(repositoryId, folderId, mimeTypes);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap getFileEntry(long fileEntryId) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.getFileEntry(fileEntryId);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap getFileEntry(long groupId, long folderId, String title) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.getFileEntry(groupId, folderId, title);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap getFileEntryByUuidAndGroupId(String uuid, long groupId) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap getFolder(long folderId) throws RemoteException {
        try {
            Folder returnValue = DLAppServiceUtil.getFolder(folderId);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap getFolder(long repositoryId, long parentFolderId, String name) throws RemoteException {
        try {
            Folder returnValue = DLAppServiceUtil.getFolder(repositoryId, parentFolderId, name);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId, includeMountFolders);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId, includeMountFolders, start, end);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId, includeMountFolders, start, end, obc);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId, status, includeMountFolders, start, end, obc);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId, int start, int end) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId, start, end);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getFolders(repositoryId, parentFolderId, start, end, obc);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, boolean includeMountFolders) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, includeMountFolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, mimeTypes, includeMountFolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersAndFileEntriesAndFileShortcutsCount(long repositoryId, long folderId, int status, String[] mimeTypes, boolean includeMountFolders, boolean includeOwner) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount(repositoryId, folderId, status, mimeTypes, includeMountFolders, includeOwner);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersCount(long repositoryId, long parentFolderId) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersCount(repositoryId, parentFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersCount(long repositoryId, long parentFolderId, boolean includeMountFolders) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersCount(repositoryId, parentFolderId, includeMountFolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersCount(long repositoryId, long parentFolderId, int status, boolean includeMountFolders) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersCount(repositoryId, parentFolderId, status, includeMountFolders);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getFoldersFileEntriesCount(long repositoryId, Long[] folderIds, int status) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getFoldersFileEntriesCount(repositoryId, ListUtil.toList(folderIds), status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getGroupFileEntries(long groupId, long userId, int start, int end) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getGroupFileEntries(groupId, userId, start, end);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getGroupFileEntries(long groupId, long userId, int start, int end, OrderByComparator<FileEntry> obc) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getGroupFileEntries(groupId, userId, start, end, obc);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getGroupFileEntries(groupId, userId, rootFolderId, start, end);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getGroupFileEntries(long groupId, long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getGroupFileEntries(groupId, userId, rootFolderId, start, end, obc);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap[] getGroupFileEntries(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws RemoteException {
        try {
            List<FileEntry> returnValue = DLAppServiceUtil.getGroupFileEntries(groupId, userId, rootFolderId, mimeTypes, status, start, end, obc);
            return FileEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getGroupFileEntriesCount(groupId, userId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getGroupFileEntriesCount(groupId, userId, rootFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupFileEntriesCount(long groupId, long userId, long rootFolderId, String[] mimeTypes, int status) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getGroupFileEntriesCount(groupId, userId, rootFolderId, mimeTypes, status);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getMountFolders(long repositoryId, long parentFolderId) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getMountFolders(repositoryId, parentFolderId);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getMountFolders(long repositoryId, long parentFolderId, int start, int end) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getMountFolders(repositoryId, parentFolderId, start, end);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap[] getMountFolders(long repositoryId, long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws RemoteException {
        try {
            List<Folder> returnValue = DLAppServiceUtil.getMountFolders(repositoryId, parentFolderId, start, end, obc);
            return FolderSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getMountFoldersCount(long repositoryId, long parentFolderId) throws RemoteException {
        try {
            int returnValue = DLAppServiceUtil.getMountFoldersCount(repositoryId, parentFolderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void getSubfolderIds(long repositoryId, Long[] folderIds, long folderId) throws RemoteException {
        try {
            DLAppServiceUtil.getSubfolderIds(repositoryId, ListUtil.toList(folderIds), folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Long[] getSubfolderIds(long repositoryId, long folderId) throws RemoteException {
        try {
            List<Long> returnValue = DLAppServiceUtil.getSubfolderIds(repositoryId, folderId);
            return returnValue.toArray(new Long[returnValue.size()]);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Long[] getSubfolderIds(long repositoryId, long folderId, boolean recurse) throws RemoteException {
        try {
            List<Long> returnValue = DLAppServiceUtil.getSubfolderIds(repositoryId, folderId, recurse);
            return returnValue.toArray(new Long[returnValue.size()]);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String[] getTempFileNames(long groupId, long folderId, String folderName) throws RemoteException {
        try {
            String[] returnValue = DLAppServiceUtil.getTempFileNames(groupId, folderId, folderName);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock lockFolder(long repositoryId, long folderId) throws RemoteException {
        try {
            Lock returnValue = DLAppServiceUtil.lockFolder(repositoryId, folderId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock lockFolder(long repositoryId, long folderId, String owner, boolean inheritable, long expirationTime) throws RemoteException {
        try {
            Lock returnValue = DLAppServiceUtil.lockFolder(repositoryId, folderId, owner, inheritable, expirationTime);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap moveFileEntry(long fileEntryId, long newFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.moveFileEntry(fileEntryId, newFolderId, serviceContext);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap moveFolder(long folderId, long parentFolderId, ServiceContext serviceContext) throws RemoteException {
        try {
            Folder returnValue = DLAppServiceUtil.moveFolder(folderId, parentFolderId, serviceContext);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws RemoteException {
        try {
            Lock returnValue = DLAppServiceUtil.refreshFileEntryLock(lockUuid, companyId, expirationTime);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws RemoteException {
        try {
            Lock returnValue = DLAppServiceUtil.refreshFolderLock(lockUuid, companyId, expirationTime);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void revertFileEntry(long fileEntryId, String version, ServiceContext serviceContext) throws RemoteException {
        try {
            DLAppServiceUtil.revertFileEntry(fileEntryId, version, serviceContext);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void subscribeFileEntryType(long groupId, long fileEntryTypeId) throws RemoteException {
        try {
            DLAppServiceUtil.subscribeFileEntryType(groupId, fileEntryTypeId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void subscribeFolder(long groupId, long folderId) throws RemoteException {
        try {
            DLAppServiceUtil.subscribeFolder(groupId, folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unlockFolder(long repositoryId, long folderId, String lockUuid) throws RemoteException {
        try {
            DLAppServiceUtil.unlockFolder(repositoryId, folderId, lockUuid);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unlockFolder(long repositoryId, long parentFolderId, String name, String lockUuid) throws RemoteException {
        try {
            DLAppServiceUtil.unlockFolder(repositoryId, parentFolderId, name, lockUuid);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsubscribeFileEntryType(long groupId, long fileEntryTypeId) throws RemoteException {
        try {
            DLAppServiceUtil.unsubscribeFileEntryType(groupId, fileEntryTypeId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void unsubscribeFolder(long groupId, long folderId) throws RemoteException {
        try {
            DLAppServiceUtil.unsubscribeFolder(groupId, folderId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static FileEntrySoap updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, byte[] bytes, ServiceContext serviceContext) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, bytes, serviceContext);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FileEntrySoap updateFileEntry(long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, byte[] bytes, ServiceContext serviceContext) throws RemoteException {
        try {
            FileEntry returnValue = DLAppServiceUtil.updateFileEntry(fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, bytes, serviceContext);
            return FileEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static FolderSoap updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws RemoteException {
        try {
            Folder returnValue = DLAppServiceUtil.updateFolder(folderId, name, description, serviceContext);
            return FolderSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyFileEntryCheckOut(long repositoryId, long fileEntryId, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLAppServiceUtil.verifyFileEntryCheckOut(repositoryId, fileEntryId, lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyFileEntryLock(long repositoryId, long fileEntryId, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLAppServiceUtil.verifyFileEntryLock(repositoryId, fileEntryId, lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static boolean verifyInheritableLock(long repositoryId, long folderId, String lockUuid) throws RemoteException {
        try {
            boolean returnValue = DLAppServiceUtil.verifyInheritableLock(repositoryId, folderId, lockUuid);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

