/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryFinder;
import com.liferay.document.library.kernel.service.persistence.DLFileEntryPersistence;
import com.liferay.document.library.kernel.service.persistence.DLFileVersionPersistence;
import com.liferay.document.library.kernel.service.persistence.DLFolderFinder;
import com.liferay.document.library.kernel.service.persistence.DLFolderPersistence;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class DLFileVersionLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements DLFileVersionLocalService,
IdentifiableOSGiService {
    @BeanReference(type=DLFileVersionLocalService.class)
    protected DLFileVersionLocalService dlFileVersionLocalService;
    @BeanReference(type=DLFileVersionPersistence.class)
    protected DLFileVersionPersistence dlFileVersionPersistence;
    @BeanReference(type=CounterLocalService.class)
    protected CounterLocalService counterLocalService;
    @BeanReference(type=DLFileEntryLocalService.class)
    protected DLFileEntryLocalService dlFileEntryLocalService;
    @BeanReference(type=DLFileEntryPersistence.class)
    protected DLFileEntryPersistence dlFileEntryPersistence;
    @BeanReference(type=DLFileEntryFinder.class)
    protected DLFileEntryFinder dlFileEntryFinder;
    @BeanReference(type=DLFolderLocalService.class)
    protected DLFolderLocalService dlFolderLocalService;
    @BeanReference(type=DLFolderPersistence.class)
    protected DLFolderPersistence dlFolderPersistence;
    @BeanReference(type=DLFolderFinder.class)
    protected DLFolderFinder dlFolderFinder;
    @BeanReference(type=PersistedModelLocalServiceRegistry.class)
    protected PersistedModelLocalServiceRegistry persistedModelLocalServiceRegistry;

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public DLFileVersion addDLFileVersion(DLFileVersion dlFileVersion) {
        dlFileVersion.setNew(true);
        return this.dlFileVersionPersistence.update(dlFileVersion);
    }

    @Override
    @Transactional(enabled=false)
    public DLFileVersion createDLFileVersion(long fileVersionId) {
        return this.dlFileVersionPersistence.create(fileVersionId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public DLFileVersion deleteDLFileVersion(long fileVersionId) throws PortalException {
        return this.dlFileVersionPersistence.remove(fileVersionId);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public DLFileVersion deleteDLFileVersion(DLFileVersion dlFileVersion) {
        return this.dlFileVersionPersistence.remove(dlFileVersion);
    }

    @Override
    public DynamicQuery dynamicQuery() {
        Class<?> clazz = this.getClass();
        return DynamicQueryFactoryUtil.forClass(DLFileVersion.class, clazz.getClassLoader());
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.dlFileVersionPersistence.findWithDynamicQuery(dynamicQuery);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.dlFileVersionPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    @Override
    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.dlFileVersionPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.dlFileVersionPersistence.countWithDynamicQuery(dynamicQuery);
    }

    @Override
    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.dlFileVersionPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    @Override
    public DLFileVersion fetchDLFileVersion(long fileVersionId) {
        return this.dlFileVersionPersistence.fetchByPrimaryKey(fileVersionId);
    }

    @Override
    public DLFileVersion fetchDLFileVersionByUuidAndGroupId(String uuid, long groupId) {
        return this.dlFileVersionPersistence.fetchByUUID_G(uuid, groupId);
    }

    @Override
    public DLFileVersion getDLFileVersion(long fileVersionId) throws PortalException {
        return this.dlFileVersionPersistence.findByPrimaryKey(fileVersionId);
    }

    @Override
    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService(this.dlFileVersionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DLFileVersion.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("fileVersionId");
        return actionableDynamicQuery;
    }

    @Override
    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService(this.dlFileVersionLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(DLFileVersion.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("fileVersionId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService(this.dlFileVersionLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DLFileVersion.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("fileVersionId");
    }

    @Override
    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            @Override
            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount(portletDataContext, stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery(exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            @Override
            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty("modifiedDate", "lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName("lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add(disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add(disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName("status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne(8));
                } else {
                    StagedModelDataHandler<?> stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler(DLFileVersion.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod(new ActionableDynamicQuery.PerformActionMethod<DLFileVersion>(){

            @Override
            public void performAction(DLFileVersion dlFileVersion) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel(portletDataContext, dlFileVersion);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId(DLFileVersion.class.getName())));
        return exportActionableDynamicQuery;
    }

    @Override
    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.dlFileVersionLocalService.deleteDLFileVersion((DLFileVersion)persistedModel);
    }

    @Override
    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.dlFileVersionPersistence.findByPrimaryKey(primaryKeyObj);
    }

    @Override
    public List<DLFileVersion> getDLFileVersionsByUuidAndCompanyId(String uuid, long companyId) {
        return this.dlFileVersionPersistence.findByUuid_C(uuid, companyId);
    }

    @Override
    public List<DLFileVersion> getDLFileVersionsByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<DLFileVersion> orderByComparator) {
        return this.dlFileVersionPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    @Override
    public DLFileVersion getDLFileVersionByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.dlFileVersionPersistence.findByUUID_G(uuid, groupId);
    }

    @Override
    public List<DLFileVersion> getDLFileVersions(int start, int end) {
        return this.dlFileVersionPersistence.findAll(start, end);
    }

    @Override
    public int getDLFileVersionsCount() {
        return this.dlFileVersionPersistence.countAll();
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public DLFileVersion updateDLFileVersion(DLFileVersion dlFileVersion) {
        return this.dlFileVersionPersistence.update(dlFileVersion);
    }

    public DLFileVersionLocalService getDLFileVersionLocalService() {
        return this.dlFileVersionLocalService;
    }

    public void setDLFileVersionLocalService(DLFileVersionLocalService dlFileVersionLocalService) {
        this.dlFileVersionLocalService = dlFileVersionLocalService;
    }

    public DLFileVersionPersistence getDLFileVersionPersistence() {
        return this.dlFileVersionPersistence;
    }

    public void setDLFileVersionPersistence(DLFileVersionPersistence dlFileVersionPersistence) {
        this.dlFileVersionPersistence = dlFileVersionPersistence;
    }

    public CounterLocalService getCounterLocalService() {
        return this.counterLocalService;
    }

    public void setCounterLocalService(CounterLocalService counterLocalService) {
        this.counterLocalService = counterLocalService;
    }

    public DLFileEntryLocalService getDLFileEntryLocalService() {
        return this.dlFileEntryLocalService;
    }

    public void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this.dlFileEntryLocalService = dlFileEntryLocalService;
    }

    public DLFileEntryPersistence getDLFileEntryPersistence() {
        return this.dlFileEntryPersistence;
    }

    public void setDLFileEntryPersistence(DLFileEntryPersistence dlFileEntryPersistence) {
        this.dlFileEntryPersistence = dlFileEntryPersistence;
    }

    public DLFileEntryFinder getDLFileEntryFinder() {
        return this.dlFileEntryFinder;
    }

    public void setDLFileEntryFinder(DLFileEntryFinder dlFileEntryFinder) {
        this.dlFileEntryFinder = dlFileEntryFinder;
    }

    public DLFolderLocalService getDLFolderLocalService() {
        return this.dlFolderLocalService;
    }

    public void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this.dlFolderLocalService = dlFolderLocalService;
    }

    public DLFolderPersistence getDLFolderPersistence() {
        return this.dlFolderPersistence;
    }

    public void setDLFolderPersistence(DLFolderPersistence dlFolderPersistence) {
        this.dlFolderPersistence = dlFolderPersistence;
    }

    public DLFolderFinder getDLFolderFinder() {
        return this.dlFolderFinder;
    }

    public void setDLFolderFinder(DLFolderFinder dlFolderFinder) {
        this.dlFolderFinder = dlFolderFinder;
    }

    public void afterPropertiesSet() {
        this.persistedModelLocalServiceRegistry.register("com.liferay.document.library.kernel.model.DLFileVersion", this.dlFileVersionLocalService);
    }

    public void destroy() {
        this.persistedModelLocalServiceRegistry.unregister("com.liferay.document.library.kernel.model.DLFileVersion");
    }

    @Override
    public String getOSGiServiceIdentifier() {
        return DLFileVersionLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return DLFileVersion.class;
    }

    protected String getModelClassName() {
        return DLFileVersion.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.dlFileVersionPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL(sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, sql, new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

