/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderServiceUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class DLFolderImpl
extends DLFolderBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFolderImpl.class);

    @Override
    public List<Long> getAncestorFolderIds() throws PortalException {
        ArrayList<Long> ancestorFolderIds = new ArrayList<Long>();
        DLFolder folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestorFolderIds.add(folder.getFolderId());
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestorFolderIds;
    }

    @Override
    public List<DLFolder> getAncestors() throws PortalException {
        ArrayList<DLFolder> ancestors = new ArrayList<DLFolder>();
        DLFolder folder = this;
        while (!folder.isRoot()) {
            try {
                folder = folder.getParentFolder();
                ancestors.add(folder);
            }
            catch (NoSuchFolderException nsfe) {
                if (folder.isInTrash()) break;
                throw nsfe;
            }
        }
        return ancestors;
    }

    @Override
    public DLFolder getParentFolder() throws PortalException {
        if (this.getParentFolderId() == 0L) {
            return null;
        }
        return DLFolderLocalServiceUtil.getFolder(this.getParentFolderId());
    }

    @Override
    public String getPath() throws PortalException {
        StringBuilder sb = new StringBuilder();
        for (DLFolder folder = this; folder != null; folder = folder.getParentFolder()) {
            sb.insert(0, folder.getName());
            sb.insert(0, "/");
        }
        return sb.toString();
    }

    @Override
    public String[] getPathArray() throws PortalException {
        String path = this.getPath();
        path = path.substring(1);
        return StringUtil.split(path, '/');
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFolderConstants.getClassName());
    }

    @Override
    public boolean hasInheritableLock() {
        return DLFolderLocalServiceUtil.hasInheritableLock(this.getFolderId());
    }

    @Override
    public boolean hasLock() {
        try {
            return DLFolderServiceUtil.hasFolderLock(this.getFolderId());
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            if (this.getGroupId() == repositoryId) {
                return false;
            }
            Repository repository = RepositoryLocalServiceUtil.getRepository(repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder(dlFolderId);
            return dlFolder.isHidden();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(pe, pe);
            }
            return false;
        }
    }

    @Override
    public boolean isLocked() {
        return DLFolderServiceUtil.isFolderLocked(this.getFolderId());
    }

    @Override
    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }
}

