/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.documentlibrary.model.impl.DLFileVersionBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class DLFileVersionImpl
extends DLFileVersionBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionImpl.class);
    private transient ExpandoBridge _expandoBridge;
    private UnicodeProperties _extraSettingsProperties;

    @Override
    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        DLFolder dlFolder = this.getFolder();
        return dlFolder.buildTreePath();
    }

    @Override
    public InputStream getContentStream(boolean incrementCounter) throws PortalException {
        return DLFileEntryLocalServiceUtil.getFileAsStream(this.getFileEntryId(), this.getVersion(), incrementCounter);
    }

    @Override
    public List<DDMStructure> getDDMStructures() throws PortalException {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType(this.getFileEntryTypeId());
        return dlFileEntryType.getDDMStructures();
    }

    @Override
    public DLFileEntryType getDLFileEntryType() throws PortalException {
        return DLFileEntryTypeLocalServiceUtil.getFileEntryType(this.getFileEntryTypeId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        if (this._expandoBridge == null) {
            this._expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge(this.getCompanyId(), DLFileEntry.class.getName(), this.getPrimaryKey());
        }
        return this._expandoBridge;
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    @Override
    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    @Override
    public DLFileEntry getFileEntry() throws PortalException {
        return DLFileEntryLocalServiceUtil.getFileEntry(this.getFileEntryId());
    }

    @Override
    public DLFolder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            return new DLFolderImpl();
        }
        return DLFolderLocalServiceUtil.getFolder(this.getFolderId());
    }

    @Override
    public String getIcon() {
        return DLUtil.getFileIcon(this.getExtension());
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    @Override
    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }
}

