/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import com.liferay.portlet.documentlibrary.model.impl.DLFileShortcutBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;

public class DLFileShortcutImpl
extends DLFileShortcutBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileShortcutImpl.class);

    @Override
    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        DLFolder dlFolder = this.getDLFolder();
        return dlFolder.buildTreePath();
    }

    @Override
    public DLFolder getDLFolder() throws PortalException {
        Folder folder = this.getFolder();
        return (DLFolder)folder.getModel();
    }

    @Override
    public FileVersion getFileVersion() throws PortalException {
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry(this.getToFileEntryId());
        return fileEntry.getFileVersion();
    }

    @Override
    public Folder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            return new LiferayFolder(new DLFolderImpl());
        }
        return DLAppLocalServiceUtil.getFolder(this.getFolderId());
    }

    @Override
    public String getToTitle() {
        String toTitle = null;
        try {
            FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry(this.getToFileEntryId());
            toTitle = fileEntry.getTitle();
        }
        catch (PortalException pe) {
            _log.error(pe, pe);
        }
        return toTitle;
    }

    @Override
    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            if (this.getGroupId() == repositoryId) {
                return false;
            }
            Repository repository = RepositoryLocalServiceUtil.getRepository(repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder(dlFolderId);
            return dlFolder.isHidden();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(pe, pe);
            }
            return false;
        }
    }

    @Override
    public boolean isInTrash() {
        return super.isInTrash() || !this.isActive();
    }
}

