/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.model.impl;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileShortcutLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileVersionLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileVersionServiceUtil;
import com.liferay.document.library.kernel.service.DLFolderLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portlet.documentlibrary.model.impl.DLFileEntryBaseImpl;
import com.liferay.portlet.documentlibrary.model.impl.DLFolderImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DLFileEntryImpl
extends DLFileEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryImpl.class);
    private UnicodeProperties _extraSettingsProperties;

    @Override
    public String buildTreePath() throws PortalException {
        if (this.getFolderId() == 0L) {
            return "/";
        }
        DLFolder dlFolder = this.getFolder();
        return dlFolder.buildTreePath();
    }

    @Override
    public InputStream getContentStream() throws PortalException {
        return this.getContentStream(this.getVersion());
    }

    @Override
    public InputStream getContentStream(String version) throws PortalException {
        return DLFileEntryLocalServiceUtil.getFileAsStream(this.getFileEntryId(), version);
    }

    @Override
    public long getDataRepositoryId() {
        return DLFolderConstants.getDataRepositoryId(this.getGroupId(), this.getFolderId());
    }

    @Override
    public Map<String, DDMFormValues> getDDMFormValuesMap(long fileVersionId) throws PortalException {
        HashMap<String, DDMFormValues> ddmFormValuesMap = new HashMap<String, DDMFormValues>();
        DLFileVersion dlFileVersion = DLFileVersionLocalServiceUtil.getFileVersion(fileVersionId);
        long fileEntryTypeId = dlFileVersion.getFileEntryTypeId();
        if (fileEntryTypeId <= 0L) {
            return ddmFormValuesMap;
        }
        DLFileEntryType dlFileEntryType = this.getDLFileEntryType();
        List<DDMStructure> ddmStructures = dlFileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.fetchFileEntryMetadata(ddmStructure.getStructureId(), fileVersionId);
            if (dlFileEntryMetadata == null) continue;
            DDMFormValues ddmFormValues = StorageEngineManagerUtil.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
            ddmFormValuesMap.put(ddmStructure.getStructureKey(), ddmFormValues);
        }
        return ddmFormValuesMap;
    }

    @Override
    public DLFileEntryType getDLFileEntryType() throws PortalException {
        return DLFileEntryTypeLocalServiceUtil.getDLFileEntryType(this.getFileEntryTypeId());
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        try {
            DLFileVersion dlFileVersion = this.getFileVersion();
            return dlFileVersion.getExpandoBridge();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(pe, pe);
            }
            return null;
        }
    }

    @Override
    public String getExtraSettings() {
        if (this._extraSettingsProperties == null) {
            return super.getExtraSettings();
        }
        return this._extraSettingsProperties.toString();
    }

    @Override
    public UnicodeProperties getExtraSettingsProperties() {
        if (this._extraSettingsProperties == null) {
            this._extraSettingsProperties = new UnicodeProperties(true);
            try {
                this._extraSettingsProperties.load(super.getExtraSettings());
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
        return this._extraSettingsProperties;
    }

    @Override
    public List<DLFileShortcut> getFileShortcuts() {
        return DLFileShortcutLocalServiceUtil.getFileShortcuts(this.getFileEntryId());
    }

    @Override
    public DLFileVersion getFileVersion() throws PortalException {
        return this.getFileVersion(this.getVersion());
    }

    @Override
    public DLFileVersion getFileVersion(String version) throws PortalException {
        return DLFileVersionLocalServiceUtil.getFileVersion(this.getFileEntryId(), version);
    }

    @Override
    public List<DLFileVersion> getFileVersions(int status) {
        return DLFileVersionLocalServiceUtil.getFileVersions(this.getFileEntryId(), status);
    }

    @Override
    public int getFileVersionsCount(int status) {
        return DLFileVersionLocalServiceUtil.getFileVersionsCount(this.getFileEntryId(), status);
    }

    @Override
    public DLFolder getFolder() throws PortalException {
        if (this.getFolderId() <= 0L) {
            return new DLFolderImpl();
        }
        return DLFolderLocalServiceUtil.getFolder(this.getFolderId());
    }

    @Override
    public String getIcon() {
        return DLUtil.getFileIcon(this.getExtension());
    }

    @Override
    public String getIconCssClass() {
        return DLUtil.getFileIconCssClass(this.getExtension());
    }

    @Override
    public DLFileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        if (trusted) {
            return DLFileVersionLocalServiceUtil.getLatestFileVersion(this.getFileEntryId(), false);
        }
        return DLFileVersionServiceUtil.getLatestFileVersion(this.getFileEntryId());
    }

    @Override
    public Lock getLock() {
        return LockManagerUtil.fetchLock(DLFileEntry.class.getName(), this.getFileEntryId());
    }

    @Override
    public String getLuceneProperties() {
        UnicodeProperties extraSettingsProps = this.getExtraSettingsProperties();
        Set entrySet = extraSettingsProps.entrySet();
        StringBundler sb = new StringBundler(entrySet.size() + 4);
        sb.append(FileUtil.stripExtension(this.getTitle()));
        sb.append(" ");
        sb.append(this.getDescription());
        sb.append(" ");
        for (Map.Entry entry : extraSettingsProps.entrySet()) {
            String value = GetterUtil.getString((String)entry.getValue());
            sb.append(value);
        }
        return sb.toString();
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    @Override
    public int getStatus() {
        try {
            DLFileVersion dlFileVersion = this.getFileVersion();
            return dlFileVersion.getStatus();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public boolean hasLock() {
        return DLFileEntryLocalServiceUtil.hasFileEntryLock(PrincipalThreadLocal.getUserId(), this.getFileEntryId(), this.getFolderId());
    }

    @Override
    public boolean isCheckedOut() {
        try {
            return DLFileEntryServiceUtil.isFileEntryCheckedOut(this.getFileEntryId());
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(pe, pe);
            }
            return false;
        }
    }

    @Override
    public boolean isInHiddenFolder() {
        try {
            long repositoryId = this.getRepositoryId();
            if (this.getGroupId() == repositoryId) {
                return false;
            }
            Repository repository = RepositoryLocalServiceUtil.getRepository(repositoryId);
            long dlFolderId = repository.getDlFolderId();
            DLFolder dlFolder = DLFolderLocalServiceUtil.getFolder(dlFolderId);
            return dlFolder.isHidden();
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(pe, pe);
            }
            return false;
        }
    }

    @Override
    public boolean isInTrash() {
        return this.getStatus() == 8;
    }

    @Override
    public void setExtraSettings(String extraSettings) {
        this._extraSettingsProperties = null;
        super.setExtraSettings(extraSettings);
    }

    @Override
    public void setExtraSettingsProperties(UnicodeProperties extraSettingsProperties) {
        this._extraSettingsProperties = extraSettingsProperties;
        super.setExtraSettings(this._extraSettingsProperties.toString());
    }
}

