/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.asset;

import com.liferay.asset.kernel.model.BaseDDMFormValuesReader;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManagerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Iterator;
import java.util.List;

public class DLFileEntryDDMFormValuesReader
extends BaseDDMFormValuesReader {
    private final FileEntry _fileEntry;
    private final FileVersion _fileVersion;

    public DLFileEntryDDMFormValuesReader(FileEntry dlFileEntry, FileVersion fileVersion) {
        this._fileEntry = dlFileEntry;
        this._fileVersion = fileVersion;
    }

    @Override
    public DDMFormValues getDDMFormValues() throws PortalException {
        DLFileEntryMetadata dlFileEntryMetadata = this.getDLFileEntryMetadata();
        if (dlFileEntryMetadata == null) {
            return new DDMFormValues(null);
        }
        return StorageEngineManagerUtil.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
    }

    protected DLFileEntryMetadata getDLFileEntryMetadata() {
        DDMStructure ddmStructure;
        List<DDMStructure> ddmStructures = DDMStructureManagerUtil.getClassStructures(this._fileEntry.getCompanyId(), PortalUtil.getClassNameId(DLFileEntryMetadata.class));
        DLFileEntryMetadata dlFileEntryMetadata = null;
        Iterator<DDMStructure> iterator = ddmStructures.iterator();
        while (iterator.hasNext() && (dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.fetchFileEntryMetadata((ddmStructure = iterator.next()).getStructureId(), this._fileVersion.getFileVersionId())) == null) {
        }
        return dlFileEntryMetadata;
    }
}

