/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.antivirus;

import com.liferay.document.library.kernel.antivirus.AntivirusScannerException;
import com.liferay.document.library.kernel.antivirus.BaseFileAntivirusScanner;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.IOException;

public class ClamAntivirusScannerImpl
extends BaseFileAntivirusScanner {
    private static final Log _log = LogFactoryUtil.getLog(ClamAntivirusScannerImpl.class);

    @Override
    public void scan(File file) throws AntivirusScannerException {
        int exitValue = 0;
        try {
            exitValue = this._execute("clamdscan", file);
        }
        catch (IOException | InterruptedException e) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to successfully execute clamdscan", e);
            }
            exitValue = -1;
        }
        try {
            if (exitValue != 0 && exitValue != 1) {
                exitValue = this._execute("clamscan", file);
            }
            if (exitValue == 1) {
                throw new AntivirusScannerException("Virus detected in " + file.getAbsolutePath(), 2);
            }
            if (exitValue >= 2) {
                throw new AntivirusScannerException(1);
            }
        }
        catch (IOException | InterruptedException e) {
            if (_log.isDebugEnabled()) {
                _log.debug("Unable to successfully execute clamscan", e);
            }
            throw new AntivirusScannerException(1, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _execute(String command, File file) throws InterruptedException, IOException {
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command, "--stdout", "--no-summary", file.getAbsolutePath());
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            process.waitFor();
            int n = process.exitValue();
            return n;
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }
}

