/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.GroupServiceSettingsLocator;
import com.liferay.portal.kernel.settings.LocalizedValuesMap;
import com.liferay.portal.kernel.settings.ParameterMapSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsFactoryUtil;
import com.liferay.portal.kernel.settings.TypedSettings;
import com.liferay.portal.kernel.util.LocalizationUtil;
import java.util.Map;

@Settings.Config(settingsIds={"com.liferay.document.library"})
public class DLGroupServiceSettings {
    private final TypedSettings _typedSettings;

    public static DLGroupServiceSettings getInstance(long groupId) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings(new GroupServiceSettingsLocator(groupId, "com.liferay.document.library"));
        return new DLGroupServiceSettings(settings);
    }

    public static DLGroupServiceSettings getInstance(long groupId, Map<String, String[]> parameterMap) throws PortalException {
        Settings settings = SettingsFactoryUtil.getSettings(new GroupServiceSettingsLocator(groupId, "com.liferay.document.library"));
        ParameterMapSettings parameterMapSettings = new ParameterMapSettings(parameterMap, settings);
        return new DLGroupServiceSettings(parameterMapSettings);
    }

    public static void registerSettingsMetadata() {
        SettingsFactoryUtil.registerSettingsMetadata(DLGroupServiceSettings.class, null, DLGroupServiceSettings._getFallbackKeys());
    }

    public DLGroupServiceSettings(Settings settings) {
        this._typedSettings = new TypedSettings(settings);
    }

    public LocalizedValuesMap getEmailFileEntryAddedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryAddedBody");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryAddedBodyXml() {
        return LocalizationUtil.getXml(this.getEmailFileEntryAddedBody(), "emailFileEntryAdded");
    }

    public LocalizedValuesMap getEmailFileEntryAddedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryAddedSubject");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryAddedSubjectXml() {
        return LocalizationUtil.getXml(this.getEmailFileEntryAddedSubject(), "emailFileEntryAddedSubject");
    }

    public LocalizedValuesMap getEmailFileEntryUpdatedBody() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryUpdatedBody");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryUpdatedBodyXml() {
        return LocalizationUtil.getXml(this.getEmailFileEntryUpdatedBody(), "emailFileEntryUpdatedBody");
    }

    public LocalizedValuesMap getEmailFileEntryUpdatedSubject() {
        return this._typedSettings.getLocalizedValuesMap("emailFileEntryUpdatedSubject");
    }

    @Settings.Property(ignore=true)
    public String getEmailFileEntryUpdatedSubjectXml() {
        return LocalizationUtil.getXml(this.getEmailFileEntryUpdatedSubject(), "emailFileEntryUpdatedSubject");
    }

    public String getEmailFromAddress() {
        return this._typedSettings.getValue("emailFromAddress");
    }

    public String getEmailFromName() {
        return this._typedSettings.getValue("emailFromName");
    }

    public boolean isEmailFileEntryAddedEnabled() {
        return this._typedSettings.getBooleanValue("emailFileEntryAddedEnabled");
    }

    public boolean isEmailFileEntryUpdatedEnabled() {
        return this._typedSettings.getBooleanValue("emailFileEntryUpdatedEnabled");
    }

    public boolean isShowHiddenMountFolders() {
        return this._typedSettings.getBooleanValue("showHiddenMountFolders");
    }

    private static FallbackKeys _getFallbackKeys() {
        FallbackKeys fallbackKeys = new FallbackKeys();
        fallbackKeys.add("emailFileEntryAddedBody", "dl.email.file.entry.added.body");
        fallbackKeys.add("emailFileEntryAddedEnabled", "dl.email.file.entry.added.enabled");
        fallbackKeys.add("emailFileEntryAddedSubject", "dl.email.file.entry.added.subject");
        fallbackKeys.add("emailFileEntryUpdatedBody", "dl.email.file.entry.updated.body");
        fallbackKeys.add("emailFileEntryUpdatedEnabled", "dl.email.file.entry.updated.enabled");
        fallbackKeys.add("emailFileEntryUpdatedSubject", "dl.email.file.entry.updated.subject");
        fallbackKeys.add("emailFromAddress", "dl.email.from.address", "admin.email.from.address");
        fallbackKeys.add("emailFromName", "dl.email.from.name", "admin.email.from.name");
        fallbackKeys.add("enableCommentRatings", "dl.comment.ratings.enabled");
        fallbackKeys.add("enableRatings", "dl.ratings.enabled");
        fallbackKeys.add("enableRelatedAssets", "dl.related.assets.enabled");
        fallbackKeys.add("entriesPerPage", "search.container.page.default.delta");
        fallbackKeys.add("entryColumns", "dl.entry.columns");
        fallbackKeys.add("fileEntryColumns", "dl.file.entry.columns");
        fallbackKeys.add("folderColumns", "dl.folder.columns");
        fallbackKeys.add("foldersPerPage", "search.container.page.default.delta");
        fallbackKeys.add("fileEntriesPerPage", "search.container.page.default.delta");
        fallbackKeys.add("showFoldersSearch", "dl.folders.search.visible");
        fallbackKeys.add("showHiddenMountFolders", "dl.show.hidden.mount.folders");
        fallbackKeys.add("showSubfolders", "dl.subfolders.visible");
        return fallbackKeys;
    }

    static {
        SettingsFactoryUtil.registerSettingsMetadata(DLGroupServiceSettings.class, null, DLGroupServiceSettings._getFallbackKeys());
    }
}

