/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util.comparator;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.portal.kernel.util.OrderByComparator;

public class AssetTagAssetCountComparator
extends OrderByComparator<AssetTag> {
    public static final String ORDER_BY_ASC = "AssetTag.assetCount ASC, AssetTag.name ASC";
    public static final String ORDER_BY_DESC = "AssetTag.assetCount DESC, AssetTag.name ASC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"assetCount"};
    private final boolean _ascending;

    public AssetTagAssetCountComparator() {
        this(true);
    }

    public AssetTagAssetCountComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(AssetTag assetTag1, AssetTag assetTag2) {
        int assetCount1 = assetTag1.getAssetCount();
        int assetCount2 = assetTag2.getAssetCount();
        int value = 0;
        if (assetCount1 < assetCount2) {
            value = -1;
        } else if (assetCount1 > assetCount2) {
            value = 1;
        } else {
            String name1 = assetTag1.getName();
            String name2 = assetTag2.getName();
            value = name1.compareToIgnoreCase(name2);
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

