/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.LinkedHashSet;

public class AssetVocabularySettingsHelper {
    public static final long[] DEFAULT_SELECTED_CLASSNAME_IDS = new long[]{0L};
    public static final long[] DEFAULT_SELECTED_CLASSTYPE_PKS = new long[]{-1L};
    private static final String _KEY_MULTI_VALUED = "multiValued";
    private static final String _KEY_REQUIRED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS = "requiredClassNameIds";
    private static final String _KEY_SELECTED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS = "selectedClassNameIds";
    private final UnicodeProperties _properties = new UnicodeProperties(true);

    public AssetVocabularySettingsHelper() {
    }

    public AssetVocabularySettingsHelper(String propertiesString) {
        this();
        this._properties.fastLoad(propertiesString);
    }

    public long[] getClassNameIds() {
        String[] classNameIdsAndClassTypePKs = this.getClassNameIdsAndClassTypePKs();
        return this.getClassNameIds(classNameIdsAndClassTypePKs);
    }

    public long[] getClassTypePKs() {
        String[] classNameIdsAndClassTypePKs = this.getClassNameIdsAndClassTypePKs();
        return this.getClassTypePKs(classNameIdsAndClassTypePKs);
    }

    public long[] getRequiredClassNameIds() {
        String[] classNameIdsAndClassTypePKs = this.getRequiredClassNameIdsAndClassTypePKs();
        return this.getClassNameIds(classNameIdsAndClassTypePKs);
    }

    public long[] getRequiredClassTypePKs() {
        String[] classNameIdsAndClassTypePKs = this.getRequiredClassNameIdsAndClassTypePKs();
        return this.getClassTypePKs(classNameIdsAndClassTypePKs);
    }

    public boolean hasClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        return this.isClassNameIdAndClassTypePKSpecified(classNameId, classTypePK, this.getClassNameIdsAndClassTypePKs());
    }

    public boolean isClassNameIdAndClassTypePKRequired(long classNameId, long classTypePK) {
        return this.isClassNameIdAndClassTypePKSpecified(classNameId, classTypePK, this.getRequiredClassNameIdsAndClassTypePKs());
    }

    public boolean isMultiValued() {
        String value = this._properties.getProperty(_KEY_MULTI_VALUED);
        return GetterUtil.getBoolean(value, true);
    }

    public void setClassNameIdsAndClassTypePKs(long[] classNameIds, long[] classTypePKs, boolean[] requireds) {
        LinkedHashSet<String> requiredClassNameIds = new LinkedHashSet<String>();
        LinkedHashSet<String> selectedClassNameIds = new LinkedHashSet<String>();
        for (int i = 0; i < classNameIds.length; ++i) {
            long classNameId = classNameIds[i];
            long classTypePK = classTypePKs[i];
            boolean required = requireds[i];
            String classNameIdAndClassTypePK = this.getClassNameIdAndClassTypePK(classNameId, classTypePK);
            if (classNameIdAndClassTypePK.equals("0:-1")) {
                if (required) {
                    requiredClassNameIds.clear();
                    requiredClassNameIds.add(classNameIdAndClassTypePK);
                }
                selectedClassNameIds.clear();
                selectedClassNameIds.add(classNameIdAndClassTypePK);
                break;
            }
            if (required) {
                requiredClassNameIds.add(classNameIdAndClassTypePK);
            }
            selectedClassNameIds.add(classNameIdAndClassTypePK);
        }
        this._properties.setProperty(_KEY_REQUIRED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS, StringUtil.merge(requiredClassNameIds));
        this._properties.setProperty(_KEY_SELECTED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS, StringUtil.merge(selectedClassNameIds));
    }

    public void setMultiValued(boolean multiValued) {
        this._properties.setProperty(_KEY_MULTI_VALUED, String.valueOf(multiValued));
    }

    public String toString() {
        return this._properties.toString();
    }

    protected long getClassNameId(String classNameIdAndClassTypePK) {
        String[] parts = StringUtil.split(classNameIdAndClassTypePK, ':');
        return GetterUtil.getLong(parts[0]);
    }

    protected String getClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        return String.valueOf(classNameId).concat(":").concat(String.valueOf(classTypePK));
    }

    protected long[] getClassNameIds(String[] classNameIdsAndClassTypePKs) {
        long[] classNameIds = new long[classNameIdsAndClassTypePKs.length];
        for (int i = 0; i < classNameIdsAndClassTypePKs.length; ++i) {
            long classNameId;
            classNameIds[i] = classNameId = this.getClassNameId(classNameIdsAndClassTypePKs[i]);
        }
        return classNameIds;
    }

    protected String[] getClassNameIdsAndClassTypePKs() {
        String value = this._properties.getProperty(_KEY_SELECTED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS);
        if (Validator.isNull(value)) {
            return new String[]{this.getClassNameIdAndClassTypePK(0L, -1L)};
        }
        return StringUtil.split(value);
    }

    protected long getClassTypePK(String classNameIdAndClassTypePK) {
        String[] parts = StringUtil.split(classNameIdAndClassTypePK, ':');
        if (parts.length == 1) {
            return -1L;
        }
        return GetterUtil.getLong(parts[1]);
    }

    protected long[] getClassTypePKs(String[] classNameIdsAndClassTypePKs) {
        long[] classTypePKs = new long[classNameIdsAndClassTypePKs.length];
        for (int i = 0; i < classNameIdsAndClassTypePKs.length; ++i) {
            long classTypePK;
            classTypePKs[i] = classTypePK = this.getClassTypePK(classNameIdsAndClassTypePKs[i]);
        }
        return classTypePKs;
    }

    protected String[] getRequiredClassNameIdsAndClassTypePKs() {
        String value = this._properties.getProperty(_KEY_REQUIRED_CLASS_NAME_IDS_AND_CLASS_TYPE_PKS);
        if (Validator.isNull(value)) {
            return new String[0];
        }
        return StringUtil.split(value);
    }

    protected boolean isClassNameIdAndClassTypePKSpecified(long classNameId, long classTypePK, String[] classNameIdsAndClassTypePKs) {
        if (classNameIdsAndClassTypePKs.length == 0) {
            return false;
        }
        if (classNameIdsAndClassTypePKs[0].equals("0:-1")) {
            return true;
        }
        if (classTypePK == -1L) {
            String prefix = classNameId + ":";
            return ArrayUtil.exists(classNameIdsAndClassTypePKs, classNameIdsAndClassTypePK -> classNameIdsAndClassTypePK.startsWith(prefix));
        }
        String classNameIdAndClassTypePK = this.getClassNameIdAndClassTypePK(classNameId, classTypePK);
        if (ArrayUtil.contains(classNameIdsAndClassTypePKs, classNameIdAndClassTypePK)) {
            return true;
        }
        String classNameIdAndAllClassTypePK = this.getClassNameIdAndClassTypePK(classNameId, -1L);
        return ArrayUtil.contains(classNameIdsAndClassTypePKs, classNameIdAndAllClassTypePK);
    }
}

