/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
public class AssetTagIndexer
extends BaseIndexer<AssetTag> {
    public static final String CLASS_NAME = AssetTag.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AssetTagIndexer.class);

    public AssetTagIndexer() {
        this.setDefaultSelectedFieldNames("companyId", "groupId", "uid");
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String name = (String)((Object)searchContext.getAttribute("name"));
        if (Validator.isNotNull(name)) {
            BooleanQueryImpl nameQuery = new BooleanQueryImpl();
            this.addSearchTerm(nameQuery, searchContext, "name", true);
            searchQuery.add((Query)nameQuery, BooleanClauseOccur.SHOULD);
        }
    }

    @Override
    protected void doDelete(AssetTag assetTag) throws Exception {
        this.deleteDocument(assetTag.getCompanyId(), assetTag.getTagId());
    }

    @Override
    protected Document doGetDocument(AssetTag assetTag) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Indexing asset tag " + assetTag);
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, assetTag);
        document.addTextSortable("name", assetTag.getName());
        document.addNumberSortable("assetCount", assetTag.getAssetCount());
        if (_log.isDebugEnabled()) {
            _log.debug("Document " + assetTag + " indexed successfully");
        }
        return document;
    }

    @Override
    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    @Override
    protected void doReindex(AssetTag assetTag) throws Exception {
        Document document = this.getDocument(assetTag);
        IndexWriterHelperUtil.updateDocument(this.getSearchEngineId(), assetTag.getCompanyId(), document, this.isCommitImmediately());
    }

    @Override
    protected void doReindex(String className, long classPK) throws Exception {
        AssetTag tag = AssetTagLocalServiceUtil.getTag(classPK);
        this.doReindex(tag);
    }

    @Override
    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong(ids[0]);
        this.reindexTags(companyId);
    }

    protected void reindexTags(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = AssetTagLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(tag -> {
            block3: {
                try {
                    Document document = this.getDocument(tag);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(document);
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn("Unable to index asset tag " + tag.getTagId(), pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

