/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import java.io.Serializable;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@Deprecated
public class AssetCategoryIndexer
extends BaseIndexer<AssetCategory> {
    public static final String CLASS_NAME = AssetCategory.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(AssetCategoryIndexer.class);

    public AssetCategoryIndexer() {
        this.setDefaultSelectedFieldNames("assetCategoryId", "companyId", "groupId", "uid");
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory(entryClassPK);
        return AssetCategoryPermission.contains(permissionChecker, category, "VIEW");
    }

    @Override
    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long[] vocabularyIds;
        long[] parentCategoryIds = (long[])searchContext.getAttribute("parentCategoryIds");
        if (!ArrayUtil.isEmpty(parentCategoryIds)) {
            TermsFilter parentCategoryTermsFilter = new TermsFilter("parentCategoryId");
            parentCategoryTermsFilter.addValues(ArrayUtil.toStringArray(parentCategoryIds));
            contextBooleanFilter.add(parentCategoryTermsFilter, BooleanClauseOccur.MUST);
        }
        if (!ArrayUtil.isEmpty(vocabularyIds = (long[])searchContext.getAttribute("assetVocabularyIds"))) {
            TermsFilter vocabularyTermsFilter = new TermsFilter("assetVocabularyId");
            vocabularyTermsFilter.addValues(ArrayUtil.toStringArray(vocabularyIds));
            contextBooleanFilter.add(vocabularyTermsFilter, BooleanClauseOccur.MUST);
        }
    }

    @Override
    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        String title = (String)((Object)searchContext.getAttribute("title"));
        if (Validator.isNotNull(title)) {
            BooleanQueryImpl localizedQuery = new BooleanQueryImpl();
            searchContext.setAttribute("assetCategoryTitle", (Serializable)((Object)title));
            this.addSearchLocalizedTerm(localizedQuery, searchContext, "assetCategoryTitle", true);
            this.addSearchLocalizedTerm(localizedQuery, searchContext, "title", true);
            searchQuery.add((Query)localizedQuery, BooleanClauseOccur.SHOULD);
        }
    }

    @Override
    protected void doDelete(AssetCategory assetCategory) throws Exception {
        this.deleteDocument(assetCategory.getCompanyId(), assetCategory.getCategoryId());
    }

    @Override
    protected Document doGetDocument(AssetCategory assetCategory) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug("Indexing asset category " + assetCategory);
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, assetCategory);
        document.addKeyword("assetCategoryId", assetCategory.getCategoryId());
        this.addSearchAssetCategoryTitles(document, "assetCategoryTitle", ListUtil.toList(assetCategory));
        document.addKeyword("parentCategoryId", assetCategory.getParentCategoryId());
        document.addKeyword("assetVocabularyId", assetCategory.getVocabularyId());
        Locale siteDefaultLocale = PortalUtil.getSiteDefaultLocale(assetCategory.getGroupId());
        this.addLocalizedField(document, "description", siteDefaultLocale, assetCategory.getDescriptionMap());
        document.addText("name", assetCategory.getName());
        this.addLocalizedField(document, "title", siteDefaultLocale, assetCategory.getTitleMap());
        document.addKeyword("leftCategoryId", assetCategory.getLeftCategoryId());
        if (_log.isDebugEnabled()) {
            _log.debug("Document " + assetCategory + " indexed successfully");
        }
        return document;
    }

    @Override
    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        return null;
    }

    @Override
    protected void doReindex(AssetCategory assetCategory) throws Exception {
        Document document = this.getDocument(assetCategory);
        IndexWriterHelperUtil.updateDocument(this.getSearchEngineId(), assetCategory.getCompanyId(), document, this.isCommitImmediately());
    }

    @Override
    protected void doReindex(String className, long classPK) throws Exception {
        AssetCategory category = AssetCategoryLocalServiceUtil.getCategory(classPK);
        this.doReindex(category);
    }

    @Override
    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong(ids[0]);
        this.reindexCategories(companyId);
    }

    protected void reindexCategories(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = AssetCategoryLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(category -> {
            block3: {
                try {
                    Document document = this.getDocument(category);
                    if (document != null) {
                        indexableActionableDynamicQuery.addDocuments(document);
                    }
                }
                catch (PortalException pe) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn("Unable to index asset category " + category.getCategoryId(), pe);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

