/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.persistence.impl;

import com.liferay.asset.kernel.exception.NoSuchEntryException;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.persistence.AssetCategoryPersistence;
import com.liferay.asset.kernel.service.persistence.AssetEntryPersistence;
import com.liferay.asset.kernel.service.persistence.AssetTagPersistence;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.CompanyProvider;
import com.liferay.portal.kernel.service.persistence.CompanyProviderWrapper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.service.persistence.impl.TableMapperFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import com.liferay.portlet.asset.model.impl.AssetEntryModelImpl;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetEntryPersistenceImpl
extends BasePersistenceImpl<AssetEntry>
implements AssetEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = AssetEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByGroupId;
    private FinderPath _finderPathWithoutPaginationFindByGroupId;
    private FinderPath _finderPathCountByGroupId;
    private static final String _FINDER_COLUMN_GROUPID_GROUPID_2 = "assetEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "assetEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByVisible;
    private FinderPath _finderPathWithoutPaginationFindByVisible;
    private FinderPath _finderPathCountByVisible;
    private static final String _FINDER_COLUMN_VISIBLE_VISIBLE_2 = "assetEntry.visible = ?";
    private FinderPath _finderPathWithPaginationFindByPublishDate;
    private FinderPath _finderPathWithoutPaginationFindByPublishDate;
    private FinderPath _finderPathCountByPublishDate;
    private static final String _FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_1 = "assetEntry.publishDate IS NULL";
    private static final String _FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_2 = "assetEntry.publishDate = ?";
    private FinderPath _finderPathWithPaginationFindByExpirationDate;
    private FinderPath _finderPathWithoutPaginationFindByExpirationDate;
    private FinderPath _finderPathCountByExpirationDate;
    private static final String _FINDER_COLUMN_EXPIRATIONDATE_EXPIRATIONDATE_1 = "assetEntry.expirationDate IS NULL";
    private static final String _FINDER_COLUMN_EXPIRATIONDATE_EXPIRATIONDATE_2 = "assetEntry.expirationDate = ?";
    private FinderPath _finderPathWithPaginationFindByLayoutUuid;
    private FinderPath _finderPathWithoutPaginationFindByLayoutUuid;
    private FinderPath _finderPathCountByLayoutUuid;
    private static final String _FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_2 = "assetEntry.layoutUuid = ?";
    private static final String _FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_3 = "(assetEntry.layoutUuid IS NULL OR assetEntry.layoutUuid = '')";
    private FinderPath _finderPathFetchByG_CU;
    private FinderPath _finderPathCountByG_CU;
    private static final String _FINDER_COLUMN_G_CU_GROUPID_2 = "assetEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_CU_CLASSUUID_2 = "assetEntry.classUuid = ?";
    private static final String _FINDER_COLUMN_G_CU_CLASSUUID_3 = "(assetEntry.classUuid IS NULL OR assetEntry.classUuid = '')";
    private FinderPath _finderPathFetchByC_C;
    private FinderPath _finderPathCountByC_C;
    private static final String _FINDER_COLUMN_C_C_CLASSNAMEID_2 = "assetEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_C_C_CLASSPK_2 = "assetEntry.classPK = ?";
    private FinderPath _finderPathWithPaginationFindByG_C_V;
    private FinderPath _finderPathWithoutPaginationFindByG_C_V;
    private FinderPath _finderPathCountByG_C_V;
    private static final String _FINDER_COLUMN_G_C_V_GROUPID_2 = "assetEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_V_CLASSNAMEID_2 = "assetEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_V_VISIBLE_2 = "assetEntry.visible = ?";
    private FinderPath _finderPathWithPaginationFindByG_C_P_E;
    private FinderPath _finderPathWithoutPaginationFindByG_C_P_E;
    private FinderPath _finderPathCountByG_C_P_E;
    private static final String _FINDER_COLUMN_G_C_P_E_GROUPID_2 = "assetEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_P_E_CLASSNAMEID_2 = "assetEntry.classNameId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_P_E_PUBLISHDATE_1 = "assetEntry.publishDate IS NULL AND ";
    private static final String _FINDER_COLUMN_G_C_P_E_PUBLISHDATE_2 = "assetEntry.publishDate = ? AND ";
    private static final String _FINDER_COLUMN_G_C_P_E_EXPIRATIONDATE_1 = "assetEntry.expirationDate IS NULL";
    private static final String _FINDER_COLUMN_G_C_P_E_EXPIRATIONDATE_2 = "assetEntry.expirationDate = ?";
    @BeanReference(type=CompanyProviderWrapper.class)
    protected CompanyProvider companyProvider;
    @BeanReference(type=AssetCategoryPersistence.class)
    protected AssetCategoryPersistence assetCategoryPersistence;
    protected TableMapper<AssetEntry, AssetCategory> assetEntryToAssetCategoryTableMapper;
    @BeanReference(type=AssetTagPersistence.class)
    protected AssetTagPersistence assetTagPersistence;
    protected TableMapper<AssetEntry, AssetTag> assetEntryToAssetTagTableMapper;
    private static final String _SQL_SELECT_ASSETENTRY = "SELECT assetEntry FROM AssetEntry assetEntry";
    private static final String _SQL_SELECT_ASSETENTRY_WHERE = "SELECT assetEntry FROM AssetEntry assetEntry WHERE ";
    private static final String _SQL_COUNT_ASSETENTRY = "SELECT COUNT(assetEntry) FROM AssetEntry assetEntry";
    private static final String _SQL_COUNT_ASSETENTRY_WHERE = "SELECT COUNT(assetEntry) FROM AssetEntry assetEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "assetEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No AssetEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No AssetEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryPersistenceImpl.class);

    @Override
    public List<AssetEntry> findByGroupId(long groupId) {
        return this.findByGroupId(groupId, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByGroupId(long groupId, int start, int end) {
        return this.findByGroupId(groupId, start, end, null);
    }

    @Override
    public List<AssetEntry> findByGroupId(long groupId, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByGroupId(groupId, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByGroupId(long groupId, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByGroupId;
            finderArgs = new Object[]{groupId};
        } else {
            finderPath = this._finderPathWithPaginationFindByGroupId;
            finderArgs = new Object[]{groupId, start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (groupId == assetEntry.getGroupId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByGroupId_First(long groupId, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByGroupId_First(groupId, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByGroupId_First(long groupId, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByGroupId(groupId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByGroupId_Last(long groupId, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByGroupId_Last(groupId, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByGroupId_Last(long groupId, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByGroupId(groupId);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByGroupId(groupId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByGroupId_PrevAndNext(long entryId, long groupId, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByGroupId_PrevAndNext(session, assetEntry, groupId, orderByComparator, true), assetEntry, this.getByGroupId_PrevAndNext(session, assetEntry, groupId, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByGroupId_PrevAndNext(Session session, AssetEntry assetEntry, long groupId, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByGroupId(long groupId) {
        for (AssetEntry assetEntry : this.findByGroupId(groupId, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByGroupId(long groupId) {
        FinderPath finderPath = this._finderPathCountByGroupId;
        Object[] finderArgs = new Object[]{groupId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append(_FINDER_COLUMN_GROUPID_GROUPID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    @Override
    public List<AssetEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByCompanyId(long companyId, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId};
        } else {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (companyId == assetEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByCompanyId_First(long companyId, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByCompanyId_First(long companyId, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByCompanyId_Last(long companyId, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("companyId=");
        msg.append(companyId);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByCompanyId_Last(long companyId, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByCompanyId_PrevAndNext(long entryId, long companyId, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByCompanyId_PrevAndNext(session, assetEntry, companyId, orderByComparator, true), assetEntry, this.getByCompanyId_PrevAndNext(session, assetEntry, companyId, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByCompanyId_PrevAndNext(Session session, AssetEntry assetEntry, long companyId, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByCompanyId(long companyId) {
        for (AssetEntry assetEntry : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(companyId);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByVisible(boolean visible) {
        return this.findByVisible(visible, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByVisible(boolean visible, int start, int end) {
        return this.findByVisible(visible, start, end, null);
    }

    @Override
    public List<AssetEntry> findByVisible(boolean visible, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByVisible(visible, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByVisible(boolean visible, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByVisible;
            finderArgs = new Object[]{visible};
        } else {
            finderPath = this._finderPathWithPaginationFindByVisible;
            finderArgs = new Object[]{visible, start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (visible == assetEntry.isVisible()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append("assetEntry.visible = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(visible);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByVisible_First(boolean visible, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByVisible_First(visible, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("visible=");
        msg.append(visible);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByVisible_First(boolean visible, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByVisible(visible, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByVisible_Last(boolean visible, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByVisible_Last(visible, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("visible=");
        msg.append(visible);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByVisible_Last(boolean visible, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByVisible(visible);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByVisible(visible, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByVisible_PrevAndNext(long entryId, boolean visible, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByVisible_PrevAndNext(session, assetEntry, visible, orderByComparator, true), assetEntry, this.getByVisible_PrevAndNext(session, assetEntry, visible, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByVisible_PrevAndNext(Session session, AssetEntry assetEntry, boolean visible, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        query.append("assetEntry.visible = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(visible);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByVisible(boolean visible) {
        for (AssetEntry assetEntry : this.findByVisible(visible, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByVisible(boolean visible) {
        FinderPath finderPath = this._finderPathCountByVisible;
        Object[] finderArgs = new Object[]{visible};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append("assetEntry.visible = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(visible);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByPublishDate(Date publishDate) {
        return this.findByPublishDate(publishDate, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByPublishDate(Date publishDate, int start, int end) {
        return this.findByPublishDate(publishDate, start, end, null);
    }

    @Override
    public List<AssetEntry> findByPublishDate(Date publishDate, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByPublishDate(publishDate, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByPublishDate(Date publishDate, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByPublishDate;
            finderArgs = new Object[]{this._getTime(publishDate)};
        } else {
            finderPath = this._finderPathWithPaginationFindByPublishDate;
            finderArgs = new Object[]{this._getTime(publishDate), start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (Objects.equals(publishDate, assetEntry.getPublishDate())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            boolean bindPublishDate = false;
            if (publishDate == null) {
                query.append(_FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_1);
            } else {
                bindPublishDate = true;
                query.append(_FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindPublishDate) {
                    qPos.add(new Timestamp(publishDate.getTime()));
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByPublishDate_First(Date publishDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByPublishDate_First(publishDate, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("publishDate=");
        msg.append(publishDate);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByPublishDate_First(Date publishDate, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByPublishDate(publishDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByPublishDate_Last(Date publishDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByPublishDate_Last(publishDate, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("publishDate=");
        msg.append(publishDate);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByPublishDate_Last(Date publishDate, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByPublishDate(publishDate);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByPublishDate(publishDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByPublishDate_PrevAndNext(long entryId, Date publishDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByPublishDate_PrevAndNext(session, assetEntry, publishDate, orderByComparator, true), assetEntry, this.getByPublishDate_PrevAndNext(session, assetEntry, publishDate, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByPublishDate_PrevAndNext(Session session, AssetEntry assetEntry, Date publishDate, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        boolean bindPublishDate = false;
        if (publishDate == null) {
            query.append(_FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_1);
        } else {
            bindPublishDate = true;
            query.append(_FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindPublishDate) {
            qPos.add(new Timestamp(publishDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByPublishDate(Date publishDate) {
        for (AssetEntry assetEntry : this.findByPublishDate(publishDate, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByPublishDate(Date publishDate) {
        FinderPath finderPath = this._finderPathCountByPublishDate;
        Object[] finderArgs = new Object[]{this._getTime(publishDate)};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            boolean bindPublishDate = false;
            if (publishDate == null) {
                query.append(_FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_1);
            } else {
                bindPublishDate = true;
                query.append(_FINDER_COLUMN_PUBLISHDATE_PUBLISHDATE_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindPublishDate) {
                    qPos.add(new Timestamp(publishDate.getTime()));
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByExpirationDate(Date expirationDate) {
        return this.findByExpirationDate(expirationDate, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByExpirationDate(Date expirationDate, int start, int end) {
        return this.findByExpirationDate(expirationDate, start, end, null);
    }

    @Override
    public List<AssetEntry> findByExpirationDate(Date expirationDate, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByExpirationDate(expirationDate, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByExpirationDate(Date expirationDate, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByExpirationDate;
            finderArgs = new Object[]{this._getTime(expirationDate)};
        } else {
            finderPath = this._finderPathWithPaginationFindByExpirationDate;
            finderArgs = new Object[]{this._getTime(expirationDate), start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (Objects.equals(expirationDate, assetEntry.getExpirationDate())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                query.append("assetEntry.expirationDate IS NULL");
            } else {
                bindExpirationDate = true;
                query.append("assetEntry.expirationDate = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindExpirationDate) {
                    qPos.add(new Timestamp(expirationDate.getTime()));
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByExpirationDate_First(Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByExpirationDate_First(expirationDate, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("expirationDate=");
        msg.append(expirationDate);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByExpirationDate_First(Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByExpirationDate(expirationDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByExpirationDate_Last(Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByExpirationDate_Last(expirationDate, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("expirationDate=");
        msg.append(expirationDate);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByExpirationDate_Last(Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByExpirationDate(expirationDate);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByExpirationDate(expirationDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByExpirationDate_PrevAndNext(long entryId, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByExpirationDate_PrevAndNext(session, assetEntry, expirationDate, orderByComparator, true), assetEntry, this.getByExpirationDate_PrevAndNext(session, assetEntry, expirationDate, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByExpirationDate_PrevAndNext(Session session, AssetEntry assetEntry, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            query.append("assetEntry.expirationDate IS NULL");
        } else {
            bindExpirationDate = true;
            query.append("assetEntry.expirationDate = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindExpirationDate) {
            qPos.add(new Timestamp(expirationDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByExpirationDate(Date expirationDate) {
        for (AssetEntry assetEntry : this.findByExpirationDate(expirationDate, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByExpirationDate(Date expirationDate) {
        FinderPath finderPath = this._finderPathCountByExpirationDate;
        Object[] finderArgs = new Object[]{this._getTime(expirationDate)};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                query.append("assetEntry.expirationDate IS NULL");
            } else {
                bindExpirationDate = true;
                query.append("assetEntry.expirationDate = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindExpirationDate) {
                    qPos.add(new Timestamp(expirationDate.getTime()));
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByLayoutUuid(String layoutUuid) {
        return this.findByLayoutUuid(layoutUuid, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByLayoutUuid(String layoutUuid, int start, int end) {
        return this.findByLayoutUuid(layoutUuid, start, end, null);
    }

    @Override
    public List<AssetEntry> findByLayoutUuid(String layoutUuid, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByLayoutUuid(layoutUuid, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByLayoutUuid(String layoutUuid, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        layoutUuid = Objects.toString(layoutUuid, "");
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByLayoutUuid;
            finderArgs = new Object[]{layoutUuid};
        } else {
            finderPath = this._finderPathWithPaginationFindByLayoutUuid;
            finderArgs = new Object[]{layoutUuid, start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (layoutUuid.equals(assetEntry.getLayoutUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            boolean bindLayoutUuid = false;
            if (layoutUuid.isEmpty()) {
                query.append(_FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_3);
            } else {
                bindLayoutUuid = true;
                query.append(_FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindLayoutUuid) {
                    qPos.add(layoutUuid);
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByLayoutUuid_First(String layoutUuid, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByLayoutUuid_First(layoutUuid, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("layoutUuid=");
        msg.append(layoutUuid);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByLayoutUuid_First(String layoutUuid, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByLayoutUuid(layoutUuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByLayoutUuid_Last(String layoutUuid, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByLayoutUuid_Last(layoutUuid, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("layoutUuid=");
        msg.append(layoutUuid);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByLayoutUuid_Last(String layoutUuid, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByLayoutUuid(layoutUuid);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByLayoutUuid(layoutUuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByLayoutUuid_PrevAndNext(long entryId, String layoutUuid, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        layoutUuid = Objects.toString(layoutUuid, "");
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByLayoutUuid_PrevAndNext(session, assetEntry, layoutUuid, orderByComparator, true), assetEntry, this.getByLayoutUuid_PrevAndNext(session, assetEntry, layoutUuid, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByLayoutUuid_PrevAndNext(Session session, AssetEntry assetEntry, String layoutUuid, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        boolean bindLayoutUuid = false;
        if (layoutUuid.isEmpty()) {
            query.append(_FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_3);
        } else {
            bindLayoutUuid = true;
            query.append(_FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        if (bindLayoutUuid) {
            qPos.add(layoutUuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByLayoutUuid(String layoutUuid) {
        for (AssetEntry assetEntry : this.findByLayoutUuid(layoutUuid, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByLayoutUuid(String layoutUuid) {
        layoutUuid = Objects.toString(layoutUuid, "");
        FinderPath finderPath = this._finderPathCountByLayoutUuid;
        Object[] finderArgs = new Object[]{layoutUuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            boolean bindLayoutUuid = false;
            if (layoutUuid.isEmpty()) {
                query.append(_FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_3);
            } else {
                bindLayoutUuid = true;
                query.append(_FINDER_COLUMN_LAYOUTUUID_LAYOUTUUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                if (bindLayoutUuid) {
                    qPos.add(layoutUuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public AssetEntry findByG_CU(long groupId, String classUuid) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByG_CU(groupId, classUuid);
        if (assetEntry == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("groupId=");
            msg.append(groupId);
            msg.append(", classUuid=");
            msg.append(classUuid);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchEntryException(msg.toString());
        }
        return assetEntry;
    }

    @Override
    public AssetEntry fetchByG_CU(long groupId, String classUuid) {
        return this.fetchByG_CU(groupId, classUuid, true);
    }

    @Override
    public AssetEntry fetchByG_CU(long groupId, String classUuid, boolean retrieveFromCache) {
        AssetEntry assetEntry;
        classUuid = Objects.toString(classUuid, "");
        Object[] finderArgs = new Object[]{groupId, classUuid};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByG_CU, finderArgs, this);
        }
        if (result instanceof AssetEntry && (groupId != (assetEntry = (AssetEntry)result).getGroupId() || !Objects.equals(classUuid, assetEntry.getClassUuid()))) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append("assetEntry.groupId = ? AND ");
            boolean bindClassUuid = false;
            if (classUuid.isEmpty()) {
                query.append(_FINDER_COLUMN_G_CU_CLASSUUID_3);
            } else {
                bindClassUuid = true;
                query.append(_FINDER_COLUMN_G_CU_CLASSUUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindClassUuid) {
                    qPos.add(classUuid);
                }
                if ((list = q.list()).isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByG_CU, finderArgs, list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn("AssetEntryPersistenceImpl.fetchByG_CU(long, String, boolean) with parameters (" + StringUtil.merge(finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder.");
                        }
                    }
                    AssetEntry assetEntry2 = (AssetEntry)list.get(0);
                    result = assetEntry2;
                    this.cacheResult(assetEntry2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByG_CU, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (AssetEntry)result;
    }

    @Override
    public AssetEntry removeByG_CU(long groupId, String classUuid) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByG_CU(groupId, classUuid);
        return this.remove(assetEntry);
    }

    @Override
    public int countByG_CU(long groupId, String classUuid) {
        classUuid = Objects.toString(classUuid, "");
        FinderPath finderPath = this._finderPathCountByG_CU;
        Object[] finderArgs = new Object[]{groupId, classUuid};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append("assetEntry.groupId = ? AND ");
            boolean bindClassUuid = false;
            if (classUuid.isEmpty()) {
                query.append(_FINDER_COLUMN_G_CU_CLASSUUID_3);
            } else {
                bindClassUuid = true;
                query.append(_FINDER_COLUMN_G_CU_CLASSUUID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                if (bindClassUuid) {
                    qPos.add(classUuid);
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public AssetEntry findByC_C(long classNameId, long classPK) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByC_C(classNameId, classPK);
        if (assetEntry == null) {
            StringBundler msg = new StringBundler(6);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("classNameId=");
            msg.append(classNameId);
            msg.append(", classPK=");
            msg.append(classPK);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug(msg.toString());
            }
            throw new NoSuchEntryException(msg.toString());
        }
        return assetEntry;
    }

    @Override
    public AssetEntry fetchByC_C(long classNameId, long classPK) {
        return this.fetchByC_C(classNameId, classPK, true);
    }

    @Override
    public AssetEntry fetchByC_C(long classNameId, long classPK, boolean retrieveFromCache) {
        AssetEntry assetEntry;
        Object[] finderArgs = new Object[]{classNameId, classPK};
        Object result = null;
        if (retrieveFromCache) {
            result = FinderCacheUtil.getResult(this._finderPathFetchByC_C, finderArgs, this);
        }
        if (result instanceof AssetEntry && (classNameId != (assetEntry = (AssetEntry)result).getClassNameId() || classPK != assetEntry.getClassPK())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append("assetEntry.classNameId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(classNameId);
                qPos.add(classPK);
                List list = q.list();
                if (list.isEmpty()) {
                    FinderCacheUtil.putResult(this._finderPathFetchByC_C, finderArgs, list);
                } else {
                    AssetEntry assetEntry2 = (AssetEntry)list.get(0);
                    result = assetEntry2;
                    this.cacheResult(assetEntry2);
                }
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathFetchByC_C, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (AssetEntry)result;
    }

    @Override
    public AssetEntry removeByC_C(long classNameId, long classPK) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByC_C(classNameId, classPK);
        return this.remove(assetEntry);
    }

    @Override
    public int countByC_C(long classNameId, long classPK) {
        FinderPath finderPath = this._finderPathCountByC_C;
        Object[] finderArgs = new Object[]{classNameId, classPK};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append("assetEntry.classNameId = ? AND ");
            query.append(_FINDER_COLUMN_C_C_CLASSPK_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(classNameId);
                qPos.add(classPK);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByG_C_V(long groupId, long classNameId, boolean visible) {
        return this.findByG_C_V(groupId, classNameId, visible, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByG_C_V(long groupId, long classNameId, boolean visible, int start, int end) {
        return this.findByG_C_V(groupId, classNameId, visible, start, end, null);
    }

    @Override
    public List<AssetEntry> findByG_C_V(long groupId, long classNameId, boolean visible, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByG_C_V(groupId, classNameId, visible, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByG_C_V(long groupId, long classNameId, boolean visible, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByG_C_V;
            finderArgs = new Object[]{groupId, classNameId, visible};
        } else {
            finderPath = this._finderPathWithPaginationFindByG_C_V;
            finderArgs = new Object[]{groupId, classNameId, visible, start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (groupId == assetEntry.getGroupId() && classNameId == assetEntry.getClassNameId() && visible == assetEntry.isVisible()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append("assetEntry.groupId = ? AND ");
            query.append("assetEntry.classNameId = ? AND ");
            query.append("assetEntry.visible = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(classNameId);
                qPos.add(visible);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByG_C_V_First(long groupId, long classNameId, boolean visible, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByG_C_V_First(groupId, classNameId, visible, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", visible=");
        msg.append(visible);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByG_C_V_First(long groupId, long classNameId, boolean visible, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByG_C_V(groupId, classNameId, visible, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByG_C_V_Last(long groupId, long classNameId, boolean visible, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByG_C_V_Last(groupId, classNameId, visible, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(8);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", visible=");
        msg.append(visible);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByG_C_V_Last(long groupId, long classNameId, boolean visible, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByG_C_V(groupId, classNameId, visible);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByG_C_V(groupId, classNameId, visible, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByG_C_V_PrevAndNext(long entryId, long groupId, long classNameId, boolean visible, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByG_C_V_PrevAndNext(session, assetEntry, groupId, classNameId, visible, orderByComparator, true), assetEntry, this.getByG_C_V_PrevAndNext(session, assetEntry, groupId, classNameId, visible, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByG_C_V_PrevAndNext(Session session, AssetEntry assetEntry, long groupId, long classNameId, boolean visible, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        query.append("assetEntry.groupId = ? AND ");
        query.append("assetEntry.classNameId = ? AND ");
        query.append("assetEntry.visible = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        qPos.add(classNameId);
        qPos.add(visible);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByG_C_V(long groupId, long classNameId, boolean visible) {
        for (AssetEntry assetEntry : this.findByG_C_V(groupId, classNameId, visible, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByG_C_V(long groupId, long classNameId, boolean visible) {
        FinderPath finderPath = this._finderPathCountByG_C_V;
        Object[] finderArgs = new Object[]{groupId, classNameId, visible};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(4);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append("assetEntry.groupId = ? AND ");
            query.append("assetEntry.classNameId = ? AND ");
            query.append("assetEntry.visible = ?");
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(classNameId);
                qPos.add(visible);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public List<AssetEntry> findByG_C_P_E(long groupId, long classNameId, Date publishDate, Date expirationDate) {
        return this.findByG_C_P_E(groupId, classNameId, publishDate, expirationDate, -1, -1, null);
    }

    @Override
    public List<AssetEntry> findByG_C_P_E(long groupId, long classNameId, Date publishDate, Date expirationDate, int start, int end) {
        return this.findByG_C_P_E(groupId, classNameId, publishDate, expirationDate, start, end, null);
    }

    @Override
    public List<AssetEntry> findByG_C_P_E(long groupId, long classNameId, Date publishDate, Date expirationDate, int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findByG_C_P_E(groupId, classNameId, publishDate, expirationDate, start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findByG_C_P_E(long groupId, long classNameId, Date publishDate, Date expirationDate, int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindByG_C_P_E;
            finderArgs = new Object[]{groupId, classNameId, this._getTime(publishDate), this._getTime(expirationDate)};
        } else {
            finderPath = this._finderPathWithPaginationFindByG_C_P_E;
            finderArgs = new Object[]{groupId, classNameId, this._getTime(publishDate), this._getTime(expirationDate), start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache && (list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this)) != null && !list.isEmpty()) {
            for (AssetEntry assetEntry : list) {
                if (groupId == assetEntry.getGroupId() && classNameId == assetEntry.getClassNameId() && Objects.equals(publishDate, assetEntry.getPublishDate()) && Objects.equals(expirationDate, assetEntry.getExpirationDate())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(6);
            query.append(_SQL_SELECT_ASSETENTRY_WHERE);
            query.append("assetEntry.groupId = ? AND ");
            query.append("assetEntry.classNameId = ? AND ");
            boolean bindPublishDate = false;
            if (publishDate == null) {
                query.append(_FINDER_COLUMN_G_C_P_E_PUBLISHDATE_1);
            } else {
                bindPublishDate = true;
                query.append(_FINDER_COLUMN_G_C_P_E_PUBLISHDATE_2);
            }
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                query.append("assetEntry.expirationDate IS NULL");
            } else {
                bindExpirationDate = true;
                query.append("assetEntry.expirationDate = ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY assetEntry.entryId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(classNameId);
                if (bindPublishDate) {
                    qPos.add(new Timestamp(publishDate.getTime()));
                }
                if (bindExpirationDate) {
                    qPos.add(new Timestamp(expirationDate.getTime()));
                }
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public AssetEntry findByG_C_P_E_First(long groupId, long classNameId, Date publishDate, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByG_C_P_E_First(groupId, classNameId, publishDate, expirationDate, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", publishDate=");
        msg.append(publishDate);
        msg.append(", expirationDate=");
        msg.append(expirationDate);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByG_C_P_E_First(long groupId, long classNameId, Date publishDate, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) {
        List<AssetEntry> list = this.findByG_C_P_E(groupId, classNameId, publishDate, expirationDate, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry findByG_C_P_E_Last(long groupId, long classNameId, Date publishDate, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.fetchByG_C_P_E_Last(groupId, classNameId, publishDate, expirationDate, orderByComparator);
        if (assetEntry != null) {
            return assetEntry;
        }
        StringBundler msg = new StringBundler(10);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("groupId=");
        msg.append(groupId);
        msg.append(", classNameId=");
        msg.append(classNameId);
        msg.append(", publishDate=");
        msg.append(publishDate);
        msg.append(", expirationDate=");
        msg.append(expirationDate);
        msg.append("}");
        throw new NoSuchEntryException(msg.toString());
    }

    @Override
    public AssetEntry fetchByG_C_P_E_Last(long groupId, long classNameId, Date publishDate, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) {
        int count = this.countByG_C_P_E(groupId, classNameId, publishDate, expirationDate);
        if (count == 0) {
            return null;
        }
        List<AssetEntry> list = this.findByG_C_P_E(groupId, classNameId, publishDate, expirationDate, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public AssetEntry[] findByG_C_P_E_PrevAndNext(long entryId, long groupId, long classNameId, Date publishDate, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator) throws NoSuchEntryException {
        AssetEntry assetEntry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry[] array = new AssetEntryImpl[]{this.getByG_C_P_E_PrevAndNext(session, assetEntry, groupId, classNameId, publishDate, expirationDate, orderByComparator, true), assetEntry, this.getByG_C_P_E_PrevAndNext(session, assetEntry, groupId, classNameId, publishDate, expirationDate, orderByComparator, false)};
            AssetEntry[] assetEntryArray = array;
            return assetEntryArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected AssetEntry getByG_C_P_E_PrevAndNext(Session session, AssetEntry assetEntry, long groupId, long classNameId, Date publishDate, Date expirationDate, OrderByComparator<AssetEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(7 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(6);
        query.append(_SQL_SELECT_ASSETENTRY_WHERE);
        query.append("assetEntry.groupId = ? AND ");
        query.append("assetEntry.classNameId = ? AND ");
        boolean bindPublishDate = false;
        if (publishDate == null) {
            query.append(_FINDER_COLUMN_G_C_P_E_PUBLISHDATE_1);
        } else {
            bindPublishDate = true;
            query.append(_FINDER_COLUMN_G_C_P_E_PUBLISHDATE_2);
        }
        boolean bindExpirationDate = false;
        if (expirationDate == null) {
            query.append("assetEntry.expirationDate IS NULL");
        } else {
            bindExpirationDate = true;
            query.append("assetEntry.expirationDate = ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY assetEntry.entryId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance(q);
        qPos.add(groupId);
        qPos.add(classNameId);
        if (bindPublishDate) {
            qPos.add(new Timestamp(publishDate.getTime()));
        }
        if (bindExpirationDate) {
            qPos.add(new Timestamp(expirationDate.getTime()));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues(assetEntry)) {
                qPos.add(orderByConditionValue);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (AssetEntry)list.get(1);
        }
        return null;
    }

    @Override
    public void removeByG_C_P_E(long groupId, long classNameId, Date publishDate, Date expirationDate) {
        for (AssetEntry assetEntry : this.findByG_C_P_E(groupId, classNameId, publishDate, expirationDate, -1, -1, null)) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countByG_C_P_E(long groupId, long classNameId, Date publishDate, Date expirationDate) {
        FinderPath finderPath = this._finderPathCountByG_C_P_E;
        Object[] finderArgs = new Object[]{groupId, classNameId, this._getTime(publishDate), this._getTime(expirationDate)};
        Long count = (Long)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        if (count == null) {
            StringBundler query = new StringBundler(5);
            query.append(_SQL_COUNT_ASSETENTRY_WHERE);
            query.append("assetEntry.groupId = ? AND ");
            query.append("assetEntry.classNameId = ? AND ");
            boolean bindPublishDate = false;
            if (publishDate == null) {
                query.append(_FINDER_COLUMN_G_C_P_E_PUBLISHDATE_1);
            } else {
                bindPublishDate = true;
                query.append(_FINDER_COLUMN_G_C_P_E_PUBLISHDATE_2);
            }
            boolean bindExpirationDate = false;
            if (expirationDate == null) {
                query.append("assetEntry.expirationDate IS NULL");
            } else {
                bindExpirationDate = true;
                query.append("assetEntry.expirationDate = ?");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance(q);
                qPos.add(groupId);
                qPos.add(classNameId);
                if (bindPublishDate) {
                    qPos.add(new Timestamp(publishDate.getTime()));
                }
                if (bindExpirationDate) {
                    qPos.add(new Timestamp(expirationDate.getTime()));
                }
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(finderPath, finderArgs, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public AssetEntryPersistenceImpl() {
        this.setModelClass(AssetEntry.class);
        this.setModelImplClass(AssetEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setEntityCacheEnabled(AssetEntryModelImpl.ENTITY_CACHE_ENABLED);
    }

    @Override
    public void cacheResult(AssetEntry assetEntry) {
        EntityCacheUtil.putResult(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryImpl.class, Long.valueOf(assetEntry.getPrimaryKey()), assetEntry);
        FinderCacheUtil.putResult(this._finderPathFetchByG_CU, new Object[]{assetEntry.getGroupId(), assetEntry.getClassUuid()}, assetEntry);
        FinderCacheUtil.putResult(this._finderPathFetchByC_C, new Object[]{assetEntry.getClassNameId(), assetEntry.getClassPK()}, assetEntry);
        assetEntry.resetOriginalValues();
    }

    @Override
    public void cacheResult(List<AssetEntry> assetEntries) {
        for (AssetEntry assetEntry : assetEntries) {
            if (EntityCacheUtil.getResult(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryImpl.class, Long.valueOf(assetEntry.getPrimaryKey())) == null) {
                this.cacheResult(assetEntry);
                continue;
            }
            assetEntry.resetOriginalValues();
        }
    }

    @Override
    public void clearCache() {
        EntityCacheUtil.clearCache(AssetEntryImpl.class);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Override
    public void clearCache(AssetEntry assetEntry) {
        EntityCacheUtil.removeResult(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryImpl.class, Long.valueOf(assetEntry.getPrimaryKey()));
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((AssetEntryModelImpl)((Object)assetEntry), true);
    }

    @Override
    public void clearCache(List<AssetEntry> assetEntries) {
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (AssetEntry assetEntry : assetEntries) {
            EntityCacheUtil.removeResult(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryImpl.class, Long.valueOf(assetEntry.getPrimaryKey()));
            this.clearUniqueFindersCache((AssetEntryModelImpl)((Object)assetEntry), true);
        }
    }

    protected void cacheUniqueFindersCache(AssetEntryModelImpl assetEntryModelImpl) {
        Object[] args = new Object[]{assetEntryModelImpl.getGroupId(), assetEntryModelImpl.getClassUuid()};
        FinderCacheUtil.putResult(this._finderPathCountByG_CU, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByG_CU, args, assetEntryModelImpl, false);
        args = new Object[]{assetEntryModelImpl.getClassNameId(), assetEntryModelImpl.getClassPK()};
        FinderCacheUtil.putResult(this._finderPathCountByC_C, args, 1L, false);
        FinderCacheUtil.putResult(this._finderPathFetchByC_C, args, assetEntryModelImpl, false);
    }

    protected void clearUniqueFindersCache(AssetEntryModelImpl assetEntryModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{assetEntryModelImpl.getGroupId(), assetEntryModelImpl.getClassUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_CU, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_CU, args);
        }
        if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathFetchByG_CU.getColumnBitmask()) != 0L) {
            args = new Object[]{assetEntryModelImpl.getOriginalGroupId(), assetEntryModelImpl.getOriginalClassUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_CU, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByG_CU, args);
        }
        if (clearCurrent) {
            args = new Object[]{assetEntryModelImpl.getClassNameId(), assetEntryModelImpl.getClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_C, args);
        }
        if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathFetchByC_C.getColumnBitmask()) != 0L) {
            args = new Object[]{assetEntryModelImpl.getOriginalClassNameId(), assetEntryModelImpl.getOriginalClassPK()};
            FinderCacheUtil.removeResult(this._finderPathCountByC_C, args);
            FinderCacheUtil.removeResult(this._finderPathFetchByC_C, args);
        }
    }

    @Override
    public AssetEntry create(long entryId) {
        AssetEntryImpl assetEntry = new AssetEntryImpl();
        assetEntry.setNew(true);
        assetEntry.setPrimaryKey(entryId);
        assetEntry.setCompanyId(this.companyProvider.getCompanyId());
        return assetEntry;
    }

    @Override
    public AssetEntry remove(long entryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(entryId));
    }

    @Override
    public AssetEntry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            AssetEntry assetEntry = (AssetEntry)session.get(AssetEntryImpl.class, primaryKey);
            if (assetEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            AssetEntry assetEntry2 = this.remove(assetEntry);
            return assetEntry2;
        }
        catch (NoSuchEntryException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    protected AssetEntry removeImpl(AssetEntry assetEntry) {
        this.assetEntryToAssetCategoryTableMapper.deleteLeftPrimaryKeyTableMappings(assetEntry.getPrimaryKey());
        this.assetEntryToAssetTagTableMapper.deleteLeftPrimaryKeyTableMappings(assetEntry.getPrimaryKey());
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains(assetEntry)) {
                assetEntry = (AssetEntry)session.get(AssetEntryImpl.class, assetEntry.getPrimaryKeyObj());
            }
            if (assetEntry != null) {
                session.delete(assetEntry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (assetEntry != null) {
            this.clearCache(assetEntry);
        }
        return assetEntry;
    }

    @Override
    public AssetEntry updateImpl(AssetEntry assetEntry) {
        boolean isNew = assetEntry.isNew();
        if (!(assetEntry instanceof AssetEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(assetEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler(assetEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in assetEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom AssetEntry implementation " + assetEntry.getClass());
        }
        AssetEntryModelImpl assetEntryModelImpl = (AssetEntryModelImpl)((Object)assetEntry);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date now = new Date();
        if (isNew && assetEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                assetEntry.setCreateDate(now);
            } else {
                assetEntry.setCreateDate(serviceContext.getCreateDate(now));
            }
        }
        if (!assetEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                assetEntry.setModifiedDate(now);
            } else {
                assetEntry.setModifiedDate(serviceContext.getModifiedDate(now));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (assetEntry.isNew()) {
                session.save(assetEntry);
                assetEntry.setNew(false);
            } else {
                assetEntry = (AssetEntry)session.merge(assetEntry);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!AssetEntryModelImpl.COLUMN_BITMASK_ENABLED) {
            FinderCacheUtil.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{assetEntryModelImpl.getGroupId()};
            FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            args = new Object[]{assetEntryModelImpl.getCompanyId()};
            FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{assetEntryModelImpl.isVisible()};
            FinderCacheUtil.removeResult(this._finderPathCountByVisible, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByVisible, args);
            args = new Object[]{assetEntryModelImpl.getPublishDate()};
            FinderCacheUtil.removeResult(this._finderPathCountByPublishDate, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByPublishDate, args);
            args = new Object[]{assetEntryModelImpl.getExpirationDate()};
            FinderCacheUtil.removeResult(this._finderPathCountByExpirationDate, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByExpirationDate, args);
            args = new Object[]{assetEntryModelImpl.getLayoutUuid()};
            FinderCacheUtil.removeResult(this._finderPathCountByLayoutUuid, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByLayoutUuid, args);
            args = new Object[]{assetEntryModelImpl.getGroupId(), assetEntryModelImpl.getClassNameId(), assetEntryModelImpl.isVisible()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_C_V, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C_V, args);
            args = new Object[]{assetEntryModelImpl.getGroupId(), assetEntryModelImpl.getClassNameId(), assetEntryModelImpl.getPublishDate(), assetEntryModelImpl.getExpirationDate()};
            FinderCacheUtil.removeResult(this._finderPathCountByG_C_P_E, args);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C_P_E, args);
            FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByGroupId.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalGroupId()};
                FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
                args = new Object[]{assetEntryModelImpl.getGroupId()};
                FinderCacheUtil.removeResult(this._finderPathCountByGroupId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByGroupId, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{assetEntryModelImpl.getCompanyId()};
                FinderCacheUtil.removeResult(this._finderPathCountByCompanyId, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByVisible.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalVisible()};
                FinderCacheUtil.removeResult(this._finderPathCountByVisible, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByVisible, args);
                args = new Object[]{assetEntryModelImpl.isVisible()};
                FinderCacheUtil.removeResult(this._finderPathCountByVisible, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByVisible, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByPublishDate.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalPublishDate()};
                FinderCacheUtil.removeResult(this._finderPathCountByPublishDate, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByPublishDate, args);
                args = new Object[]{assetEntryModelImpl.getPublishDate()};
                FinderCacheUtil.removeResult(this._finderPathCountByPublishDate, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByPublishDate, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByExpirationDate.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalExpirationDate()};
                FinderCacheUtil.removeResult(this._finderPathCountByExpirationDate, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByExpirationDate, args);
                args = new Object[]{assetEntryModelImpl.getExpirationDate()};
                FinderCacheUtil.removeResult(this._finderPathCountByExpirationDate, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByExpirationDate, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByLayoutUuid.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalLayoutUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByLayoutUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByLayoutUuid, args);
                args = new Object[]{assetEntryModelImpl.getLayoutUuid()};
                FinderCacheUtil.removeResult(this._finderPathCountByLayoutUuid, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByLayoutUuid, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_C_V.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalGroupId(), assetEntryModelImpl.getOriginalClassNameId(), assetEntryModelImpl.getOriginalVisible()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_C_V, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C_V, args);
                args = new Object[]{assetEntryModelImpl.getGroupId(), assetEntryModelImpl.getClassNameId(), assetEntryModelImpl.isVisible()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_C_V, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C_V, args);
            }
            if ((assetEntryModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByG_C_P_E.getColumnBitmask()) != 0L) {
                args = new Object[]{assetEntryModelImpl.getOriginalGroupId(), assetEntryModelImpl.getOriginalClassNameId(), assetEntryModelImpl.getOriginalPublishDate(), assetEntryModelImpl.getOriginalExpirationDate()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_C_P_E, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C_P_E, args);
                args = new Object[]{assetEntryModelImpl.getGroupId(), assetEntryModelImpl.getClassNameId(), assetEntryModelImpl.getPublishDate(), assetEntryModelImpl.getExpirationDate()};
                FinderCacheUtil.removeResult(this._finderPathCountByG_C_P_E, args);
                FinderCacheUtil.removeResult(this._finderPathWithoutPaginationFindByG_C_P_E, args);
            }
        }
        EntityCacheUtil.putResult(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryImpl.class, Long.valueOf(assetEntry.getPrimaryKey()), assetEntry, false);
        this.clearUniqueFindersCache(assetEntryModelImpl, false);
        this.cacheUniqueFindersCache(assetEntryModelImpl);
        assetEntry.resetOriginalValues();
        return assetEntry;
    }

    @Override
    public AssetEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        AssetEntry assetEntry = (AssetEntry)this.fetchByPrimaryKey(primaryKey);
        if (assetEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return assetEntry;
    }

    @Override
    public AssetEntry findByPrimaryKey(long entryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(entryId));
    }

    @Override
    public AssetEntry fetchByPrimaryKey(long entryId) {
        return (AssetEntry)this.fetchByPrimaryKey(Long.valueOf(entryId));
    }

    @Override
    public List<AssetEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    @Override
    public List<AssetEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    @Override
    public List<AssetEntry> findAll(int start, int end, OrderByComparator<AssetEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    @Override
    public List<AssetEntry> findAll(int start, int end, OrderByComparator<AssetEntry> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = this._finderPathWithoutPaginationFindAll;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List<AssetEntry> list = null;
        if (retrieveFromCache) {
            list = (List<AssetEntry>)FinderCacheUtil.getResult(finderPath, finderArgs, this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_ASSETENTRY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_ASSETENTRY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY assetEntry.entryId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list(q, this.getDialect(), start, end, false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list(q, this.getDialect(), start, end);
                }
                this.cacheResult(list);
                FinderCacheUtil.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    @Override
    public void removeAll() {
        for (AssetEntry assetEntry : this.findAll()) {
            this.remove(assetEntry);
        }
    }

    @Override
    public int countAll() {
        Long count = (Long)FinderCacheUtil.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_ASSETENTRY);
                count = (Long)q.uniqueResult();
                FinderCacheUtil.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, count);
            }
            catch (Exception e) {
                FinderCacheUtil.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    @Override
    public long[] getAssetCategoryPrimaryKeys(long pk) {
        long[] pks = this.assetEntryToAssetCategoryTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    @Override
    public List<AssetCategory> getAssetCategories(long pk) {
        return this.getAssetCategories(pk, -1, -1);
    }

    @Override
    public List<AssetCategory> getAssetCategories(long pk, int start, int end) {
        return this.getAssetCategories(pk, start, end, null);
    }

    @Override
    public List<AssetCategory> getAssetCategories(long pk, int start, int end, OrderByComparator<AssetCategory> orderByComparator) {
        return this.assetEntryToAssetCategoryTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    @Override
    public int getAssetCategoriesSize(long pk) {
        long[] pks = this.assetEntryToAssetCategoryTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    @Override
    public boolean containsAssetCategory(long pk, long assetCategoryPK) {
        return this.assetEntryToAssetCategoryTableMapper.containsTableMapping(pk, assetCategoryPK);
    }

    @Override
    public boolean containsAssetCategories(long pk) {
        return this.getAssetCategoriesSize(pk) > 0;
    }

    @Override
    public void addAssetCategory(long pk, long assetCategoryPK) {
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        if (assetEntry == null) {
            this.assetEntryToAssetCategoryTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, assetCategoryPK);
        } else {
            this.assetEntryToAssetCategoryTableMapper.addTableMapping(assetEntry.getCompanyId(), pk, assetCategoryPK);
        }
    }

    @Override
    public void addAssetCategory(long pk, AssetCategory assetCategory) {
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        if (assetEntry == null) {
            this.assetEntryToAssetCategoryTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, assetCategory.getPrimaryKey());
        } else {
            this.assetEntryToAssetCategoryTableMapper.addTableMapping(assetEntry.getCompanyId(), pk, assetCategory.getPrimaryKey());
        }
    }

    @Override
    public void addAssetCategories(long pk, long[] assetCategoryPKs) {
        long companyId = 0L;
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        companyId = assetEntry == null ? this.companyProvider.getCompanyId() : assetEntry.getCompanyId();
        this.assetEntryToAssetCategoryTableMapper.addTableMappings(companyId, pk, assetCategoryPKs);
    }

    @Override
    public void addAssetCategories(long pk, List<AssetCategory> assetCategories) {
        this.addAssetCategories(pk, ListUtil.toLongArray(assetCategories, AssetCategory.CATEGORY_ID_ACCESSOR));
    }

    @Override
    public void clearAssetCategories(long pk) {
        this.assetEntryToAssetCategoryTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    @Override
    public void removeAssetCategory(long pk, long assetCategoryPK) {
        this.assetEntryToAssetCategoryTableMapper.deleteTableMapping(pk, assetCategoryPK);
    }

    @Override
    public void removeAssetCategory(long pk, AssetCategory assetCategory) {
        this.assetEntryToAssetCategoryTableMapper.deleteTableMapping(pk, assetCategory.getPrimaryKey());
    }

    @Override
    public void removeAssetCategories(long pk, long[] assetCategoryPKs) {
        this.assetEntryToAssetCategoryTableMapper.deleteTableMappings(pk, assetCategoryPKs);
    }

    @Override
    public void removeAssetCategories(long pk, List<AssetCategory> assetCategories) {
        this.removeAssetCategories(pk, ListUtil.toLongArray(assetCategories, AssetCategory.CATEGORY_ID_ACCESSOR));
    }

    @Override
    public void setAssetCategories(long pk, long[] assetCategoryPKs) {
        Set<Long> newAssetCategoryPKsSet = SetUtil.fromArray(assetCategoryPKs);
        Set<Long> oldAssetCategoryPKsSet = SetUtil.fromArray(this.assetEntryToAssetCategoryTableMapper.getRightPrimaryKeys(pk));
        HashSet<Long> removeAssetCategoryPKsSet = new HashSet<Long>(oldAssetCategoryPKsSet);
        removeAssetCategoryPKsSet.removeAll(newAssetCategoryPKsSet);
        this.assetEntryToAssetCategoryTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeAssetCategoryPKsSet));
        newAssetCategoryPKsSet.removeAll(oldAssetCategoryPKsSet);
        long companyId = 0L;
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        companyId = assetEntry == null ? this.companyProvider.getCompanyId() : assetEntry.getCompanyId();
        this.assetEntryToAssetCategoryTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray(newAssetCategoryPKsSet));
    }

    @Override
    public void setAssetCategories(long pk, List<AssetCategory> assetCategories) {
        try {
            long[] assetCategoryPKs = new long[assetCategories.size()];
            for (int i = 0; i < assetCategories.size(); ++i) {
                AssetCategory assetCategory = assetCategories.get(i);
                assetCategoryPKs[i] = assetCategory.getPrimaryKey();
            }
            this.setAssetCategories(pk, assetCategoryPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    public long[] getAssetTagPrimaryKeys(long pk) {
        long[] pks = this.assetEntryToAssetTagTableMapper.getRightPrimaryKeys(pk);
        return (long[])pks.clone();
    }

    @Override
    public List<AssetTag> getAssetTags(long pk) {
        return this.getAssetTags(pk, -1, -1);
    }

    @Override
    public List<AssetTag> getAssetTags(long pk, int start, int end) {
        return this.getAssetTags(pk, start, end, null);
    }

    @Override
    public List<AssetTag> getAssetTags(long pk, int start, int end, OrderByComparator<AssetTag> orderByComparator) {
        return this.assetEntryToAssetTagTableMapper.getRightBaseModels(pk, start, end, orderByComparator);
    }

    @Override
    public int getAssetTagsSize(long pk) {
        long[] pks = this.assetEntryToAssetTagTableMapper.getRightPrimaryKeys(pk);
        return pks.length;
    }

    @Override
    public boolean containsAssetTag(long pk, long assetTagPK) {
        return this.assetEntryToAssetTagTableMapper.containsTableMapping(pk, assetTagPK);
    }

    @Override
    public boolean containsAssetTags(long pk) {
        return this.getAssetTagsSize(pk) > 0;
    }

    @Override
    public void addAssetTag(long pk, long assetTagPK) {
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        if (assetEntry == null) {
            this.assetEntryToAssetTagTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, assetTagPK);
        } else {
            this.assetEntryToAssetTagTableMapper.addTableMapping(assetEntry.getCompanyId(), pk, assetTagPK);
        }
    }

    @Override
    public void addAssetTag(long pk, AssetTag assetTag) {
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        if (assetEntry == null) {
            this.assetEntryToAssetTagTableMapper.addTableMapping(this.companyProvider.getCompanyId(), pk, assetTag.getPrimaryKey());
        } else {
            this.assetEntryToAssetTagTableMapper.addTableMapping(assetEntry.getCompanyId(), pk, assetTag.getPrimaryKey());
        }
    }

    @Override
    public void addAssetTags(long pk, long[] assetTagPKs) {
        long companyId = 0L;
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        companyId = assetEntry == null ? this.companyProvider.getCompanyId() : assetEntry.getCompanyId();
        this.assetEntryToAssetTagTableMapper.addTableMappings(companyId, pk, assetTagPKs);
    }

    @Override
    public void addAssetTags(long pk, List<AssetTag> assetTags) {
        this.addAssetTags(pk, ListUtil.toLongArray(assetTags, AssetTag.TAG_ID_ACCESSOR));
    }

    @Override
    public void clearAssetTags(long pk) {
        this.assetEntryToAssetTagTableMapper.deleteLeftPrimaryKeyTableMappings(pk);
    }

    @Override
    public void removeAssetTag(long pk, long assetTagPK) {
        this.assetEntryToAssetTagTableMapper.deleteTableMapping(pk, assetTagPK);
    }

    @Override
    public void removeAssetTag(long pk, AssetTag assetTag) {
        this.assetEntryToAssetTagTableMapper.deleteTableMapping(pk, assetTag.getPrimaryKey());
    }

    @Override
    public void removeAssetTags(long pk, long[] assetTagPKs) {
        this.assetEntryToAssetTagTableMapper.deleteTableMappings(pk, assetTagPKs);
    }

    @Override
    public void removeAssetTags(long pk, List<AssetTag> assetTags) {
        this.removeAssetTags(pk, ListUtil.toLongArray(assetTags, AssetTag.TAG_ID_ACCESSOR));
    }

    @Override
    public void setAssetTags(long pk, long[] assetTagPKs) {
        Set<Long> newAssetTagPKsSet = SetUtil.fromArray(assetTagPKs);
        Set<Long> oldAssetTagPKsSet = SetUtil.fromArray(this.assetEntryToAssetTagTableMapper.getRightPrimaryKeys(pk));
        HashSet<Long> removeAssetTagPKsSet = new HashSet<Long>(oldAssetTagPKsSet);
        removeAssetTagPKsSet.removeAll(newAssetTagPKsSet);
        this.assetEntryToAssetTagTableMapper.deleteTableMappings(pk, ArrayUtil.toLongArray(removeAssetTagPKsSet));
        newAssetTagPKsSet.removeAll(oldAssetTagPKsSet);
        long companyId = 0L;
        AssetEntry assetEntry = this.fetchByPrimaryKey(pk);
        companyId = assetEntry == null ? this.companyProvider.getCompanyId() : assetEntry.getCompanyId();
        this.assetEntryToAssetTagTableMapper.addTableMappings(companyId, pk, ArrayUtil.toLongArray(newAssetTagPKsSet));
    }

    @Override
    public void setAssetTags(long pk, List<AssetTag> assetTags) {
        try {
            long[] assetTagPKs = new long[assetTags.size()];
            for (int i = 0; i < assetTags.size(); ++i) {
                AssetTag assetTag = assetTags.get(i);
                assetTagPKs[i] = assetTag.getPrimaryKey();
            }
            this.setAssetTags(pk, assetTagPKs);
        }
        catch (Exception e) {
            throw this.processException(e);
        }
    }

    @Override
    protected EntityCache getEntityCache() {
        return EntityCacheUtil.getEntityCache();
    }

    @Override
    protected String getPKDBName() {
        return "entryId";
    }

    @Override
    protected String getSelectSQL() {
        return _SQL_SELECT_ASSETENTRY;
    }

    @Override
    protected Map<String, Integer> getTableColumnsMap() {
        return AssetEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
        this.assetEntryToAssetCategoryTableMapper = TableMapperFactory.getTableMapper("AssetEntries_AssetCategories", "companyId", "entryId", "categoryId", this, this.assetCategoryPersistence);
        this.assetEntryToAssetTagTableMapper = TableMapperFactory.getTableMapper("AssetEntries_AssetTags", "companyId", "entryId", "tagId", this, this.assetTagPersistence);
        this._finderPathWithPaginationFindAll = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByGroupId = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByGroupId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByGroupId = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByGroupId", new String[]{Long.class.getName()}, 32L);
        this._finderPathCountByGroupId = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByGroupId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 8L);
        this._finderPathCountByCompanyId = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByVisible = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByVisible", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByVisible = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByVisible", new String[]{Boolean.class.getName()}, 256L);
        this._finderPathCountByVisible = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByVisible", new String[]{Boolean.class.getName()});
        this._finderPathWithPaginationFindByPublishDate = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByPublishDate", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByPublishDate = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByPublishDate", new String[]{Date.class.getName()}, 128L);
        this._finderPathCountByPublishDate = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByPublishDate", new String[]{Date.class.getName()});
        this._finderPathWithPaginationFindByExpirationDate = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByExpirationDate", new String[]{Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByExpirationDate = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByExpirationDate", new String[]{Date.class.getName()}, 16L);
        this._finderPathCountByExpirationDate = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByExpirationDate", new String[]{Date.class.getName()});
        this._finderPathWithPaginationFindByLayoutUuid = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByLayoutUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByLayoutUuid = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByLayoutUuid", new String[]{String.class.getName()}, 64L);
        this._finderPathCountByLayoutUuid = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLayoutUuid", new String[]{String.class.getName()});
        this._finderPathFetchByG_CU = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByG_CU", new String[]{Long.class.getName(), String.class.getName()}, 36L);
        this._finderPathCountByG_CU = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_CU", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathFetchByC_C = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_C", new String[]{Long.class.getName(), Long.class.getName()}, 3L);
        this._finderPathCountByC_C = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_C", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByG_C_V = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C_V", new String[]{Long.class.getName(), Long.class.getName(), Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_C_V = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C_V", new String[]{Long.class.getName(), Long.class.getName(), Boolean.class.getName()}, 289L);
        this._finderPathCountByG_C_V = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C_V", new String[]{Long.class.getName(), Long.class.getName(), Boolean.class.getName()});
        this._finderPathWithPaginationFindByG_C_P_E = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_C_P_E", new String[]{Long.class.getName(), Long.class.getName(), Date.class.getName(), Date.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByG_C_P_E = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, AssetEntryImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_C_P_E", new String[]{Long.class.getName(), Long.class.getName(), Date.class.getName(), Date.class.getName()}, 177L);
        this._finderPathCountByG_C_P_E = new FinderPath(AssetEntryModelImpl.ENTITY_CACHE_ENABLED, AssetEntryModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C_P_E", new String[]{Long.class.getName(), Long.class.getName(), Date.class.getName(), Date.class.getName()});
    }

    public void destroy() {
        EntityCacheUtil.removeCache(AssetEntryImpl.class.getName());
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_ENTITY);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        FinderCacheUtil.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        TableMapperFactory.removeTableMapper("AssetEntries_AssetCategories");
        TableMapperFactory.removeTableMapper("AssetEntries_AssetTags");
    }

    private Long _getTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }
}

