/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.AssetVocabularyDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetVocabularyServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoriesPermission;
import com.liferay.portlet.asset.service.permission.AssetVocabularyPermission;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetVocabularyServiceImpl
extends AssetVocabularyServiceBaseImpl {
    @Override
    public AssetVocabulary addVocabulary(long groupId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), groupId, title, titleMap, descriptionMap, settings, serviceContext);
    }

    @Override
    public AssetVocabulary addVocabulary(long groupId, String title, ServiceContext serviceContext) throws PortalException {
        AssetCategoriesPermission.check(this.getPermissionChecker(), groupId, "ADD_VOCABULARY");
        return this.assetVocabularyLocalService.addVocabulary(this.getUserId(), groupId, title, serviceContext);
    }

    @Override
    public List<AssetVocabulary> deleteVocabularies(long[] vocabularyIds, ServiceContext serviceContext) throws PortalException {
        ArrayList<AssetVocabulary> failedVocabularies = new ArrayList<AssetVocabulary>();
        for (long vocabularyId : vocabularyIds) {
            try {
                AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
                this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
            }
            catch (PortalException pe) {
                if (serviceContext == null) {
                    return null;
                }
                if (serviceContext.isFailOnPortalException()) {
                    throw pe;
                }
                AssetVocabulary vocabulary = this.assetVocabularyPersistence.fetchByPrimaryKey(vocabularyId);
                if (vocabulary == null) {
                    vocabulary = this.assetVocabularyPersistence.create(vocabularyId);
                }
                failedVocabularies.add(vocabulary);
            }
        }
        return failedVocabularies;
    }

    @Override
    public void deleteVocabulary(long vocabularyId) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "DELETE");
        this.assetVocabularyLocalService.deleteVocabulary(vocabularyId);
    }

    @Override
    public AssetVocabulary fetchVocabulary(long vocabularyId) throws PortalException {
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.fetchAssetVocabulary(vocabularyId);
        if (vocabulary != null) {
            AssetVocabularyPermission.check(this.getPermissionChecker(), vocabulary, "VIEW");
        }
        return vocabulary;
    }

    @Override
    @Deprecated
    public List<AssetVocabulary> getCompanyVocabularies(long companyId) throws PortalException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getCompanyVocabularies(companyId));
    }

    @Override
    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds) {
        return this.getGroupsVocabularies(groupIds, null);
    }

    @Override
    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className) {
        return this.getGroupsVocabularies(groupIds, className, -1L);
    }

    @Override
    public List<AssetVocabulary> getGroupsVocabularies(long[] groupIds, String className, long classTypePK) {
        List<AssetVocabulary> vocabularies = this.assetVocabularyPersistence.filterFindByGroupId(groupIds);
        if (Validator.isNull(className)) {
            return vocabularies;
        }
        return AssetUtil.filterVocabularies(vocabularies, className, classTypePK);
    }

    @Override
    public List<AssetVocabulary> getGroupVocabularies(long groupId) throws PortalException {
        return this.getGroupVocabularies(groupId, true);
    }

    @Override
    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean createDefaultVocabulary) throws PortalException {
        return this.getGroupVocabularies(groupId, createDefaultVocabulary, -1, -1, null);
    }

    @Override
    public List<AssetVocabulary> getGroupVocabularies(long groupId, boolean createDefaultVocabulary, int start, int end, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        List<AssetVocabulary> vocabularies = this.getGroupVocabularies(groupId, start, end, obc);
        if (!vocabularies.isEmpty() || !createDefaultVocabulary) {
            return vocabularies;
        }
        int count = this.assetVocabularyLocalService.getGroupVocabulariesCount(new long[]{groupId});
        if (count > 0) {
            return vocabularies;
        }
        vocabularies = new ArrayList<AssetVocabulary>();
        AssetVocabulary vocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
        vocabularies.add(vocabulary);
        return vocabularies;
    }

    @Override
    public List<AssetVocabulary> getGroupVocabularies(long groupId, int start, int end, OrderByComparator<AssetVocabulary> obc) {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupId, start, end, obc);
    }

    @Override
    public List<AssetVocabulary> getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) {
        return this.assetVocabularyPersistence.filterFindByG_LikeN(groupId, name, start, end, obc);
    }

    @Override
    public List<AssetVocabulary> getGroupVocabularies(long[] groupIds) {
        return this.assetVocabularyPersistence.filterFindByGroupId(groupIds);
    }

    @Override
    public int getGroupVocabulariesCount(long groupId) {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupId);
    }

    @Override
    public int getGroupVocabulariesCount(long groupId, String name) {
        return this.assetVocabularyPersistence.filterCountByG_LikeN(groupId, name);
    }

    @Override
    public int getGroupVocabulariesCount(long[] groupIds) {
        return this.assetVocabularyPersistence.filterCountByGroupId(groupIds);
    }

    @Override
    public AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, boolean addDefaultVocabulary, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        List<AssetVocabulary> vocabularies;
        int total = 0;
        if (Validator.isNotNull(name)) {
            name = CustomSQLUtil.keywords(name)[0];
            vocabularies = this.getGroupVocabularies(groupId, name, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId, name);
        } else {
            vocabularies = this.getGroupVocabularies(groupId, start, end, obc);
            total = this.getGroupVocabulariesCount(groupId);
        }
        if (addDefaultVocabulary && total == 0 && this.assetVocabularyPersistence.countByGroupId(groupId) == 0) {
            vocabularies = new ArrayList<AssetVocabulary>();
            vocabularies.add(this.assetVocabularyLocalService.addDefaultVocabulary(groupId));
            total = 1;
        }
        return new AssetVocabularyDisplay(vocabularies, total, start, end);
    }

    @Override
    public AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) throws PortalException {
        return this.getGroupVocabulariesDisplay(groupId, name, start, end, false, obc);
    }

    @Override
    @Deprecated
    public List<AssetVocabulary> getVocabularies(long[] vocabularyIds) throws PortalException {
        return this.filterVocabularies(this.assetVocabularyLocalService.getVocabularies(vocabularyIds));
    }

    @Override
    public AssetVocabulary getVocabulary(long vocabularyId) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "VIEW");
        return this.assetVocabularyLocalService.getVocabulary(vocabularyId);
    }

    @Override
    public AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, boolean addDefaultVocabulary, int start, int end) throws PortalException {
        return this.searchVocabulariesDisplay(groupId, title, addDefaultVocabulary, start, end, null);
    }

    @Override
    public AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, boolean addDefaultVocabulary, int start, int end, Sort sort) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult<AssetVocabulary> baseModelSearchResult = this.assetVocabularyLocalService.searchVocabularies(user.getCompanyId(), groupId, title, start, end, sort);
        List<AssetVocabulary> vocabularies = baseModelSearchResult.getBaseModels();
        int total = baseModelSearchResult.getLength();
        if (addDefaultVocabulary && total == 0 && (total = this.assetVocabularyPersistence.countByGroupId(groupId)) == 0) {
            vocabularies = new ArrayList<AssetVocabulary>(1);
            AssetVocabulary defaultVocabulary = this.assetVocabularyLocalService.addDefaultVocabulary(groupId);
            vocabularies.add(defaultVocabulary);
            total = 1;
        }
        return new AssetVocabularyDisplay(vocabularies, total, start, end);
    }

    @Override
    public AssetVocabulary updateVocabulary(long vocabularyId, String title, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, String settings, ServiceContext serviceContext) throws PortalException {
        AssetVocabularyPermission.check(this.getPermissionChecker(), vocabularyId, "UPDATE");
        return this.assetVocabularyLocalService.updateVocabulary(vocabularyId, title, titleMap, descriptionMap, settings, serviceContext);
    }

    @Deprecated
    protected List<AssetVocabulary> filterVocabularies(List<AssetVocabulary> vocabularies) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        vocabularies = ListUtil.copy(vocabularies);
        Iterator<AssetVocabulary> itr = vocabularies.iterator();
        while (itr.hasNext()) {
            AssetVocabulary vocabulary = itr.next();
            if (AssetVocabularyPermission.contains(permissionChecker, vocabulary, "VIEW")) continue;
            itr.remove();
        }
        return vocabularies;
    }
}

