/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.exception.AssetTagException;
import com.liferay.asset.kernel.exception.AssetTagNameException;
import com.liferay.asset.kernel.exception.DuplicateTagException;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetTagLocalServiceBaseImpl;
import com.liferay.portlet.asset.util.AssetUtil;
import com.liferay.portlet.asset.util.comparator.AssetTagNameComparator;
import com.liferay.social.kernel.util.SocialCounterPeriodUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class AssetTagLocalServiceImpl
extends AssetTagLocalServiceBaseImpl {
    @Override
    @Indexable(type=IndexableType.REINDEX)
    public AssetTag addTag(long userId, long groupId, String name, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        long tagId = this.counterLocalService.increment();
        AssetTag tag = this.assetTagPersistence.create(tagId);
        tag.setUuid(serviceContext.getUuid());
        tag.setGroupId(groupId);
        tag.setCompanyId(user.getCompanyId());
        tag.setUserId(user.getUserId());
        tag.setUserName(user.getFullName());
        name = StringUtil.toLowerCase(StringUtil.trim(name));
        this.validate(name);
        if (this.hasTag(groupId, name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        tag.setName(name);
        this.assetTagPersistence.update(tag);
        return tag;
    }

    @Override
    public List<AssetTag> checkTags(long userId, Group group, String[] names) throws PortalException {
        ArrayList<AssetTag> tags = new ArrayList<AssetTag>();
        for (String name : names) {
            name = StringUtil.toLowerCase(StringUtil.trim(name));
            AssetTag tag = this.fetchTag(group.getGroupId(), name);
            if (tag == null) {
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                serviceContext.setScopeGroupId(group.getGroupId());
                tag = this.addTag(userId, group.getGroupId(), name, serviceContext);
            }
            if (tag == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    @Override
    public List<AssetTag> checkTags(long userId, long groupId, String[] names) throws PortalException {
        Group group = this.groupLocalService.getGroup(groupId);
        return this.checkTags(userId, group, names);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public AssetTag decrementAssetCount(long tagId, long classNameId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(Math.max(0, tag.getAssetCount() - 1));
        this.assetTagPersistence.update(tag);
        return tag;
    }

    @Override
    public void deleteGroupTags(long groupId) throws PortalException {
        List<AssetTag> tags = this.getGroupTags(groupId);
        for (AssetTag tag : tags) {
            this.assetTagLocalService.deleteTag(tag);
        }
    }

    @Override
    @SystemEvent(type=1)
    public void deleteTag(AssetTag tag) throws PortalException {
        List<AssetEntry> entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
        this.assetTagPersistence.remove(tag);
        this.assetEntryLocalService.reindex(entries);
        Indexer<AssetTag> indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetTag.class);
        indexer.delete(tag);
    }

    @Override
    public void deleteTag(long tagId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        this.assetTagLocalService.deleteTag(tag);
    }

    @Override
    public AssetTag fetchTag(long groupId, String name) {
        return this.assetTagPersistence.fetchByG_N(groupId, name);
    }

    @Override
    public List<AssetTag> getEntryTags(long entryId) {
        return this.assetEntryPersistence.getAssetTags(entryId);
    }

    @Override
    public List<AssetTag> getGroupsTags(long[] groupIds) {
        ArrayList<AssetTag> groupsTags = new ArrayList<AssetTag>();
        for (long groupId : groupIds) {
            List<AssetTag> groupTags = this.getGroupTags(groupId);
            groupsTags.addAll(groupTags);
        }
        return groupsTags;
    }

    @Override
    public List<AssetTag> getGroupTags(long groupId) {
        return this.assetTagPersistence.findByGroupId(groupId);
    }

    @Override
    public List<AssetTag> getGroupTags(long groupId, int start, int end) {
        return this.assetTagPersistence.findByGroupId(groupId, start, end);
    }

    @Override
    public int getGroupTagsCount(long groupId) {
        return this.assetTagPersistence.countByGroupId(groupId);
    }

    @Override
    public List<AssetTag> getSocialActivityCounterOffsetTags(long groupId, String socialActivityCounterName, int startOffset, int endOffset) {
        int startPeriod = SocialCounterPeriodUtil.getStartPeriod(startOffset);
        int endPeriod = SocialCounterPeriodUtil.getEndPeriod(endOffset);
        return this.getSocialActivityCounterPeriodTags(groupId, socialActivityCounterName, startPeriod, endPeriod);
    }

    @Override
    public List<AssetTag> getSocialActivityCounterPeriodTags(long groupId, String socialActivityCounterName, int startPeriod, int endPeriod) {
        int offset = SocialCounterPeriodUtil.getOffset(endPeriod);
        int periodLength = SocialCounterPeriodUtil.getPeriodLength(offset);
        return this.assetTagFinder.findByG_N_S_E(groupId, socialActivityCounterName, startPeriod, endPeriod, periodLength);
    }

    @Override
    public AssetTag getTag(long tagId) throws PortalException {
        return this.assetTagPersistence.findByPrimaryKey(tagId);
    }

    @Override
    public AssetTag getTag(long groupId, String name) throws PortalException {
        return this.assetTagPersistence.findByG_N(groupId, name);
    }

    @Override
    public long[] getTagIds(long groupId, String[] names) {
        ArrayList<Long> tagIds = new ArrayList<Long>(names.length);
        for (String name : names) {
            AssetTag tag = this.fetchTag(groupId, name);
            if (tag == null) continue;
            tagIds.add(tag.getTagId());
        }
        return ArrayUtil.toArray(tagIds.toArray(new Long[0]));
    }

    @Override
    public long[] getTagIds(long[] groupIds, String name) {
        ArrayList<Long> tagIds = new ArrayList<Long>(groupIds.length);
        for (long groupId : groupIds) {
            AssetTag tag = this.fetchTag(groupId, name);
            if (tag == null) continue;
            tagIds.add(tag.getTagId());
        }
        return ArrayUtil.toArray(tagIds.toArray(new Long[0]));
    }

    @Override
    public long[] getTagIds(long[] groupIds, String[] names) {
        long[] tagsIds = new long[]{};
        for (long groupId : groupIds) {
            tagsIds = ArrayUtil.append(tagsIds, this.getTagIds(groupId, names));
        }
        return tagsIds;
    }

    @Override
    public long[] getTagIds(String name) {
        List<AssetTag> tags = this.assetTagPersistence.findByName(name);
        ArrayList<Long> tagIds = new ArrayList<Long>(tags.size());
        for (AssetTag tag : tags) {
            tagIds.add(tag.getTagId());
        }
        return ArrayUtil.toArray(tagIds.toArray(new Long[0]));
    }

    @Override
    public String[] getTagNames() {
        return this.getTagNames(this.getTags());
    }

    @Override
    public String[] getTagNames(long classNameId, long classPK) {
        return this.getTagNames(this.getTags(classNameId, classPK));
    }

    @Override
    public String[] getTagNames(String className, long classPK) {
        return this.getTagNames(this.getTags(className, classPK));
    }

    @Override
    public List<AssetTag> getTags() {
        return this.assetTagPersistence.findAll();
    }

    @Override
    public List<AssetTag> getTags(long classNameId, long classPK) {
        AssetEntry entry = this.assetEntryPersistence.fetchByC_C(classNameId, classPK);
        if (entry == null) {
            return Collections.emptyList();
        }
        return this.assetEntryPersistence.getAssetTags(entry.getEntryId());
    }

    @Override
    public List<AssetTag> getTags(long groupId, long classNameId, String name) {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, -1, -1, null);
    }

    @Override
    public List<AssetTag> getTags(long groupId, long classNameId, String name, int start, int end) {
        return this.assetTagFinder.findByG_C_N(groupId, classNameId, name, start, end, null);
    }

    @Override
    @ThreadLocalCachable
    public List<AssetTag> getTags(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.getTags(classNameId, classPK);
    }

    @Override
    public int getTagsSize(long groupId, long classNameId, String name) {
        return this.assetTagFinder.countByG_C_N(groupId, classNameId, name);
    }

    @Override
    public int getTagsSize(long groupId, String name) {
        return this.assetTagFinder.countByG_N(groupId, name);
    }

    @Override
    public boolean hasTag(long groupId, String name) {
        AssetTag tag = this.fetchTag(groupId, name);
        return tag != null;
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public AssetTag incrementAssetCount(long tagId, long classNameId) throws PortalException {
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        tag.setAssetCount(tag.getAssetCount() + 1);
        this.assetTagPersistence.update(tag);
        return tag;
    }

    @Override
    public void mergeTags(long fromTagId, long toTagId) throws PortalException {
        List<AssetEntry> entries = this.assetTagPersistence.getAssetEntries(fromTagId);
        this.assetTagPersistence.addAssetEntries(toTagId, entries);
        this.deleteTag(fromTagId);
        for (AssetEntry entry : entries) {
            this.incrementAssetCount(toTagId, entry.getClassNameId());
        }
    }

    @Override
    public List<AssetTag> search(long groupId, String name, int start, int end) {
        return this.search(new long[]{groupId}, name, start, end);
    }

    @Override
    public List<AssetTag> search(long[] groupIds, String name, int start, int end) {
        return this.assetTagPersistence.findByG_LikeN(groupIds, name, start, end, (OrderByComparator<AssetTag>)new AssetTagNameComparator());
    }

    @Override
    public BaseModelSearchResult<AssetTag> searchTags(long[] groupIds, String name, int start, int end, Sort sort) throws PortalException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        SearchContext searchContext = this.buildSearchContext(serviceContext.getCompanyId(), groupIds, name, start, end, sort);
        return this.searchTags(searchContext);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public AssetTag updateTag(long userId, long tagId, String name, ServiceContext serviceContext) throws PortalException {
        AssetTag existingAssetTag;
        AssetTag tag = this.assetTagPersistence.findByPrimaryKey(tagId);
        String oldName = tag.getName();
        if (!(name = StringUtil.toLowerCase(StringUtil.trim(name))).equals(tag.getName()) && this.hasTag(tag.getGroupId(), name)) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        String tagName = tag.getName();
        if (!tagName.equals(name) && (existingAssetTag = this.fetchTag(tag.getGroupId(), name)) != null && existingAssetTag.getTagId() != tagId) {
            throw new DuplicateTagException("A tag with the name " + name + " already exists");
        }
        this.validate(name);
        tag.setName(name);
        this.assetTagPersistence.update(tag);
        if (!oldName.equals(name)) {
            List<AssetEntry> entries = this.assetTagPersistence.getAssetEntries(tag.getTagId());
            this.assetEntryLocalService.reindex(entries);
        }
        return tag;
    }

    protected SearchContext buildSearchContext(long companyId, long[] groupIds, String name, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("name", (Serializable)((Object)name));
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setGroupIds(groupIds);
        searchContext.setKeywords(name);
        searchContext.setStart(start);
        if (sort != null) {
            searchContext.setSorts(sort);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected String[] getTagNames(List<AssetTag> tags) {
        return ListUtil.toArray(tags, AssetTag.NAME_ACCESSOR);
    }

    protected List<AssetTag> getTags(Hits hits) throws PortalException {
        List<Document> documents = hits.toList();
        ArrayList<AssetTag> tags = new ArrayList<AssetTag>(documents.size());
        for (Document document : documents) {
            long tagId = GetterUtil.getLong(document.get("entryClassPK"));
            AssetTag tag = this.fetchAssetTag(tagId);
            if (tag == null) {
                tags = null;
                Indexer<AssetTag> indexer = IndexerRegistryUtil.getIndexer(AssetTag.class);
                long companyId = GetterUtil.getLong(document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            if (tags == null) continue;
            tags.add(tag);
        }
        return tags;
    }

    protected BaseModelSearchResult<AssetTag> searchTags(SearchContext searchContext) throws PortalException {
        Indexer<AssetTag> indexer = IndexerRegistryUtil.nullSafeGetIndexer(AssetTag.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<AssetTag> tags = this.getTags(hits);
            if (tags == null) continue;
            return new BaseModelSearchResult<AssetTag>(tags, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull(name)) {
            throw new AssetTagNameException("Tag name cannot be an empty string");
        }
        if (!AssetUtil.isValidWord(name)) {
            throw new AssetTagException(StringUtil.merge(AssetUtil.INVALID_CHARACTERS, " "), 2);
        }
        int maxLength = ModelHintsUtil.getMaxLength(AssetTag.class.getName(), "name");
        if (name.length() > maxLength) {
            throw new AssetTagException("Tag name has more than " + maxLength + " characters", 3);
        }
    }
}

