/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlled;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.asset.service.base.AssetEntryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetEntryPermission;
import com.liferay.portlet.asset.util.AssetUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AssetEntryServiceImpl
extends AssetEntryServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryServiceImpl.class);

    @Override
    public AssetEntry fetchEntry(long entryId) throws PortalException {
        AssetEntry entry = this.assetEntryLocalService.fetchEntry(entryId);
        if (entry != null) {
            AssetEntryPermission.check(this.getPermissionChecker(), entry, "VIEW");
        }
        return entry;
    }

    @Override
    public List<AssetEntry> getCompanyEntries(long companyId, int start, int end) {
        ArrayList<AssetEntry> entries = new ArrayList<AssetEntry>();
        List<AssetEntry> companyEntries = this.assetEntryLocalService.getCompanyEntries(companyId, start, end);
        for (AssetEntry entry : companyEntries) {
            try {
                if (!AssetEntryPermission.contains(this.getPermissionChecker(), entry, "VIEW")) continue;
                entries.add(entry);
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(pe, pe);
            }
        }
        return entries;
    }

    @Override
    public int getCompanyEntriesCount(long companyId) {
        return this.assetEntryLocalService.getCompanyEntriesCount(companyId);
    }

    @Override
    public List<AssetEntry> getEntries(AssetEntryQuery entryQuery) throws PortalException {
        AssetEntryQuery filteredEntryQuery = this.buildFilteredEntryQuery(entryQuery);
        if (this.hasEntryQueryResults(entryQuery, filteredEntryQuery)) {
            return new ArrayList<AssetEntry>();
        }
        Object[] results = this.filterEntryQuery(filteredEntryQuery, false);
        return (List)results[0];
    }

    @Override
    public int getEntriesCount(AssetEntryQuery entryQuery) throws PortalException {
        AssetEntryQuery filteredEntryQuery = this.buildFilteredEntryQuery(entryQuery);
        if (this.hasEntryQueryResults(entryQuery, filteredEntryQuery)) {
            return 0;
        }
        Object[] results = this.filterEntryQuery(filteredEntryQuery, true);
        return (Integer)results[1];
    }

    @Override
    public AssetEntry getEntry(long entryId) throws PortalException {
        AssetEntry entry = this.assetEntryLocalService.getEntry(entryId);
        AssetEntryPermission.check(this.getPermissionChecker(), entry, "VIEW");
        return entry;
    }

    @Override
    public void incrementViewCounter(AssetEntry assetEntry) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), assetEntry, "VIEW");
        this.assetEntryLocalService.incrementViewCounter(this.getGuestOrUserId(), assetEntry);
    }

    @Override
    @AccessControlled(guestAccessEnabled=true)
    public AssetEntry incrementViewCounter(String className, long classPK) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "VIEW");
        return this.assetEntryLocalService.incrementViewCounter(this.getGuestOrUserId(), className, classPK);
    }

    @Override
    public AssetEntry updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean listable, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Double priority) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, listable, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority);
    }

    @Override
    @Deprecated
    public AssetEntry updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean listable, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Double priority) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, listable, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority);
    }

    @Override
    @Deprecated
    public AssetEntry updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws PortalException {
        AssetEntryPermission.check(this.getPermissionChecker(), className, classPK, "UPDATE");
        return this.assetEntryLocalService.updateEntry(this.getUserId(), groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
    }

    protected AssetEntryQuery buildFilteredEntryQuery(AssetEntryQuery entryQuery) throws PortalException {
        AssetEntryQuery filteredEntryQuery = new AssetEntryQuery(entryQuery);
        filteredEntryQuery.setAllCategoryIds(AssetUtil.filterCategoryIds(this.getPermissionChecker(), entryQuery.getAllCategoryIds()));
        filteredEntryQuery.setAllTagIdsArray(entryQuery.getAllTagIdsArray());
        filteredEntryQuery.setAnyCategoryIds(AssetUtil.filterCategoryIds(this.getPermissionChecker(), entryQuery.getAnyCategoryIds()));
        filteredEntryQuery.setAnyTagIds(entryQuery.getAnyTagIds());
        return filteredEntryQuery;
    }

    protected Object[] filterEntryQuery(AssetEntryQuery entryQuery, boolean returnEntriesCountOnly) throws PortalException {
        ThreadLocalCache<Object[]> threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache(Lifecycle.REQUEST, (Serializable)((Object)AssetEntryServiceImpl.class.getName()));
        String key = entryQuery.toString();
        Object[] results = (Object[])threadLocalCache.get(key = key.concat("#").concat(Boolean.toString(returnEntriesCountOnly)));
        if (results != null) {
            return results;
        }
        List<AssetEntry> entries = null;
        int count = 0;
        if (!entryQuery.isEnablePermissions()) {
            if (returnEntriesCountOnly) {
                count = this.assetEntryLocalService.getEntriesCount(entryQuery);
                results = new Object[]{null, count};
            } else {
                entries = this.assetEntryLocalService.getEntries(entryQuery);
                results = new Object[]{entries, entries.size()};
            }
        } else {
            int end = entryQuery.getEnd();
            int start = entryQuery.getStart();
            entryQuery.setEnd(end + PropsValues.ASSET_FILTER_SEARCH_LIMIT);
            entryQuery.setStart(0);
            entries = this.assetEntryLocalService.getEntries(entryQuery);
            List<AssetEntry> filteredEntries = new ArrayList();
            PermissionChecker permissionChecker = this.getPermissionChecker();
            for (AssetEntry entry : entries) {
                String className = entry.getClassName();
                long classPK = entry.getClassPK();
                AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(className);
                try {
                    if (!assetRendererFactory.hasPermission(permissionChecker, classPK, "VIEW")) continue;
                    filteredEntries.add(entry);
                }
                catch (Exception exception) {}
            }
            count = filteredEntries.size();
            if (end != -1 && start != -1) {
                if (end > count) {
                    end = count;
                }
                if (start > count) {
                    start = count;
                }
                filteredEntries = filteredEntries.subList(start, end);
            }
            entryQuery.setEnd(end);
            entryQuery.setStart(start);
            results = new Object[]{filteredEntries, count};
        }
        threadLocalCache.put(key, results);
        return results;
    }

    protected boolean hasEntryQueryResults(AssetEntryQuery originalEntryQuery, AssetEntryQuery filteredEntryQuery) {
        long[] filteredEntryQueryAllCategoryIds = filteredEntryQuery.getAllCategoryIds();
        long[] originalEntryQueryAllCategoryIds = originalEntryQuery.getAllCategoryIds();
        if (originalEntryQueryAllCategoryIds.length > filteredEntryQueryAllCategoryIds.length) {
            return true;
        }
        long[] filteredEntryQueryAllTagIds = filteredEntryQuery.getAllTagIds();
        long[] originalEntryQueryAllTagIds = originalEntryQuery.getAllTagIds();
        if (originalEntryQueryAllTagIds.length > filteredEntryQueryAllTagIds.length) {
            return true;
        }
        if (ArrayUtil.isNotEmpty(originalEntryQuery.getAnyCategoryIds()) && ArrayUtil.isEmpty(filteredEntryQuery.getAnyCategoryIds())) {
            return true;
        }
        return ArrayUtil.isNotEmpty(originalEntryQuery.getAnyTagIds()) && ArrayUtil.isEmpty(filteredEntryQuery.getAnyTagIds());
    }
}

