/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryDisplay;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Autocomplete;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.service.base.AssetCategoryServiceBaseImpl;
import com.liferay.portlet.asset.service.permission.AssetCategoryPermission;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AssetCategoryServiceImpl
extends AssetCategoryServiceBaseImpl {
    @Override
    public AssetCategory addCategory(long groupId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), groupId, parentCategoryId, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), groupId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    @Override
    public AssetCategory addCategory(long groupId, String title, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), groupId, 0L, "ADD_CATEGORY");
        return this.assetCategoryLocalService.addCategory(this.getUserId(), groupId, title, vocabularyId, serviceContext);
    }

    @Override
    public void deleteCategories(long[] categoryIds) throws PortalException {
        for (long categoryId : categoryIds) {
            AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        }
        this.assetCategoryLocalService.deleteCategories(categoryIds);
    }

    @Override
    @Deprecated
    public List<AssetCategory> deleteCategories(long[] categoryIds, ServiceContext serviceContext) throws PortalException {
        ArrayList<AssetCategory> failedCategories = new ArrayList<AssetCategory>();
        for (long categoryId : categoryIds) {
            try {
                AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
                this.assetCategoryLocalService.deleteCategory(categoryId);
            }
            catch (PortalException pe) {
                if (serviceContext == null) {
                    return null;
                }
                if (serviceContext.isFailOnPortalException()) {
                    throw pe;
                }
                AssetCategory category = this.assetCategoryPersistence.fetchByPrimaryKey(categoryId);
                if (category == null) {
                    category = this.assetCategoryPersistence.create(categoryId);
                }
                failedCategories.add(category);
            }
        }
        return failedCategories;
    }

    @Override
    public void deleteCategory(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "DELETE");
        this.assetCategoryLocalService.deleteCategory(categoryId);
    }

    @Override
    public AssetCategory fetchCategory(long categoryId) throws PortalException {
        AssetCategory category = this.assetCategoryLocalService.fetchCategory(categoryId);
        if (category != null) {
            AssetCategoryPermission.check(this.getPermissionChecker(), category, "VIEW");
        }
        return category;
    }

    @Override
    public List<AssetCategory> getCategories(long classNameId, long classPK, int start, int end) {
        return this.assetCategoryFinder.filterFindByC_C(classNameId, classPK, start, end);
    }

    @Override
    public List<AssetCategory> getCategories(String className, long classPK) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getCategories(className, classPK));
    }

    @Override
    public int getCategoriesCount(long classNameId, long classPK) {
        return this.assetCategoryFinder.filterCountByC_C(classNameId, classPK);
    }

    @Override
    public AssetCategory getCategory(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        return this.assetCategoryLocalService.getCategory(categoryId);
    }

    @Override
    public String getCategoryPath(long categoryId) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "VIEW");
        AssetCategory category = this.getCategory(categoryId);
        return category.getPath(LocaleUtil.getMostRelevantLocale());
    }

    @Override
    public List<AssetCategory> getChildCategories(long parentCategoryId) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId));
    }

    @Override
    public List<AssetCategory> getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        AssetCategory parent;
        if (parentCategoryId != 0L && (parent = this.assetCategoryLocalService.fetchAssetCategory(parentCategoryId)) != null) {
            return this.assetCategoryPersistence.filterFindByG_P(parent.getGroupId(), parentCategoryId, start, end, obc);
        }
        return this.filterCategories(this.assetCategoryLocalService.getChildCategories(parentCategoryId, start, end, obc));
    }

    @Override
    public int getChildCategoriesCount(long parentCategoryId) throws PortalException {
        AssetCategory parent;
        if (parentCategoryId != 0L && (parent = this.assetCategoryLocalService.fetchAssetCategory(parentCategoryId)) != null) {
            return this.assetCategoryPersistence.filterCountByG_P(parent.getGroupId(), parentCategoryId);
        }
        return this.assetCategoryPersistence.countByParentCategoryId(parentCategoryId);
    }

    @Override
    public List<AssetCategory> getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
    }

    @Override
    public List<AssetCategory> getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        return this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, obc));
    }

    @Override
    public List<AssetCategory> getVocabularyCategories(long groupId, long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, parentCategoryId, vocabularyId, start, end, obc);
    }

    @Override
    public List<AssetCategory> getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        if (Validator.isNull(name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, obc);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, obc);
    }

    @Override
    public int getVocabularyCategoriesCount(long groupId, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
    }

    @Override
    public int getVocabularyCategoriesCount(long groupId, long parentCategory, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, parentCategory, vocabularyId);
    }

    @Override
    public int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) {
        if (Validator.isNull(name)) {
            return this.assetCategoryPersistence.filterCountByG_V(groupId, vocabularyId);
        }
        return this.assetCategoryPersistence.filterCountByG_LikeN_V(groupId, name, vocabularyId);
    }

    @Override
    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        List<AssetCategory> categories = this.filterCategories(this.assetCategoryLocalService.getVocabularyCategories(vocabularyId, start, end, obc));
        return new AssetCategoryDisplay(categories, categories.size(), start, end);
    }

    @Override
    public AssetCategoryDisplay getVocabularyCategoriesDisplay(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws PortalException {
        List<AssetCategory> categories = null;
        int total = 0;
        if (Validator.isNotNull(name)) {
            name = CustomSQLUtil.keywords(name)[0];
            categories = this.getVocabularyCategories(groupId, name, vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, name, vocabularyId);
        } else {
            categories = this.getVocabularyCategories(vocabularyId, start, end, obc);
            total = this.getVocabularyCategoriesCount(groupId, vocabularyId);
        }
        return new AssetCategoryDisplay(categories, total, start, end);
    }

    @Override
    public List<AssetCategory> getVocabularyRootCategories(long groupId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        return this.assetCategoryPersistence.filterFindByG_P_V(groupId, 0L, vocabularyId, start, end, obc);
    }

    @Override
    public int getVocabularyRootCategoriesCount(long groupId, long vocabularyId) {
        return this.assetCategoryPersistence.filterCountByG_P_V(groupId, 0L, vocabularyId);
    }

    @Override
    public AssetCategory moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
    }

    @Override
    public List<AssetCategory> search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) {
        String name = CustomSQLUtil.keywords(keywords)[0];
        if (Validator.isNull(name)) {
            return this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyId, start, end, obc);
        }
        return this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyId, start, end, obc);
    }

    @Override
    public JSONArray search(long groupId, String name, String[] categoryProperties, int start, int end) throws PortalException {
        List<AssetCategory> categories = this.assetCategoryLocalService.search(groupId, name, categoryProperties, start, end);
        categories = this.filterCategories(categories);
        return Autocomplete.arrayToJSONArray(categories, "name", "name");
    }

    @Override
    public JSONArray search(long[] groupIds, String name, long[] vocabularyIds, int start, int end) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (long groupId : groupIds) {
            JSONArray categoriesJSONArray = null;
            categoriesJSONArray = Validator.isNull(name) ? this.toJSONArray(this.assetCategoryPersistence.filterFindByG_V(groupId, vocabularyIds)) : this.toJSONArray(this.assetCategoryPersistence.filterFindByG_LikeN_V(groupId, name, vocabularyIds));
            for (int j = 0; j < categoriesJSONArray.length(); ++j) {
                jsonArray.put(categoriesJSONArray.getJSONObject(j));
            }
        }
        return jsonArray;
    }

    @Override
    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{vocabularyId}, start, end);
    }

    @Override
    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long parentCategoryId, long vocabularyId, int start, int end) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{parentCategoryId}, new long[]{vocabularyId}, start, end);
    }

    @Override
    public AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, long parentCategoryId, int start, int end, Sort sort) throws PortalException {
        return this.searchCategoriesDisplay(new long[]{groupId}, title, new long[]{vocabularyId}, new long[]{parentCategoryId}, start, end, sort);
    }

    @Override
    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult<AssetCategory> baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, vocabularyIds, start, end);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    @Override
    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult<AssetCategory> baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, parentCategoryIds, vocabularyIds, start, end);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    @Override
    public AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, long[] parentCategoryIds, int start, int end, Sort sort) throws PortalException {
        User user = this.getUser();
        BaseModelSearchResult<AssetCategory> baseModelSearchResult = this.assetCategoryLocalService.searchCategories(user.getCompanyId(), groupIds, title, vocabularyIds, parentCategoryIds, start, end, sort);
        return new AssetCategoryDisplay(baseModelSearchResult.getBaseModels(), baseModelSearchResult.getLength(), start, end);
    }

    @Override
    public AssetCategory updateCategory(long categoryId, long parentCategoryId, Map<Locale, String> titleMap, Map<Locale, String> descriptionMap, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws PortalException {
        AssetCategoryPermission.check(this.getPermissionChecker(), categoryId, "UPDATE");
        return this.assetCategoryLocalService.updateCategory(this.getUserId(), categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
    }

    protected List<AssetCategory> filterCategories(List<AssetCategory> categories) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        categories = ListUtil.copy(categories);
        Iterator<AssetCategory> itr = categories.iterator();
        while (itr.hasNext()) {
            AssetCategory category = itr.next();
            if (AssetCategoryPermission.contains(permissionChecker, category, "VIEW")) continue;
            itr.remove();
        }
        return categories;
    }

    protected JSONArray toJSONArray(List<AssetCategory> categories) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (AssetCategory category : categories) {
            String categoryJSON = JSONFactoryUtil.looseSerialize(category);
            JSONObject categoryJSONObject = JSONFactoryUtil.createJSONObject(categoryJSON);
            categoryJSONObject.put("path", this.getCategoryPath(category.getCategoryId()));
            jsonArray.put(categoryJSONObject);
        }
        return jsonArray;
    }
}

