/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.model.AssetVocabularyDisplay;
import com.liferay.asset.kernel.model.AssetVocabularySoap;
import com.liferay.asset.kernel.service.AssetVocabularyServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetVocabularyServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(AssetVocabularyServiceSoap.class);

    public static AssetVocabularySoap addVocabulary(long groupId, String title, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String settings, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> titleMap = LocalizationUtil.getLocalizationMap(titleMapLanguageIds, titleMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            AssetVocabulary returnValue = AssetVocabularyServiceUtil.addVocabulary(groupId, title, titleMap, descriptionMap, settings, serviceContext);
            return AssetVocabularySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap addVocabulary(long groupId, String title, ServiceContext serviceContext) throws RemoteException {
        try {
            AssetVocabulary returnValue = AssetVocabularyServiceUtil.addVocabulary(groupId, title, serviceContext);
            return AssetVocabularySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] deleteVocabularies(long[] vocabularyIds, ServiceContext serviceContext) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.deleteVocabularies(vocabularyIds, serviceContext);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteVocabulary(long vocabularyId) throws RemoteException {
        try {
            AssetVocabularyServiceUtil.deleteVocabulary(vocabularyId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap fetchVocabulary(long vocabularyId) throws RemoteException {
        try {
            AssetVocabulary returnValue = AssetVocabularyServiceUtil.fetchVocabulary(vocabularyId);
            return AssetVocabularySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static AssetVocabularySoap[] getCompanyVocabularies(long companyId) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getCompanyVocabularies(companyId);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupsVocabularies(long[] groupIds) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupsVocabularies(groupIds);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupsVocabularies(long[] groupIds, String className) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupsVocabularies(groupIds, className);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupsVocabularies(long[] groupIds, String className, long classTypePK) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupsVocabularies(groupIds, className, classTypePK);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupVocabularies(long groupId) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupVocabularies(groupId);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupVocabularies(long groupId, boolean createDefaultVocabulary) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupVocabularies(groupId, createDefaultVocabulary);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupVocabularies(long groupId, boolean createDefaultVocabulary, int start, int end, OrderByComparator<AssetVocabulary> obc) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupVocabularies(groupId, createDefaultVocabulary, start, end, obc);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupVocabularies(long groupId, int start, int end, OrderByComparator<AssetVocabulary> obc) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupVocabularies(groupId, start, end, obc);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupVocabularies(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupVocabularies(groupId, name, start, end, obc);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap[] getGroupVocabularies(long[] groupIds) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getGroupVocabularies(groupIds);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupVocabulariesCount(long groupId) throws RemoteException {
        try {
            int returnValue = AssetVocabularyServiceUtil.getGroupVocabulariesCount(groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupVocabulariesCount(long groupId, String name) throws RemoteException {
        try {
            int returnValue = AssetVocabularyServiceUtil.getGroupVocabulariesCount(groupId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupVocabulariesCount(long[] groupIds) throws RemoteException {
        try {
            int returnValue = AssetVocabularyServiceUtil.getGroupVocabulariesCount(groupIds);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, boolean addDefaultVocabulary, OrderByComparator<AssetVocabulary> obc) throws RemoteException {
        try {
            AssetVocabularyDisplay returnValue = AssetVocabularyServiceUtil.getGroupVocabulariesDisplay(groupId, name, start, end, addDefaultVocabulary, obc);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularyDisplay getGroupVocabulariesDisplay(long groupId, String name, int start, int end, OrderByComparator<AssetVocabulary> obc) throws RemoteException {
        try {
            AssetVocabularyDisplay returnValue = AssetVocabularyServiceUtil.getGroupVocabulariesDisplay(groupId, name, start, end, obc);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static AssetVocabularySoap[] getVocabularies(long[] vocabularyIds) throws RemoteException {
        try {
            List<AssetVocabulary> returnValue = AssetVocabularyServiceUtil.getVocabularies(vocabularyIds);
            return AssetVocabularySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap getVocabulary(long vocabularyId) throws RemoteException {
        try {
            AssetVocabulary returnValue = AssetVocabularyServiceUtil.getVocabulary(vocabularyId);
            return AssetVocabularySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, boolean addDefaultVocabulary, int start, int end) throws RemoteException {
        try {
            AssetVocabularyDisplay returnValue = AssetVocabularyServiceUtil.searchVocabulariesDisplay(groupId, title, addDefaultVocabulary, start, end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularyDisplay searchVocabulariesDisplay(long groupId, String title, boolean addDefaultVocabulary, int start, int end, Sort sort) throws RemoteException {
        try {
            AssetVocabularyDisplay returnValue = AssetVocabularyServiceUtil.searchVocabulariesDisplay(groupId, title, addDefaultVocabulary, start, end, sort);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetVocabularySoap updateVocabulary(long vocabularyId, String title, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, String settings, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> titleMap = LocalizationUtil.getLocalizationMap(titleMapLanguageIds, titleMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            AssetVocabulary returnValue = AssetVocabularyServiceUtil.updateVocabulary(vocabularyId, title, titleMap, descriptionMap, settings, serviceContext);
            return AssetVocabularySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

