/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.model.AssetTagDisplay;
import com.liferay.asset.kernel.model.AssetTagSoap;
import com.liferay.asset.kernel.service.AssetTagServiceUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetTagServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(AssetTagServiceSoap.class);

    public static AssetTagSoap addTag(long groupId, String name, ServiceContext serviceContext) throws RemoteException {
        try {
            AssetTag returnValue = AssetTagServiceUtil.addTag(groupId, name, serviceContext);
            return AssetTagSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTag(long tagId) throws RemoteException {
        try {
            AssetTagServiceUtil.deleteTag(tagId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteTags(long[] tagIds) throws RemoteException {
        try {
            AssetTagServiceUtil.deleteTags(tagIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getGroupsTags(long[] groupIds) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getGroupsTags(groupIds);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getGroupTags(long groupId) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getGroupTags(groupId);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getGroupTags(long groupId, int start, int end, OrderByComparator<AssetTag> obc) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getGroupTags(groupId, start, end, obc);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getGroupTagsCount(long groupId) throws RemoteException {
        try {
            int returnValue = AssetTagServiceUtil.getGroupTagsCount(groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagDisplay getGroupTagsDisplay(long groupId, String name, int start, int end) throws RemoteException {
        try {
            AssetTagDisplay returnValue = AssetTagServiceUtil.getGroupTagsDisplay(groupId, name, start, end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap getTag(long tagId) throws RemoteException {
        try {
            AssetTag returnValue = AssetTagServiceUtil.getTag(tagId);
            return AssetTagSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(long groupId, long classNameId, String name) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(groupId, classNameId, name);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(long groupId, long classNameId, String name, int start, int end, OrderByComparator<AssetTag> obc) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(groupId, classNameId, name, start, end, obc);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(long groupId, String name, int start, int end) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(groupId, name, start, end);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(long groupId, String name, int start, int end, OrderByComparator<AssetTag> obc) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(groupId, name, start, end, obc);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(long[] groupIds, String name, int start, int end) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(groupIds, name, start, end);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(long[] groupIds, String name, int start, int end, OrderByComparator<AssetTag> obc) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(groupIds, name, start, end, obc);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap[] getTags(String className, long classPK) throws RemoteException {
        try {
            List<AssetTag> returnValue = AssetTagServiceUtil.getTags(className, classPK);
            return AssetTagSoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getTagsCount(long groupId, String name) throws RemoteException {
        try {
            int returnValue = AssetTagServiceUtil.getTagsCount(groupId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVisibleAssetsTagsCount(long groupId, long classNameId, String name) throws RemoteException {
        try {
            int returnValue = AssetTagServiceUtil.getVisibleAssetsTagsCount(groupId, classNameId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVisibleAssetsTagsCount(long groupId, String name) throws RemoteException {
        try {
            int returnValue = AssetTagServiceUtil.getVisibleAssetsTagsCount(groupId, name);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void mergeTags(long fromTagId, long toTagId) throws RemoteException {
        try {
            AssetTagServiceUtil.mergeTags(fromTagId, toTagId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void mergeTags(long[] fromTagIds, long toTagId) throws RemoteException {
        try {
            AssetTagServiceUtil.mergeTags(fromTagIds, toTagId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String search(long groupId, String name, int start, int end) throws RemoteException {
        try {
            JSONArray returnValue = AssetTagServiceUtil.search(groupId, name, start, end);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String search(long[] groupIds, String name, int start, int end) throws RemoteException {
        try {
            JSONArray returnValue = AssetTagServiceUtil.search(groupIds, name, start, end);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetTagSoap updateTag(long tagId, String name, ServiceContext serviceContext) throws RemoteException {
        try {
            AssetTag returnValue = AssetTagServiceUtil.updateTag(tagId, name, serviceContext);
            return AssetTagSoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

