/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntrySoap;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portlet.asset.model.impl.AssetEntryModelImpl;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetEntryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(AssetEntryServiceSoap.class);

    public static AssetEntrySoap fetchEntry(long entryId) throws RemoteException {
        try {
            AssetEntry returnValue = AssetEntryServiceUtil.fetchEntry(entryId);
            return AssetEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetEntrySoap[] getCompanyEntries(long companyId, int start, int end) throws RemoteException {
        try {
            List<AssetEntry> returnValue = AssetEntryServiceUtil.getCompanyEntries(companyId, start, end);
            return AssetEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCompanyEntriesCount(long companyId) throws RemoteException {
        try {
            int returnValue = AssetEntryServiceUtil.getCompanyEntriesCount(companyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetEntrySoap[] getEntries(AssetEntryQuery entryQuery) throws RemoteException {
        try {
            List<AssetEntry> returnValue = AssetEntryServiceUtil.getEntries(entryQuery);
            return AssetEntrySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getEntriesCount(AssetEntryQuery entryQuery) throws RemoteException {
        try {
            int returnValue = AssetEntryServiceUtil.getEntriesCount(entryQuery);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetEntrySoap getEntry(long entryId) throws RemoteException {
        try {
            AssetEntry returnValue = AssetEntryServiceUtil.getEntry(entryId);
            return AssetEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void incrementViewCounter(AssetEntrySoap assetEntry) throws RemoteException {
        try {
            AssetEntryServiceUtil.incrementViewCounter(AssetEntryModelImpl.toModel(assetEntry));
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetEntrySoap incrementViewCounter(String className, long classPK) throws RemoteException {
        try {
            AssetEntry returnValue = AssetEntryServiceUtil.incrementViewCounter(className, classPK);
            return AssetEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetEntrySoap updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean listable, boolean visible, Date startDate, Date endDate, Date publishDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Double priority) throws RemoteException {
        try {
            AssetEntry returnValue = AssetEntryServiceUtil.updateEntry(groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, listable, visible, startDate, endDate, publishDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority);
            return AssetEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static AssetEntrySoap updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean listable, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Double priority) throws RemoteException {
        try {
            AssetEntry returnValue = AssetEntryServiceUtil.updateEntry(groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, listable, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority);
            return AssetEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static AssetEntrySoap updateEntry(long groupId, Date createDate, Date modifiedDate, String className, long classPK, String classUuid, long classTypeId, long[] categoryIds, String[] tagNames, boolean visible, Date startDate, Date endDate, Date expirationDate, String mimeType, String title, String description, String summary, String url, String layoutUuid, int height, int width, Integer priority, boolean sync) throws RemoteException {
        try {
            AssetEntry returnValue = AssetEntryServiceUtil.updateEntry(groupId, createDate, modifiedDate, className, classPK, classUuid, classTypeId, categoryIds, tagNames, visible, startDate, endDate, expirationDate, mimeType, title, description, summary, url, layoutUuid, height, width, priority, sync);
            return AssetEntrySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

