/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.service.http;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetCategoryDisplay;
import com.liferay.asset.kernel.model.AssetCategorySoap;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class AssetCategoryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(AssetCategoryServiceSoap.class);

    public static AssetCategorySoap addCategory(long groupId, long parentCategoryId, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> titleMap = LocalizationUtil.getLocalizationMap(titleMapLanguageIds, titleMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            AssetCategory returnValue = AssetCategoryServiceUtil.addCategory(groupId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
            return AssetCategorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap addCategory(long groupId, String title, long vocabularyId, ServiceContext serviceContext) throws RemoteException {
        try {
            AssetCategory returnValue = AssetCategoryServiceUtil.addCategory(groupId, title, vocabularyId, serviceContext);
            return AssetCategorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteCategories(long[] categoryIds) throws RemoteException {
        try {
            AssetCategoryServiceUtil.deleteCategories(categoryIds);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    @Deprecated
    public static AssetCategorySoap[] deleteCategories(long[] categoryIds, ServiceContext serviceContext) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.deleteCategories(categoryIds, serviceContext);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteCategory(long categoryId) throws RemoteException {
        try {
            AssetCategoryServiceUtil.deleteCategory(categoryId);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap fetchCategory(long categoryId) throws RemoteException {
        try {
            AssetCategory returnValue = AssetCategoryServiceUtil.fetchCategory(categoryId);
            return AssetCategorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getCategories(long classNameId, long classPK, int start, int end) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getCategories(classNameId, classPK, start, end);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getCategories(String className, long classPK) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getCategories(className, classPK);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getCategoriesCount(long classNameId, long classPK) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getCategoriesCount(classNameId, classPK);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap getCategory(long categoryId) throws RemoteException {
        try {
            AssetCategory returnValue = AssetCategoryServiceUtil.getCategory(categoryId);
            return AssetCategorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String getCategoryPath(long categoryId) throws RemoteException {
        try {
            String returnValue = AssetCategoryServiceUtil.getCategoryPath(categoryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getChildCategories(long parentCategoryId) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getChildCategories(parentCategoryId);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getChildCategories(long parentCategoryId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getChildCategories(parentCategoryId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getChildCategoriesCount(long parentCategoryId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getChildCategoriesCount(parentCategoryId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getVocabularyCategories(vocabularyId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long groupId, long parentCategoryId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getVocabularyCategories(groupId, parentCategoryId, vocabularyId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyCategories(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getVocabularyCategories(groupId, name, vocabularyId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVocabularyCategoriesCount(long groupId, long vocabularyId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesCount(groupId, vocabularyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVocabularyCategoriesCount(long groupId, long parentCategory, long vocabularyId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesCount(groupId, parentCategory, vocabularyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVocabularyCategoriesCount(long groupId, String name, long vocabularyId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesCount(groupId, name, vocabularyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay getVocabularyCategoriesDisplay(long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesDisplay(vocabularyId, start, end, obc);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay getVocabularyCategoriesDisplay(long groupId, String name, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.getVocabularyCategoriesDisplay(groupId, name, vocabularyId, start, end, obc);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] getVocabularyRootCategories(long groupId, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.getVocabularyRootCategories(groupId, vocabularyId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static int getVocabularyRootCategoriesCount(long groupId, long vocabularyId) throws RemoteException {
        try {
            int returnValue = AssetCategoryServiceUtil.getVocabularyRootCategoriesCount(groupId, vocabularyId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap moveCategory(long categoryId, long parentCategoryId, long vocabularyId, ServiceContext serviceContext) throws RemoteException {
        try {
            AssetCategory returnValue = AssetCategoryServiceUtil.moveCategory(categoryId, parentCategoryId, vocabularyId, serviceContext);
            return AssetCategorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap[] search(long groupId, String keywords, long vocabularyId, int start, int end, OrderByComparator<AssetCategory> obc) throws RemoteException {
        try {
            List<AssetCategory> returnValue = AssetCategoryServiceUtil.search(groupId, keywords, vocabularyId, start, end, obc);
            return AssetCategorySoap.toSoapModels(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String search(long groupId, String name, String[] categoryProperties, int start, int end) throws RemoteException {
        try {
            JSONArray returnValue = AssetCategoryServiceUtil.search(groupId, name, categoryProperties, start, end);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String search(long[] groupIds, String name, long[] vocabularyIds, int start, int end) throws RemoteException {
        try {
            JSONArray returnValue = AssetCategoryServiceUtil.search(groupIds, name, vocabularyIds, start, end);
            return returnValue.toString();
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, int start, int end) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.searchCategoriesDisplay(groupId, title, vocabularyId, start, end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long parentCategoryId, long vocabularyId, int start, int end) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.searchCategoriesDisplay(groupId, title, parentCategoryId, vocabularyId, start, end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay searchCategoriesDisplay(long groupId, String title, long vocabularyId, long parentCategoryId, int start, int end, Sort sort) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.searchCategoriesDisplay(groupId, title, vocabularyId, parentCategoryId, start, end, sort);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, int start, int end) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.searchCategoriesDisplay(groupIds, title, vocabularyIds, start, end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] parentCategoryIds, long[] vocabularyIds, int start, int end) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.searchCategoriesDisplay(groupIds, title, parentCategoryIds, vocabularyIds, start, end);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategoryDisplay searchCategoriesDisplay(long[] groupIds, String title, long[] vocabularyIds, long[] parentCategoryIds, int start, int end, Sort sort) throws RemoteException {
        try {
            AssetCategoryDisplay returnValue = AssetCategoryServiceUtil.searchCategoriesDisplay(groupIds, title, vocabularyIds, parentCategoryIds, start, end, sort);
            return returnValue;
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static AssetCategorySoap updateCategory(long categoryId, long parentCategoryId, String[] titleMapLanguageIds, String[] titleMapValues, String[] descriptionMapLanguageIds, String[] descriptionMapValues, long vocabularyId, String[] categoryProperties, ServiceContext serviceContext) throws RemoteException {
        try {
            Map<Locale, String> titleMap = LocalizationUtil.getLocalizationMap(titleMapLanguageIds, titleMapValues);
            Map<Locale, String> descriptionMap = LocalizationUtil.getLocalizationMap(descriptionMapLanguageIds, descriptionMapValues);
            AssetCategory returnValue = AssetCategoryServiceUtil.updateCategory(categoryId, parentCategoryId, titleMap, descriptionMap, vocabularyId, categoryProperties, serviceContext);
            return AssetCategorySoap.toSoapModel(returnValue);
        }
        catch (Exception e) {
            _log.error(e, e);
            throw new RemoteException(e.getMessage());
        }
    }
}

