/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.model.impl.AssetVocabularyBaseImpl;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.util.List;
import java.util.Locale;

public class AssetVocabularyImpl
extends AssetVocabularyBaseImpl {
    private AssetVocabularySettingsHelper _vocabularySettingsHelper;

    @Override
    public List<AssetCategory> getCategories() {
        return AssetCategoryLocalServiceUtil.getVocabularyCategories(this.getVocabularyId(), -1, -1, null);
    }

    @Override
    public int getCategoriesCount() {
        return AssetCategoryLocalServiceUtil.getVocabularyCategoriesCount(this.getVocabularyId());
    }

    @Override
    public long[] getRequiredClassNameIds() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getRequiredClassNameIds();
    }

    @Override
    public long[] getSelectedClassNameIds() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getClassNameIds();
    }

    @Override
    public long[] getSelectedClassTypePKs() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.getClassTypePKs();
    }

    @Override
    public String getSettings() {
        if (this._vocabularySettingsHelper == null) {
            return super.getSettings();
        }
        return this._vocabularySettingsHelper.toString();
    }

    @Override
    @Deprecated
    public UnicodeProperties getSettingsProperties() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        UnicodeProperties settingsProperties = new UnicodeProperties(true);
        settingsProperties.fastLoad(vocabularySettingsHelper.toString());
        return settingsProperties;
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull(value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull(value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public String getUnambiguousTitle(List<AssetVocabulary> vocabularies, long groupId, Locale locale) throws PortalException {
        if (this.getGroupId() == groupId) {
            return this.getTitle(locale);
        }
        boolean hasAmbiguousTitle = ListUtil.exists(vocabularies, vocabulary -> {
            String title = vocabulary.getTitle(locale);
            return title.equals(this.getTitle(locale)) && vocabulary.getVocabularyId() != this.getVocabularyId();
        });
        if (hasAmbiguousTitle) {
            Group group = GroupLocalServiceUtil.getGroup(this.getGroupId());
            return group.getUnambiguousName(this.getTitle(locale), locale);
        }
        return this.getTitle(locale);
    }

    @Override
    public boolean hasMoreThanOneCategorySelected(long[] categoryIds) {
        int count = ListUtil.count(this.getCategories(), assetCategory -> ArrayUtil.contains(categoryIds, assetCategory.getCategoryId()));
        return count > 1;
    }

    @Override
    public boolean isAssociatedToClassNameId(long classNameId) {
        return this.isAssociatedToClassNameIdAndClassTypePK(classNameId, -1L);
    }

    @Override
    public boolean isAssociatedToClassNameIdAndClassTypePK(long classNameId, long classTypePK) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.hasClassNameIdAndClassTypePK(classNameId, classTypePK);
    }

    @Override
    public boolean isMissingRequiredCategory(long classNameId, long classTypePK, long[] categoryIds) {
        if (!this.isRequired(classNameId, classTypePK)) {
            return false;
        }
        return !ListUtil.exists(this.getCategories(), assetCategory -> ArrayUtil.contains(categoryIds, assetCategory.getCategoryId()));
    }

    @Override
    public boolean isMultiValued() {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.isMultiValued();
    }

    @Override
    @Deprecated
    public boolean isRequired(long classNameId) {
        return this.isRequired(classNameId, -1L);
    }

    @Override
    public boolean isRequired(long classNameId, long classTypePK) {
        AssetVocabularySettingsHelper vocabularySettingsHelper = this.getVocabularySettingsHelper();
        return vocabularySettingsHelper.isClassNameIdAndClassTypePKRequired(classNameId, classTypePK);
    }

    @Override
    public void setSettings(String settings) {
        this._vocabularySettingsHelper = null;
        super.setSettings(settings);
    }

    @Override
    @Deprecated
    public void setSettingsProperties(UnicodeProperties settingsProperties) {
        super.setSettings(settingsProperties.toString());
        this._vocabularySettingsHelper = this.getVocabularySettingsHelper();
    }

    protected AssetVocabularySettingsHelper getVocabularySettingsHelper() {
        if (this._vocabularySettingsHelper == null) {
            this._vocabularySettingsHelper = new AssetVocabularySettingsHelper(super.getSettings());
        }
        return this._vocabularySettingsHelper;
    }
}

