/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetEntryModel;
import com.liferay.asset.kernel.model.AssetEntrySoap;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portlet.asset.model.impl.AssetEntryCacheModel;
import com.liferay.portlet.asset.model.impl.AssetEntryImpl;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.osgi.annotation.versioning.ProviderType;

@JSON(strict=true)
@ProviderType
public class AssetEntryModelImpl
extends BaseModelImpl<AssetEntry>
implements AssetEntryModel {
    public static final String TABLE_NAME = "AssetEntry";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"entryId", -5}, {"groupId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"classNameId", -5}, {"classPK", -5}, {"classUuid", 12}, {"classTypeId", -5}, {"listable", 16}, {"visible", 16}, {"startDate", 93}, {"endDate", 93}, {"publishDate", 93}, {"expirationDate", 93}, {"mimeType", 12}, {"title", 12}, {"description", 2005}, {"summary", 2005}, {"url", 12}, {"layoutUuid", 12}, {"height", 4}, {"width", 4}, {"priority", 8}, {"viewCount", 4}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table AssetEntry (entryId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,classNameId LONG,classPK LONG,classUuid VARCHAR(75) null,classTypeId LONG,listable BOOLEAN,visible BOOLEAN,startDate DATE null,endDate DATE null,publishDate DATE null,expirationDate DATE null,mimeType VARCHAR(75) null,title STRING null,description TEXT null,summary TEXT null,url STRING null,layoutUuid VARCHAR(75) null,height INTEGER,width INTEGER,priority DOUBLE,viewCount INTEGER)";
    public static final String TABLE_SQL_DROP = "drop table AssetEntry";
    public static final String ORDER_BY_JPQL = " ORDER BY assetEntry.entryId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY AssetEntry.entryId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final boolean ENTITY_CACHE_ENABLED;
    public static final boolean FINDER_CACHE_ENABLED;
    public static final boolean COLUMN_BITMASK_ENABLED;
    public static final long CLASSNAMEID_COLUMN_BITMASK = 1L;
    public static final long CLASSPK_COLUMN_BITMASK = 2L;
    public static final long CLASSUUID_COLUMN_BITMASK = 4L;
    public static final long COMPANYID_COLUMN_BITMASK = 8L;
    public static final long EXPIRATIONDATE_COLUMN_BITMASK = 16L;
    public static final long GROUPID_COLUMN_BITMASK = 32L;
    public static final long LAYOUTUUID_COLUMN_BITMASK = 64L;
    public static final long PUBLISHDATE_COLUMN_BITMASK = 128L;
    public static final long VISIBLE_COLUMN_BITMASK = 256L;
    public static final long ENTRYID_COLUMN_BITMASK = 512L;
    public static final String MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_NAME = "AssetEntries_AssetCategories";
    public static final Object[][] MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_COLUMNS;
    public static final String MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_SQL_CREATE = "create table AssetEntries_AssetCategories (companyId LONG not null,categoryId LONG not null,entryId LONG not null,primary key (categoryId, entryId))";
    public static final boolean FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETCATEGORIES;
    public static final String MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_NAME = "AssetEntries_AssetTags";
    public static final Object[][] MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_COLUMNS;
    public static final String MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_SQL_CREATE = "create table AssetEntries_AssetTags (companyId LONG not null,entryId LONG not null,tagId LONG not null,primary key (entryId, tagId))";
    public static final boolean FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETTAGS;
    public static final long LOCK_EXPIRATION_TIME;
    private static final Map<String, Function<AssetEntry, Object>> _attributeGetterFunctions;
    private static final Map<String, BiConsumer<AssetEntry, Object>> _attributeSetterBiConsumers;
    private static final Function<InvocationHandler, AssetEntry> _escapedModelProxyProviderFunction;
    private long _entryId;
    private long _groupId;
    private long _originalGroupId;
    private boolean _setOriginalGroupId;
    private long _companyId;
    private long _originalCompanyId;
    private boolean _setOriginalCompanyId;
    private long _userId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private boolean _setModifiedDate;
    private long _classNameId;
    private long _originalClassNameId;
    private boolean _setOriginalClassNameId;
    private long _classPK;
    private long _originalClassPK;
    private boolean _setOriginalClassPK;
    private String _classUuid;
    private String _originalClassUuid;
    private long _classTypeId;
    private boolean _listable;
    private boolean _visible;
    private boolean _originalVisible;
    private boolean _setOriginalVisible;
    private Date _startDate;
    private Date _endDate;
    private Date _publishDate;
    private Date _originalPublishDate;
    private Date _expirationDate;
    private Date _originalExpirationDate;
    private String _mimeType;
    private String _title;
    private String _titleCurrentLanguageId;
    private String _description;
    private String _descriptionCurrentLanguageId;
    private String _summary;
    private String _summaryCurrentLanguageId;
    private String _url;
    private String _layoutUuid;
    private String _originalLayoutUuid;
    private int _height;
    private int _width;
    private double _priority;
    private int _viewCount;
    private long _columnBitmask;
    private AssetEntry _escapedModel;

    public static AssetEntry toModel(AssetEntrySoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        AssetEntryImpl model = new AssetEntryImpl();
        model.setEntryId(soapModel.getEntryId());
        model.setGroupId(soapModel.getGroupId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setClassNameId(soapModel.getClassNameId());
        model.setClassPK(soapModel.getClassPK());
        model.setClassUuid(soapModel.getClassUuid());
        model.setClassTypeId(soapModel.getClassTypeId());
        model.setListable(soapModel.isListable());
        model.setVisible(soapModel.isVisible());
        model.setStartDate(soapModel.getStartDate());
        model.setEndDate(soapModel.getEndDate());
        model.setPublishDate(soapModel.getPublishDate());
        model.setExpirationDate(soapModel.getExpirationDate());
        model.setMimeType(soapModel.getMimeType());
        model.setTitle(soapModel.getTitle());
        model.setDescription(soapModel.getDescription());
        model.setSummary(soapModel.getSummary());
        model.setUrl(soapModel.getUrl());
        model.setLayoutUuid(soapModel.getLayoutUuid());
        model.setHeight(soapModel.getHeight());
        model.setWidth(soapModel.getWidth());
        model.setPriority(soapModel.getPriority());
        model.setViewCount(soapModel.getViewCount());
        return model;
    }

    public static List<AssetEntry> toModels(AssetEntrySoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<AssetEntry> models = new ArrayList<AssetEntry>(soapModels.length);
        for (AssetEntrySoap soapModel : soapModels) {
            models.add(AssetEntryModelImpl.toModel(soapModel));
        }
        return models;
    }

    @Override
    public long getPrimaryKey() {
        return this._entryId;
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        this.setEntryId(primaryKey);
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._entryId);
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    @Override
    public Class<?> getModelClass() {
        return AssetEntry.class;
    }

    @Override
    public String getModelClassName() {
        return AssetEntry.class.getName();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Function<AssetEntry, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        for (Map.Entry<String, Function<AssetEntry, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<AssetEntry, Object> attributeGetterFunction = entry.getValue();
            attributes.put(attributeName, attributeGetterFunction.apply((AssetEntry)((Object)this)));
        }
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        Map<String, BiConsumer<AssetEntry, Object>> attributeSetterBiConsumers = this.getAttributeSetterBiConsumers();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            BiConsumer<AssetEntry, Object> attributeSetterBiConsumer = attributeSetterBiConsumers.get(attributeName);
            if (attributeSetterBiConsumer == null) continue;
            attributeSetterBiConsumer.accept((AssetEntry)((Object)this), entry.getValue());
        }
    }

    public Map<String, Function<AssetEntry, Object>> getAttributeGetterFunctions() {
        return _attributeGetterFunctions;
    }

    public Map<String, BiConsumer<AssetEntry, Object>> getAttributeSetterBiConsumers() {
        return _attributeSetterBiConsumers;
    }

    private static Function<InvocationHandler, AssetEntry> _getProxyProviderFunction() {
        Class<?> proxyClass = ProxyUtil.getProxyClass(AssetEntry.class.getClassLoader(), AssetEntry.class, ModelWrapper.class);
        try {
            Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
            return invocationHandler -> {
                try {
                    return (AssetEntry)constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException roe) {
                    throw new InternalError(roe);
                }
            };
        }
        catch (NoSuchMethodException nsme) {
            throw new InternalError(nsme);
        }
    }

    @Override
    @JSON
    public long getEntryId() {
        return this._entryId;
    }

    @Override
    public void setEntryId(long entryId) {
        this._entryId = entryId;
    }

    @Override
    @JSON
    public long getGroupId() {
        return this._groupId;
    }

    @Override
    public void setGroupId(long groupId) {
        this._columnBitmask |= 0x20L;
        if (!this._setOriginalGroupId) {
            this._setOriginalGroupId = true;
            this._originalGroupId = this._groupId;
        }
        this._groupId = groupId;
    }

    public long getOriginalGroupId() {
        return this._originalGroupId;
    }

    @Override
    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public void setCompanyId(long companyId) {
        this._columnBitmask |= 8L;
        if (!this._setOriginalCompanyId) {
            this._setOriginalCompanyId = true;
            this._originalCompanyId = this._companyId;
        }
        this._companyId = companyId;
    }

    public long getOriginalCompanyId() {
        return this._originalCompanyId;
    }

    @Override
    @JSON
    public long getUserId() {
        return this._userId;
    }

    @Override
    public void setUserId(long userId) {
        this._userId = userId;
    }

    @Override
    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById(this.getUserId());
            return user.getUuid();
        }
        catch (PortalException pe) {
            return "";
        }
    }

    @Override
    public void setUserUuid(String userUuid) {
    }

    @Override
    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    @Override
    public void setUserName(String userName) {
        this._userName = userName;
    }

    @Override
    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    @Override
    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    @Override
    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public boolean hasSetModifiedDate() {
        return this._setModifiedDate;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this._setModifiedDate = true;
        this._modifiedDate = modifiedDate;
    }

    @Override
    public String getClassName() {
        if (this.getClassNameId() <= 0L) {
            return "";
        }
        return PortalUtil.getClassName(this.getClassNameId());
    }

    @Override
    public void setClassName(String className) {
        long classNameId = 0L;
        if (Validator.isNotNull(className)) {
            classNameId = PortalUtil.getClassNameId(className);
        }
        this.setClassNameId(classNameId);
    }

    @Override
    @JSON
    public long getClassNameId() {
        return this._classNameId;
    }

    @Override
    public void setClassNameId(long classNameId) {
        this._columnBitmask |= 1L;
        if (!this._setOriginalClassNameId) {
            this._setOriginalClassNameId = true;
            this._originalClassNameId = this._classNameId;
        }
        this._classNameId = classNameId;
    }

    public long getOriginalClassNameId() {
        return this._originalClassNameId;
    }

    @Override
    @JSON
    public long getClassPK() {
        return this._classPK;
    }

    @Override
    public void setClassPK(long classPK) {
        this._columnBitmask |= 2L;
        if (!this._setOriginalClassPK) {
            this._setOriginalClassPK = true;
            this._originalClassPK = this._classPK;
        }
        this._classPK = classPK;
    }

    public long getOriginalClassPK() {
        return this._originalClassPK;
    }

    @Override
    @JSON
    public String getClassUuid() {
        if (this._classUuid == null) {
            return "";
        }
        return this._classUuid;
    }

    @Override
    public void setClassUuid(String classUuid) {
        this._columnBitmask |= 4L;
        if (this._originalClassUuid == null) {
            this._originalClassUuid = this._classUuid;
        }
        this._classUuid = classUuid;
    }

    public String getOriginalClassUuid() {
        return GetterUtil.getString(this._originalClassUuid);
    }

    @Override
    @JSON
    public long getClassTypeId() {
        return this._classTypeId;
    }

    @Override
    public void setClassTypeId(long classTypeId) {
        this._classTypeId = classTypeId;
    }

    @Override
    @JSON
    public boolean getListable() {
        return this._listable;
    }

    @Override
    @JSON
    public boolean isListable() {
        return this._listable;
    }

    @Override
    public void setListable(boolean listable) {
        this._listable = listable;
    }

    @Override
    @JSON
    public boolean getVisible() {
        return this._visible;
    }

    @Override
    @JSON
    public boolean isVisible() {
        return this._visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this._columnBitmask |= 0x100L;
        if (!this._setOriginalVisible) {
            this._setOriginalVisible = true;
            this._originalVisible = this._visible;
        }
        this._visible = visible;
    }

    public boolean getOriginalVisible() {
        return this._originalVisible;
    }

    @Override
    @JSON
    public Date getStartDate() {
        return this._startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this._startDate = startDate;
    }

    @Override
    @JSON
    public Date getEndDate() {
        return this._endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this._endDate = endDate;
    }

    @Override
    @JSON
    public Date getPublishDate() {
        return this._publishDate;
    }

    @Override
    public void setPublishDate(Date publishDate) {
        this._columnBitmask |= 0x80L;
        if (this._originalPublishDate == null) {
            this._originalPublishDate = this._publishDate;
        }
        this._publishDate = publishDate;
    }

    public Date getOriginalPublishDate() {
        return this._originalPublishDate;
    }

    @Override
    @JSON
    public Date getExpirationDate() {
        return this._expirationDate;
    }

    @Override
    public void setExpirationDate(Date expirationDate) {
        this._columnBitmask |= 0x10L;
        if (this._originalExpirationDate == null) {
            this._originalExpirationDate = this._expirationDate;
        }
        this._expirationDate = expirationDate;
    }

    public Date getOriginalExpirationDate() {
        return this._originalExpirationDate;
    }

    @Override
    @JSON
    public String getMimeType() {
        if (this._mimeType == null) {
            return "";
        }
        return this._mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    @Override
    @JSON
    public String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    @Override
    public String getTitle(Locale locale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getTitle(languageId);
    }

    @Override
    public String getTitle(Locale locale, boolean useDefault) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getTitle(languageId, useDefault);
    }

    @Override
    public String getTitle(String languageId) {
        return LocalizationUtil.getLocalization(this.getTitle(), languageId);
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization(this.getTitle(), languageId, useDefault);
    }

    @Override
    public String getTitleCurrentLanguageId() {
        return this._titleCurrentLanguageId;
    }

    @Override
    @JSON
    public String getTitleCurrentValue() {
        Locale locale = this.getLocale(this._titleCurrentLanguageId);
        return this.getTitle(locale);
    }

    @Override
    public Map<Locale, String> getTitleMap() {
        return LocalizationUtil.getLocalizationMap(this.getTitle());
    }

    @Override
    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public void setTitle(String title, Locale locale) {
        this.setTitle(title, locale, LocaleUtil.getSiteDefault());
    }

    @Override
    public void setTitle(String title, Locale locale, Locale defaultLocale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);
        if (Validator.isNotNull(title)) {
            this.setTitle(LocalizationUtil.updateLocalization(this.getTitle(), "Title", title, languageId, defaultLanguageId));
        } else {
            this.setTitle(LocalizationUtil.removeLocalization(this.getTitle(), "Title", languageId));
        }
    }

    @Override
    public void setTitleCurrentLanguageId(String languageId) {
        this._titleCurrentLanguageId = languageId;
    }

    @Override
    public void setTitleMap(Map<Locale, String> titleMap) {
        this.setTitleMap(titleMap, LocaleUtil.getSiteDefault());
    }

    @Override
    public void setTitleMap(Map<Locale, String> titleMap, Locale defaultLocale) {
        if (titleMap == null) {
            return;
        }
        this.setTitle(LocalizationUtil.updateLocalization(titleMap, this.getTitle(), "Title", LocaleUtil.toLanguageId(defaultLocale)));
    }

    @Override
    @JSON
    public String getDescription() {
        if (this._description == null) {
            return "";
        }
        return this._description;
    }

    @Override
    public String getDescription(Locale locale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getDescription(languageId);
    }

    @Override
    public String getDescription(Locale locale, boolean useDefault) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getDescription(languageId, useDefault);
    }

    @Override
    public String getDescription(String languageId) {
        return LocalizationUtil.getLocalization(this.getDescription(), languageId);
    }

    @Override
    public String getDescription(String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization(this.getDescription(), languageId, useDefault);
    }

    @Override
    public String getDescriptionCurrentLanguageId() {
        return this._descriptionCurrentLanguageId;
    }

    @Override
    @JSON
    public String getDescriptionCurrentValue() {
        Locale locale = this.getLocale(this._descriptionCurrentLanguageId);
        return this.getDescription(locale);
    }

    @Override
    public Map<Locale, String> getDescriptionMap() {
        return LocalizationUtil.getLocalizationMap(this.getDescription());
    }

    @Override
    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public void setDescription(String description, Locale locale) {
        this.setDescription(description, locale, LocaleUtil.getSiteDefault());
    }

    @Override
    public void setDescription(String description, Locale locale, Locale defaultLocale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);
        if (Validator.isNotNull(description)) {
            this.setDescription(LocalizationUtil.updateLocalization(this.getDescription(), "Description", description, languageId, defaultLanguageId));
        } else {
            this.setDescription(LocalizationUtil.removeLocalization(this.getDescription(), "Description", languageId));
        }
    }

    @Override
    public void setDescriptionCurrentLanguageId(String languageId) {
        this._descriptionCurrentLanguageId = languageId;
    }

    @Override
    public void setDescriptionMap(Map<Locale, String> descriptionMap) {
        this.setDescriptionMap(descriptionMap, LocaleUtil.getSiteDefault());
    }

    @Override
    public void setDescriptionMap(Map<Locale, String> descriptionMap, Locale defaultLocale) {
        if (descriptionMap == null) {
            return;
        }
        this.setDescription(LocalizationUtil.updateLocalization(descriptionMap, this.getDescription(), "Description", LocaleUtil.toLanguageId(defaultLocale)));
    }

    @Override
    @JSON
    public String getSummary() {
        if (this._summary == null) {
            return "";
        }
        return this._summary;
    }

    @Override
    public String getSummary(Locale locale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getSummary(languageId);
    }

    @Override
    public String getSummary(Locale locale, boolean useDefault) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this.getSummary(languageId, useDefault);
    }

    @Override
    public String getSummary(String languageId) {
        return LocalizationUtil.getLocalization(this.getSummary(), languageId);
    }

    @Override
    public String getSummary(String languageId, boolean useDefault) {
        return LocalizationUtil.getLocalization(this.getSummary(), languageId, useDefault);
    }

    @Override
    public String getSummaryCurrentLanguageId() {
        return this._summaryCurrentLanguageId;
    }

    @Override
    @JSON
    public String getSummaryCurrentValue() {
        Locale locale = this.getLocale(this._summaryCurrentLanguageId);
        return this.getSummary(locale);
    }

    @Override
    public Map<Locale, String> getSummaryMap() {
        return LocalizationUtil.getLocalizationMap(this.getSummary());
    }

    @Override
    public void setSummary(String summary) {
        this._summary = summary;
    }

    @Override
    public void setSummary(String summary, Locale locale) {
        this.setSummary(summary, locale, LocaleUtil.getSiteDefault());
    }

    @Override
    public void setSummary(String summary, Locale locale, Locale defaultLocale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);
        if (Validator.isNotNull(summary)) {
            this.setSummary(LocalizationUtil.updateLocalization(this.getSummary(), "Summary", summary, languageId, defaultLanguageId));
        } else {
            this.setSummary(LocalizationUtil.removeLocalization(this.getSummary(), "Summary", languageId));
        }
    }

    @Override
    public void setSummaryCurrentLanguageId(String languageId) {
        this._summaryCurrentLanguageId = languageId;
    }

    @Override
    public void setSummaryMap(Map<Locale, String> summaryMap) {
        this.setSummaryMap(summaryMap, LocaleUtil.getSiteDefault());
    }

    @Override
    public void setSummaryMap(Map<Locale, String> summaryMap, Locale defaultLocale) {
        if (summaryMap == null) {
            return;
        }
        this.setSummary(LocalizationUtil.updateLocalization(summaryMap, this.getSummary(), "Summary", LocaleUtil.toLanguageId(defaultLocale)));
    }

    @Override
    @JSON
    public String getUrl() {
        if (this._url == null) {
            return "";
        }
        return this._url;
    }

    @Override
    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    @JSON
    public String getLayoutUuid() {
        if (this._layoutUuid == null) {
            return "";
        }
        return this._layoutUuid;
    }

    @Override
    public void setLayoutUuid(String layoutUuid) {
        this._columnBitmask |= 0x40L;
        if (this._originalLayoutUuid == null) {
            this._originalLayoutUuid = this._layoutUuid;
        }
        this._layoutUuid = layoutUuid;
    }

    public String getOriginalLayoutUuid() {
        return GetterUtil.getString(this._originalLayoutUuid);
    }

    @Override
    @JSON
    public int getHeight() {
        return this._height;
    }

    @Override
    public void setHeight(int height) {
        this._height = height;
    }

    @Override
    @JSON
    public int getWidth() {
        return this._width;
    }

    @Override
    public void setWidth(int width) {
        this._width = width;
    }

    @Override
    @JSON
    public double getPriority() {
        return this._priority;
    }

    @Override
    public void setPriority(double priority) {
        this._priority = priority;
    }

    @Override
    @JSON
    public int getViewCount() {
        return this._viewCount;
    }

    @Override
    public void setViewCount(int viewCount) {
        this._viewCount = viewCount;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge(this.getCompanyId(), AssetEntry.class.getName(), this.getPrimaryKey());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    @Override
    public String[] getAvailableLanguageIds() {
        TreeSet<String> availableLanguageIds = new TreeSet<String>();
        Map<Locale, String> titleMap = this.getTitleMap();
        for (Map.Entry<Locale, String> entry : titleMap.entrySet()) {
            Locale locale = entry.getKey();
            String value = entry.getValue();
            if (!Validator.isNotNull(value)) continue;
            availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
        }
        Map<Locale, String> descriptionMap = this.getDescriptionMap();
        for (Map.Entry<Locale, String> entry : descriptionMap.entrySet()) {
            Locale locale = entry.getKey();
            String value = entry.getValue();
            if (!Validator.isNotNull(value)) continue;
            availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
        }
        Map<Locale, String> map = this.getSummaryMap();
        for (Map.Entry<Locale, String> entry : map.entrySet()) {
            Locale locale = entry.getKey();
            String value = entry.getValue();
            if (!Validator.isNotNull(value)) continue;
            availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
        }
        return availableLanguageIds.toArray(new String[availableLanguageIds.size()]);
    }

    @Override
    public String getDefaultLanguageId() {
        String xml = this.getTitle();
        if (xml == null) {
            return "";
        }
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
    }

    @Override
    public void prepareLocalizedFieldsForImport() throws LocaleException {
        Locale defaultLocale = LocaleUtil.fromLanguageId(this.getDefaultLanguageId());
        Locale[] availableLocales = LocaleUtil.fromLanguageIds(this.getAvailableLanguageIds());
        Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(AssetEntry.class.getName(), this.getPrimaryKey(), defaultLocale, availableLocales);
        this.prepareLocalizedFieldsForImport(defaultImportLocale);
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        String modelDefaultLanguageId = this.getDefaultLanguageId();
        String title = this.getTitle(defaultLocale);
        if (Validator.isNull(title)) {
            this.setTitle(this.getTitle(modelDefaultLanguageId), defaultLocale);
        } else {
            this.setTitle(this.getTitle(defaultLocale), defaultLocale, defaultLocale);
        }
        String description = this.getDescription(defaultLocale);
        if (Validator.isNull(description)) {
            this.setDescription(this.getDescription(modelDefaultLanguageId), defaultLocale);
        } else {
            this.setDescription(this.getDescription(defaultLocale), defaultLocale, defaultLocale);
        }
        String summary = this.getSummary(defaultLocale);
        if (Validator.isNull(summary)) {
            this.setSummary(this.getSummary(modelDefaultLanguageId), defaultLocale);
        } else {
            this.setSummary(this.getSummary(defaultLocale), defaultLocale, defaultLocale);
        }
    }

    @Override
    public AssetEntry toEscapedModel() {
        if (this._escapedModel == null) {
            this._escapedModel = _escapedModelProxyProviderFunction.apply(new AutoEscapeBeanHandler(this));
        }
        return this._escapedModel;
    }

    @Override
    public Object clone() {
        AssetEntryImpl assetEntryImpl = new AssetEntryImpl();
        assetEntryImpl.setEntryId(this.getEntryId());
        assetEntryImpl.setGroupId(this.getGroupId());
        assetEntryImpl.setCompanyId(this.getCompanyId());
        assetEntryImpl.setUserId(this.getUserId());
        assetEntryImpl.setUserName(this.getUserName());
        assetEntryImpl.setCreateDate(this.getCreateDate());
        assetEntryImpl.setModifiedDate(this.getModifiedDate());
        assetEntryImpl.setClassNameId(this.getClassNameId());
        assetEntryImpl.setClassPK(this.getClassPK());
        assetEntryImpl.setClassUuid(this.getClassUuid());
        assetEntryImpl.setClassTypeId(this.getClassTypeId());
        assetEntryImpl.setListable(this.isListable());
        assetEntryImpl.setVisible(this.isVisible());
        assetEntryImpl.setStartDate(this.getStartDate());
        assetEntryImpl.setEndDate(this.getEndDate());
        assetEntryImpl.setPublishDate(this.getPublishDate());
        assetEntryImpl.setExpirationDate(this.getExpirationDate());
        assetEntryImpl.setMimeType(this.getMimeType());
        assetEntryImpl.setTitle(this.getTitle());
        assetEntryImpl.setDescription(this.getDescription());
        assetEntryImpl.setSummary(this.getSummary());
        assetEntryImpl.setUrl(this.getUrl());
        assetEntryImpl.setLayoutUuid(this.getLayoutUuid());
        assetEntryImpl.setHeight(this.getHeight());
        assetEntryImpl.setWidth(this.getWidth());
        assetEntryImpl.setPriority(this.getPriority());
        assetEntryImpl.setViewCount(this.getViewCount());
        assetEntryImpl.resetOriginalValues();
        return assetEntryImpl;
    }

    @Override
    public int compareTo(AssetEntry assetEntry) {
        long primaryKey = assetEntry.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssetEntry)) {
            return false;
        }
        AssetEntry assetEntry = (AssetEntry)obj;
        long primaryKey = assetEntry.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    @Override
    public boolean isEntityCacheEnabled() {
        return ENTITY_CACHE_ENABLED;
    }

    @Override
    public boolean isFinderCacheEnabled() {
        return FINDER_CACHE_ENABLED;
    }

    @Override
    public void resetOriginalValues() {
        AssetEntryModelImpl assetEntryModelImpl = this;
        assetEntryModelImpl._originalGroupId = assetEntryModelImpl._groupId;
        assetEntryModelImpl._setOriginalGroupId = false;
        assetEntryModelImpl._originalCompanyId = assetEntryModelImpl._companyId;
        assetEntryModelImpl._setOriginalCompanyId = false;
        assetEntryModelImpl._setModifiedDate = false;
        assetEntryModelImpl._originalClassNameId = assetEntryModelImpl._classNameId;
        assetEntryModelImpl._setOriginalClassNameId = false;
        assetEntryModelImpl._originalClassPK = assetEntryModelImpl._classPK;
        assetEntryModelImpl._setOriginalClassPK = false;
        assetEntryModelImpl._originalClassUuid = assetEntryModelImpl._classUuid;
        assetEntryModelImpl._originalVisible = assetEntryModelImpl._visible;
        assetEntryModelImpl._setOriginalVisible = false;
        assetEntryModelImpl._originalPublishDate = assetEntryModelImpl._publishDate;
        assetEntryModelImpl._originalExpirationDate = assetEntryModelImpl._expirationDate;
        assetEntryModelImpl._originalLayoutUuid = assetEntryModelImpl._layoutUuid;
        assetEntryModelImpl._columnBitmask = 0L;
    }

    @Override
    public CacheModel<AssetEntry> toCacheModel() {
        String layoutUuid;
        String url;
        String summary;
        String description;
        String title;
        Date createDate;
        AssetEntryCacheModel assetEntryCacheModel = new AssetEntryCacheModel();
        assetEntryCacheModel.entryId = this.getEntryId();
        assetEntryCacheModel.groupId = this.getGroupId();
        assetEntryCacheModel.companyId = this.getCompanyId();
        assetEntryCacheModel.userId = this.getUserId();
        assetEntryCacheModel.userName = this.getUserName();
        String userName = assetEntryCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            assetEntryCacheModel.userName = null;
        }
        assetEntryCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        assetEntryCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        assetEntryCacheModel.classNameId = this.getClassNameId();
        assetEntryCacheModel.classPK = this.getClassPK();
        assetEntryCacheModel.classUuid = this.getClassUuid();
        String classUuid = assetEntryCacheModel.classUuid;
        if (classUuid != null && classUuid.length() == 0) {
            assetEntryCacheModel.classUuid = null;
        }
        assetEntryCacheModel.classTypeId = this.getClassTypeId();
        assetEntryCacheModel.listable = this.isListable();
        assetEntryCacheModel.visible = this.isVisible();
        Date startDate = this.getStartDate();
        assetEntryCacheModel.startDate = startDate != null ? startDate.getTime() : Long.MIN_VALUE;
        Date endDate = this.getEndDate();
        assetEntryCacheModel.endDate = endDate != null ? endDate.getTime() : Long.MIN_VALUE;
        Date publishDate = this.getPublishDate();
        assetEntryCacheModel.publishDate = publishDate != null ? publishDate.getTime() : Long.MIN_VALUE;
        Date expirationDate = this.getExpirationDate();
        assetEntryCacheModel.expirationDate = expirationDate != null ? expirationDate.getTime() : Long.MIN_VALUE;
        assetEntryCacheModel.mimeType = this.getMimeType();
        String mimeType = assetEntryCacheModel.mimeType;
        if (mimeType != null && mimeType.length() == 0) {
            assetEntryCacheModel.mimeType = null;
        }
        if ((title = (assetEntryCacheModel.title = this.getTitle())) != null && title.length() == 0) {
            assetEntryCacheModel.title = null;
        }
        if ((description = (assetEntryCacheModel.description = this.getDescription())) != null && description.length() == 0) {
            assetEntryCacheModel.description = null;
        }
        if ((summary = (assetEntryCacheModel.summary = this.getSummary())) != null && summary.length() == 0) {
            assetEntryCacheModel.summary = null;
        }
        if ((url = (assetEntryCacheModel.url = this.getUrl())) != null && url.length() == 0) {
            assetEntryCacheModel.url = null;
        }
        if ((layoutUuid = (assetEntryCacheModel.layoutUuid = this.getLayoutUuid())) != null && layoutUuid.length() == 0) {
            assetEntryCacheModel.layoutUuid = null;
        }
        assetEntryCacheModel.height = this.getHeight();
        assetEntryCacheModel.width = this.getWidth();
        assetEntryCacheModel.priority = this.getPriority();
        assetEntryCacheModel.viewCount = this.getViewCount();
        return assetEntryCacheModel;
    }

    public String toString() {
        Map<String, Function<AssetEntry, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(4 * attributeGetterFunctions.size() + 2);
        sb.append("{");
        for (Map.Entry<String, Function<AssetEntry, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<AssetEntry, Object> attributeGetterFunction = entry.getValue();
            sb.append(attributeName);
            sb.append("=");
            sb.append(attributeGetterFunction.apply((AssetEntry)((Object)this)));
            sb.append(", ");
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toXmlString() {
        Map<String, Function<AssetEntry, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 4);
        sb.append("<model><model-name>");
        sb.append(this.getModelClassName());
        sb.append("</model-name>");
        for (Map.Entry<String, Function<AssetEntry, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<AssetEntry, Object> attributeGetterFunction = entry.getValue();
            sb.append("<column><column-name>");
            sb.append(attributeName);
            sb.append("</column-name><column-value><![CDATA[");
            sb.append(attributeGetterFunction.apply((AssetEntry)((Object)this)));
            sb.append("]]></column-value></column>");
        }
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("entryId", -5);
        TABLE_COLUMNS_MAP.put("groupId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("userName", 12);
        TABLE_COLUMNS_MAP.put("createDate", 93);
        TABLE_COLUMNS_MAP.put("modifiedDate", 93);
        TABLE_COLUMNS_MAP.put("classNameId", -5);
        TABLE_COLUMNS_MAP.put("classPK", -5);
        TABLE_COLUMNS_MAP.put("classUuid", 12);
        TABLE_COLUMNS_MAP.put("classTypeId", -5);
        TABLE_COLUMNS_MAP.put("listable", 16);
        TABLE_COLUMNS_MAP.put("visible", 16);
        TABLE_COLUMNS_MAP.put("startDate", 93);
        TABLE_COLUMNS_MAP.put("endDate", 93);
        TABLE_COLUMNS_MAP.put("publishDate", 93);
        TABLE_COLUMNS_MAP.put("expirationDate", 93);
        TABLE_COLUMNS_MAP.put("mimeType", 12);
        TABLE_COLUMNS_MAP.put("title", 12);
        TABLE_COLUMNS_MAP.put("description", 2005);
        TABLE_COLUMNS_MAP.put("summary", 2005);
        TABLE_COLUMNS_MAP.put("url", 12);
        TABLE_COLUMNS_MAP.put("layoutUuid", 12);
        TABLE_COLUMNS_MAP.put("height", 4);
        TABLE_COLUMNS_MAP.put("width", 4);
        TABLE_COLUMNS_MAP.put("priority", 8);
        TABLE_COLUMNS_MAP.put("viewCount", 4);
        ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.entity.cache.enabled.com.liferay.asset.kernel.model.AssetEntry"), true);
        FINDER_CACHE_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.finder.cache.enabled.com.liferay.asset.kernel.model.AssetEntry"), true);
        COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(PropsUtil.get("value.object.column.bitmask.enabled.com.liferay.asset.kernel.model.AssetEntry"), true);
        MAPPING_TABLE_ASSETENTRIES_ASSETCATEGORIES_COLUMNS = new Object[][]{{"companyId", -5}, {"categoryId", -5}, {"entryId", -5}};
        FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETCATEGORIES = GetterUtil.getBoolean(PropsUtil.get("value.object.finder.cache.enabled.AssetEntries_AssetCategories"), true);
        MAPPING_TABLE_ASSETENTRIES_ASSETTAGS_COLUMNS = new Object[][]{{"companyId", -5}, {"entryId", -5}, {"tagId", -5}};
        FINDER_CACHE_ENABLED_ASSETENTRIES_ASSETTAGS = GetterUtil.getBoolean(PropsUtil.get("value.object.finder.cache.enabled.AssetEntries_AssetTags"), true);
        LOCK_EXPIRATION_TIME = GetterUtil.getLong(PropsUtil.get("lock.expiration.time.com.liferay.asset.kernel.model.AssetEntry"));
        LinkedHashMap<String, Function<AssetEntry, Object>> attributeGetterFunctions = new LinkedHashMap<String, Function<AssetEntry, Object>>();
        LinkedHashMap<String, BiConsumer<AssetEntry, Object>> attributeSetterBiConsumers = new LinkedHashMap<String, BiConsumer<AssetEntry, Object>>();
        attributeGetterFunctions.put("entryId", AssetEntryModel::getEntryId);
        attributeSetterBiConsumers.put("entryId", AssetEntryModel::setEntryId);
        attributeGetterFunctions.put("groupId", AssetEntryModel::getGroupId);
        attributeSetterBiConsumers.put("groupId", AssetEntryModel::setGroupId);
        attributeGetterFunctions.put("companyId", AssetEntryModel::getCompanyId);
        attributeSetterBiConsumers.put("companyId", AssetEntryModel::setCompanyId);
        attributeGetterFunctions.put("userId", AssetEntryModel::getUserId);
        attributeSetterBiConsumers.put("userId", AssetEntryModel::setUserId);
        attributeGetterFunctions.put("userName", AssetEntryModel::getUserName);
        attributeSetterBiConsumers.put("userName", AssetEntryModel::setUserName);
        attributeGetterFunctions.put("createDate", AssetEntryModel::getCreateDate);
        attributeSetterBiConsumers.put("createDate", AssetEntryModel::setCreateDate);
        attributeGetterFunctions.put("modifiedDate", AssetEntryModel::getModifiedDate);
        attributeSetterBiConsumers.put("modifiedDate", AssetEntryModel::setModifiedDate);
        attributeGetterFunctions.put("classNameId", AssetEntryModel::getClassNameId);
        attributeSetterBiConsumers.put("classNameId", AssetEntryModel::setClassNameId);
        attributeGetterFunctions.put("classPK", AssetEntryModel::getClassPK);
        attributeSetterBiConsumers.put("classPK", AssetEntryModel::setClassPK);
        attributeGetterFunctions.put("classUuid", AssetEntryModel::getClassUuid);
        attributeSetterBiConsumers.put("classUuid", AssetEntryModel::setClassUuid);
        attributeGetterFunctions.put("classTypeId", AssetEntryModel::getClassTypeId);
        attributeSetterBiConsumers.put("classTypeId", AssetEntryModel::setClassTypeId);
        attributeGetterFunctions.put("listable", AssetEntryModel::getListable);
        attributeSetterBiConsumers.put("listable", AssetEntryModel::setListable);
        attributeGetterFunctions.put("visible", AssetEntryModel::getVisible);
        attributeSetterBiConsumers.put("visible", AssetEntryModel::setVisible);
        attributeGetterFunctions.put("startDate", AssetEntryModel::getStartDate);
        attributeSetterBiConsumers.put("startDate", AssetEntryModel::setStartDate);
        attributeGetterFunctions.put("endDate", AssetEntryModel::getEndDate);
        attributeSetterBiConsumers.put("endDate", AssetEntryModel::setEndDate);
        attributeGetterFunctions.put("publishDate", AssetEntryModel::getPublishDate);
        attributeSetterBiConsumers.put("publishDate", AssetEntryModel::setPublishDate);
        attributeGetterFunctions.put("expirationDate", AssetEntryModel::getExpirationDate);
        attributeSetterBiConsumers.put("expirationDate", AssetEntryModel::setExpirationDate);
        attributeGetterFunctions.put("mimeType", AssetEntryModel::getMimeType);
        attributeSetterBiConsumers.put("mimeType", AssetEntryModel::setMimeType);
        attributeGetterFunctions.put("title", AssetEntryModel::getTitle);
        attributeSetterBiConsumers.put("title", AssetEntryModel::setTitle);
        attributeGetterFunctions.put("description", AssetEntryModel::getDescription);
        attributeSetterBiConsumers.put("description", AssetEntryModel::setDescription);
        attributeGetterFunctions.put("summary", AssetEntryModel::getSummary);
        attributeSetterBiConsumers.put("summary", AssetEntryModel::setSummary);
        attributeGetterFunctions.put("url", AssetEntryModel::getUrl);
        attributeSetterBiConsumers.put("url", AssetEntryModel::setUrl);
        attributeGetterFunctions.put("layoutUuid", AssetEntryModel::getLayoutUuid);
        attributeSetterBiConsumers.put("layoutUuid", AssetEntryModel::setLayoutUuid);
        attributeGetterFunctions.put("height", AssetEntryModel::getHeight);
        attributeSetterBiConsumers.put("height", AssetEntryModel::setHeight);
        attributeGetterFunctions.put("width", AssetEntryModel::getWidth);
        attributeSetterBiConsumers.put("width", AssetEntryModel::setWidth);
        attributeGetterFunctions.put("priority", AssetEntryModel::getPriority);
        attributeSetterBiConsumers.put("priority", AssetEntryModel::setPriority);
        attributeGetterFunctions.put("viewCount", AssetEntryModel::getViewCount);
        attributeSetterBiConsumers.put("viewCount", AssetEntryModel::setViewCount);
        _attributeGetterFunctions = Collections.unmodifiableMap(attributeGetterFunctions);
        _attributeSetterBiConsumers = Collections.unmodifiableMap(attributeSetterBiConsumers);
        _escapedModelProxyProviderFunction = AssetEntryModelImpl._getProxyProviderFunction();
    }
}

