/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portlet.asset.model.impl.AssetEntryBaseImpl;
import java.util.List;

public class AssetEntryImpl
extends AssetEntryBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(AssetEntryImpl.class);

    @Override
    public AssetRenderer<?> getAssetRenderer() {
        AssetRendererFactory<?> assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
        try {
            return assetRendererFactory.getAssetRenderer(this.getClassPK());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to get asset renderer", e);
            }
            return null;
        }
    }

    @Override
    public AssetRendererFactory<?> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
    }

    @Override
    public List<AssetCategory> getCategories() {
        return AssetCategoryLocalServiceUtil.getEntryCategories(this.getEntryId());
    }

    @Override
    public long[] getCategoryIds() {
        return ListUtil.toLongArray(this.getCategories(), AssetCategory.CATEGORY_ID_ACCESSOR);
    }

    @Override
    public String[] getTagNames() {
        return ListUtil.toArray(this.getTags(), AssetTag.NAME_ACCESSOR);
    }

    @Override
    public List<AssetTag> getTags() {
        return AssetTagLocalServiceUtil.getEntryTags(this.getEntryId());
    }
}

