/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.impl;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetVocabularyLocalServiceUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.asset.model.impl.AssetCategoryBaseImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class AssetCategoryImpl
extends AssetCategoryBaseImpl {
    @Override
    public List<AssetCategory> getAncestors() throws PortalException {
        ArrayList<AssetCategory> categories = new ArrayList<AssetCategory>();
        AssetCategory category = this;
        while (!category.isRootCategory()) {
            category = AssetCategoryLocalServiceUtil.getAssetCategory(category.getParentCategoryId());
            categories.add(category);
        }
        return categories;
    }

    @Override
    public AssetCategory getParentCategory() {
        return AssetCategoryLocalServiceUtil.fetchCategory(this.getParentCategoryId());
    }

    @Override
    public String getPath(Locale locale) throws PortalException {
        return this.getPath(locale, false);
    }

    @Override
    public String getPath(Locale locale, boolean reverse) throws PortalException {
        List<AssetCategory> categories = this.getAncestors();
        StringBundler sb = new StringBundler(categories.size() * 4 + 1);
        AssetVocabulary vocabulary = AssetVocabularyLocalServiceUtil.getVocabulary(this.getVocabularyId());
        sb.append(vocabulary.getTitle(locale));
        if (reverse) {
            Collections.reverse(categories);
        }
        for (AssetCategory category : categories) {
            sb.append(" ");
            sb.append(">");
            sb.append(" ");
            sb.append(category.getTitle(locale));
        }
        return sb.toString();
    }

    @Override
    public String getTitle(String languageId) {
        String value = super.getTitle(languageId);
        if (Validator.isNull(value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public String getTitle(String languageId, boolean useDefault) {
        String value = super.getTitle(languageId, useDefault);
        if (Validator.isNull(value)) {
            value = this.getName();
        }
        return value;
    }

    @Override
    public boolean isRootCategory() {
        return this.getParentCategoryId() == 0L;
    }
}

