/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.model.adapter.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.adapter.StagedAssetLink;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class StagedAssetLinkImpl
implements StagedAssetLink {
    private AssetLink _assetLink;
    private String _entry1ClassName;
    private String _entry1Uuid;
    private String _entry2ClassName;
    private String _entry2Uuid;
    private String _uuid;

    public StagedAssetLinkImpl() {
    }

    public StagedAssetLinkImpl(AssetLink assetLink) {
        this._assetLink = assetLink;
        this.populateEntry1Attributes();
        this.populateEntry2Attributes();
        this.populateUuid();
    }

    @Override
    public Object clone() {
        return new StagedAssetLinkImpl(this._assetLink);
    }

    @Override
    public int compareTo(AssetLink assetLink) {
        return this._assetLink.compareTo(assetLink);
    }

    @Override
    public long getCompanyId() {
        return this._assetLink.getCompanyId();
    }

    @Override
    public Date getCreateDate() {
        return this._assetLink.getCreateDate();
    }

    @Override
    public String getEntry1ClassName() {
        if (Validator.isNotNull(this._entry1ClassName)) {
            return this._entry1ClassName;
        }
        this.populateEntry1Attributes();
        return this._entry1ClassName;
    }

    @Override
    public String getEntry1Uuid() {
        if (Validator.isNotNull(this._entry1Uuid)) {
            return this._entry1Uuid;
        }
        this.populateEntry1Attributes();
        return this._entry1Uuid;
    }

    @Override
    public String getEntry2ClassName() {
        if (Validator.isNotNull(this._entry2ClassName)) {
            return this._entry2ClassName;
        }
        this.populateEntry2Attributes();
        return this._entry2ClassName;
    }

    @Override
    public String getEntry2Uuid() {
        if (Validator.isNotNull(this._entry2Uuid)) {
            return this._entry2Uuid;
        }
        this.populateEntry2Attributes();
        return this._entry2Uuid;
    }

    @Override
    public long getEntryId1() {
        return this._assetLink.getEntryId1();
    }

    @Override
    public long getEntryId2() {
        return this._assetLink.getEntryId2();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._assetLink.getExpandoBridge();
    }

    @Override
    public long getLinkId() {
        return this._assetLink.getLinkId();
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        return this._assetLink.getModelAttributes();
    }

    @Override
    public Class<?> getModelClass() {
        return this._assetLink.getModelClass();
    }

    @Override
    public String getModelClassName() {
        return this._assetLink.getModelClassName();
    }

    @Override
    public Date getModifiedDate() {
        return this._assetLink.getCreateDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._assetLink.getPrimaryKey();
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return this._assetLink.getPrimaryKeyObj();
    }

    @Override
    public StagedModelType getStagedModelType() {
        return new StagedModelType(StagedAssetLink.class);
    }

    @Override
    public int getType() {
        return this._assetLink.getType();
    }

    @Override
    public long getUserId() {
        return this._assetLink.getUserId();
    }

    @Override
    public String getUserName() {
        return this._assetLink.getUserName();
    }

    @Override
    public String getUserUuid() {
        return this._assetLink.getUserUuid();
    }

    @Override
    public String getUuid() {
        if (Validator.isNotNull(this._uuid)) {
            return this._uuid;
        }
        this.populateUuid();
        return this._uuid;
    }

    @Override
    public int getWeight() {
        return this._assetLink.getWeight();
    }

    @Override
    public boolean isCachedModel() {
        return false;
    }

    @Override
    public boolean isEntityCacheEnabled() {
        return false;
    }

    @Override
    public boolean isEscapedModel() {
        return false;
    }

    @Override
    public boolean isFinderCacheEnabled() {
        return false;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public void persist() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resetOriginalValues() {
        throw new UnsupportedOperationException();
    }

    public void setAssetLink(AssetLink assetLink) {
        this._assetLink = assetLink;
    }

    @Override
    public void setCachedModel(boolean cachedModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCompanyId(long companyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCreateDate(Date createDate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntryId1(long entryId1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntryId2(long entryId2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExpandoBridgeAttributes(BaseModel<?> baseModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLinkId(long linkId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModifiedDate(Date date) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNew(boolean n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setType(int type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUserId(long userId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUserName(String userName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUserUuid(String userUuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUuid(String uuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setWeight(int weight) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheModel<AssetLink> toCacheModel() {
        return null;
    }

    @Override
    public AssetLink toEscapedModel() {
        return null;
    }

    @Override
    public AssetLink toUnescapedModel() {
        return null;
    }

    @Override
    public String toXmlString() {
        return null;
    }

    protected void populateEntry1Attributes() {
        if (Validator.isNotNull(this._entry1ClassName) && Validator.isNotNull(this._entry1Uuid)) {
            return;
        }
        AssetEntry entry1 = AssetEntryLocalServiceUtil.fetchAssetEntry(this._assetLink.getEntryId1());
        if (entry1 == null) {
            return;
        }
        this._entry1ClassName = entry1.getClassName();
        this._entry1Uuid = entry1.getClassUuid();
    }

    protected void populateEntry2Attributes() {
        if (Validator.isNotNull(this._entry2ClassName) && Validator.isNotNull(this._entry2Uuid)) {
            return;
        }
        AssetEntry entry2 = AssetEntryLocalServiceUtil.fetchAssetEntry(this._assetLink.getEntryId2());
        if (entry2 == null) {
            return;
        }
        this._entry2ClassName = entry2.getClassName();
        this._entry2Uuid = entry2.getClassUuid();
    }

    protected void populateUuid() {
        if (Validator.isNotNull(this._uuid)) {
            return;
        }
        String entry1Uuid = this.getEntry1Uuid();
        String entry2Uuid = this.getEntry2Uuid();
        if (Validator.isNotNull(entry1Uuid) && Validator.isNotNull(entry2Uuid)) {
            this._uuid = entry1Uuid + "#" + entry2Uuid;
        }
    }
}

