/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.asset.action;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryServiceUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.struts.JSONAction;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetCategoriesAction
extends JSONAction {
    @Override
    public String getJSON(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        List<AssetCategory> categories = this.getCategories(httpServletRequest);
        for (AssetCategory category : categories) {
            List<AssetCategory> childCategories = AssetCategoryServiceUtil.getChildCategories(category.getCategoryId());
            JSONObject jsonObject = JSONUtil.put("categoryId", (Object)category.getCategoryId()).put("childrenCount", childCategories.size()).put("hasChildren", !childCategories.isEmpty()).put("name", category.getName()).put("parentCategoryId", category.getParentCategoryId()).put("titleCurrentValue", category.getTitleCurrentValue());
            jsonArray.put(jsonObject);
        }
        return jsonArray.toString();
    }

    protected List<AssetCategory> getCategories(HttpServletRequest httpServletRequest) throws Exception {
        long scopeGroupId = ParamUtil.getLong(httpServletRequest, "scopeGroupId");
        long categoryId = ParamUtil.getLong(httpServletRequest, "categoryId");
        long vocabularyId = ParamUtil.getLong(httpServletRequest, "vocabularyId");
        int start = ParamUtil.getInteger(httpServletRequest, "start", -1);
        int end = ParamUtil.getInteger(httpServletRequest, "end", -1);
        List<AssetCategory> categories = Collections.emptyList();
        if (categoryId > 0L) {
            categories = scopeGroupId > 0L ? AssetCategoryServiceUtil.getVocabularyCategories(scopeGroupId, categoryId, vocabularyId, start, end, null) : AssetCategoryServiceUtil.getChildCategories(categoryId, start, end, null);
        } else if (vocabularyId > 0L) {
            long parentCategoryId = ParamUtil.getLong(httpServletRequest, "parentCategoryId", 0L);
            categories = scopeGroupId > 0L ? AssetCategoryServiceUtil.getVocabularyCategories(scopeGroupId, parentCategoryId, vocabularyId, start, end, null) : AssetCategoryServiceUtil.getVocabularyCategories(parentCategoryId, vocabularyId, start, end, null);
        }
        return categories;
    }
}

