/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.persistence.impl;

import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.announcements.kernel.service.persistence.AnnouncementsEntryFinder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.announcements.model.impl.AnnouncementsEntryImpl;
import com.liferay.portlet.announcements.service.persistence.impl.AnnouncementsEntryFinderBaseImpl;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AnnouncementsEntryFinderImpl
extends AnnouncementsEntryFinderBaseImpl
implements AnnouncementsEntryFinder {
    public static final String COUNT_BY_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".countByHidden";
    public static final String COUNT_BY_NOT_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".countByNotHidden";
    public static final String FIND_BY_DISPLAY_DATE = AnnouncementsEntryFinder.class.getName() + ".findByDisplayDate";
    public static final String FIND_BY_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".findByHidden";
    public static final String FIND_BY_NOT_HIDDEN = AnnouncementsEntryFinder.class.getName() + ".findByNotHidden";
    private static final Log _log = LogFactoryUtil.getLog(AnnouncementsEntryFinderImpl.class);

    @Override
    public int countByScope(long companyId, long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get(COUNT_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get(COUNT_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace(sql, "[$CLASS_PKS$]", this.getClassPKs(classNameId, classPKs));
            sql = CustomSQLUtil.replaceAndOperator(sql, true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            if (flagValue == -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            qPos.add(companyId);
            this.setClassPKs(qPos, classNameId, classPKs);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            if (flagValue != -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    @Deprecated
    public int countByScope(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        return this.countByScope(CompanyThreadLocal.getCompanyId(), userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    @Override
    @Deprecated
    public int countByScopes(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        return this.countByScopes(CompanyThreadLocal.getCompanyId(), userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    @Override
    public int countByScopes(long companyId, long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        Session session = null;
        try {
            Long count;
            Iterator itr;
            session = this.openSession();
            String sql = CustomSQLUtil.get(COUNT_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get(COUNT_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace(sql, "[$CLASS_PKS$]", this.getClassPKs(scopes));
            sql = CustomSQLUtil.replaceAndOperator(sql, true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance(q);
            if (flagValue == -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            qPos.add(companyId);
            this.setClassPKs(qPos, scopes);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            if (flagValue != -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            if ((itr = q.iterate()).hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<AnnouncementsEntry> findByDisplayDate(Date displayDateLT, Date displayDateGT) {
        Timestamp displayDateLT_TS = CalendarUtil.getTimestamp(displayDateLT);
        Timestamp displayDateGT_TS = CalendarUtil.getTimestamp(displayDateGT);
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(FIND_BY_DISPLAY_DATE);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AnnouncementsEntry", AnnouncementsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance(q);
            qPos.add(displayDateGT_TS);
            qPos.add(displayDateLT_TS);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public List<AnnouncementsEntry> findByScope(long companyId, long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(FIND_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get(FIND_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace(sql, "[$CLASS_PKS$]", this.getClassPKs(classNameId, classPKs));
            sql = CustomSQLUtil.replaceAndOperator(sql, true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AnnouncementsEntry", AnnouncementsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance(q);
            this.setClassPKs(qPos, classNameId, classPKs);
            if (flagValue == -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            qPos.add(companyId);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            if (flagValue != -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            List<AnnouncementsEntry> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    @Deprecated
    public List<AnnouncementsEntry> findByScope(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        return this.findByScope(CompanyThreadLocal.getCompanyId(), userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    @Override
    @Deprecated
    public List<AnnouncementsEntry> findByScopes(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        return this.findByScopes(CompanyThreadLocal.getCompanyId(), userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    @Override
    public List<AnnouncementsEntry> findByScopes(long companyId, long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(FIND_BY_HIDDEN);
            if (flagValue == -1) {
                sql = CustomSQLUtil.get(FIND_BY_NOT_HIDDEN);
            }
            sql = StringUtil.replace(sql, "[$CLASS_PKS$]", this.getClassPKs(scopes));
            sql = CustomSQLUtil.replaceAndOperator(sql, true);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("AnnouncementsEntry", AnnouncementsEntryImpl.class);
            QueryPos qPos = QueryPos.getInstance(q);
            if (flagValue == -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            qPos.add(companyId);
            this.setClassPKs(qPos, scopes);
            this.setDates(qPos, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute);
            qPos.add(alert);
            if (flagValue != -1) {
                qPos.add(userId);
                qPos.add(2);
            }
            List<AnnouncementsEntry> list = QueryUtil.list(q, this.getDialect(), start, end);
            return list;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getClassPKs(LinkedHashMap<Long, long[]> scopes) {
        if (scopes == null || scopes.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(scopes.size() * 4);
        for (Map.Entry<Long, long[]> entry : scopes.entrySet()) {
            Long classNameId = entry.getKey();
            long[] classPKs = entry.getValue();
            sb.append("(");
            sb.append(this.getClassPKs(classNameId, classPKs));
            sb.append(")");
            sb.append(" OR ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    protected String getClassPKs(long classNameId, long[] classPKs) {
        if (classPKs.length == 0) {
            return "(AnnouncementsEntry.classNameId = ?) AND (";
        }
        StringBundler sb = new StringBundler(classPKs.length * 2 + 1);
        sb.append("(AnnouncementsEntry.classNameId = ?) AND (");
        for (int i = 0; i < classPKs.length; ++i) {
            sb.append("(AnnouncementsEntry.classPK = ?)");
            if (i + 1 < classPKs.length) {
                sb.append(" OR ");
                continue;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    protected void setClassPKs(QueryPos qPos, LinkedHashMap<Long, long[]> scopes) {
        if (scopes == null) {
            return;
        }
        for (Map.Entry<Long, long[]> entry : scopes.entrySet()) {
            Long classNameId = entry.getKey();
            long[] classPKs = entry.getValue();
            this.setClassPKs(qPos, classNameId, classPKs);
        }
    }

    protected void setClassPKs(QueryPos qPos, long classNameId, long[] classPKs) {
        qPos.add(classNameId);
        for (long classPK : classPKs) {
            qPos.add(classPK);
        }
    }

    protected void setDates(QueryPos qPos, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute) {
        Date expirationDate;
        Timestamp displayDateTS;
        block7: {
            Date displayDate;
            block6: {
                displayDate = null;
                try {
                    displayDate = PortalUtil.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, null);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug(pe, pe);
                }
            }
            if (displayDate == null) {
                displayDate = new Date();
            }
            displayDateTS = CalendarUtil.getTimestamp(displayDate);
            expirationDate = null;
            try {
                expirationDate = PortalUtil.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, null);
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block7;
                _log.debug(pe, pe);
            }
        }
        if (expirationDate == null) {
            expirationDate = new Date();
        }
        Timestamp expirationDateTS = CalendarUtil.getTimestamp(expirationDate);
        qPos.add(displayDateTS);
        qPos.add(displayDateTS);
        qPos.add(expirationDateTS);
        qPos.add(expirationDateTS);
    }
}

