/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.model.AnnouncementsFlag;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portlet.announcements.service.base.AnnouncementsFlagLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class AnnouncementsFlagLocalServiceImpl
extends AnnouncementsFlagLocalServiceBaseImpl {
    @Override
    public AnnouncementsFlag addFlag(long userId, long entryId, int value) {
        long flagId = this.counterLocalService.increment();
        AnnouncementsFlag flag = this.announcementsFlagPersistence.create(flagId);
        flag.setUserId(userId);
        flag.setCreateDate(new Date());
        flag.setEntryId(entryId);
        flag.setValue(value);
        this.announcementsFlagPersistence.update(flag);
        return flag;
    }

    @Override
    public void deleteFlag(AnnouncementsFlag flag) {
        this.announcementsFlagPersistence.remove(flag);
    }

    @Override
    public void deleteFlag(long flagId) throws PortalException {
        AnnouncementsFlag flag = this.announcementsFlagPersistence.findByPrimaryKey(flagId);
        this.deleteFlag(flag);
    }

    @Override
    public void deleteFlags(long entryId) {
        List<AnnouncementsFlag> flags = this.announcementsFlagPersistence.findByEntryId(entryId);
        for (AnnouncementsFlag flag : flags) {
            this.deleteFlag(flag);
        }
    }

    @Override
    public AnnouncementsFlag getFlag(long userId, long entryId, int value) throws PortalException {
        return this.announcementsFlagPersistence.findByU_E_V(userId, entryId, value);
    }
}

