/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.exception.EntryDisplayDateException;
import com.liferay.announcements.kernel.exception.EntryExpirationDateException;
import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.service.permission.RolePermissionUtil;
import com.liferay.portal.kernel.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryServiceBaseImpl;
import com.liferay.portlet.announcements.service.permission.AnnouncementsEntryPermission;
import java.util.Date;

public class AnnouncementsEntryServiceImpl
extends AnnouncementsEntryServiceBaseImpl {
    @Override
    @Deprecated
    public AnnouncementsEntry addEntry(long plid, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException {
        User user = this.getUser();
        Date displayDate = new Date();
        if (!displayImmediately) {
            displayDate = PortalUtil.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), EntryDisplayDateException.class);
        }
        Date expirationDate = PortalUtil.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), EntryExpirationDateException.class);
        return this.addEntry(classNameId, classPK, title, content, url, type, displayDate, expirationDate, priority, alert);
    }

    @Override
    public AnnouncementsEntry addEntry(long classNameId, long classPK, String title, String content, String url, String type, Date displayDate, Date expirationDate, int priority, boolean alert) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (classNameId == 0L) {
            if (!PortalPermissionUtil.contains(permissionChecker, "ADD_GENERAL_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, "90", "90", "ADD_GENERAL_ANNOUNCEMENTS");
            }
        } else {
            String className = PortalUtil.getClassName(classNameId);
            if (className.equals(Group.class.getName()) && !GroupPermissionUtil.contains(permissionChecker, classPK, "MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, "MANAGE_ANNOUNCEMENTS");
            }
            if (className.equals(Organization.class.getName()) && !OrganizationPermissionUtil.contains(permissionChecker, classPK, "MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, "MANAGE_ANNOUNCEMENTS");
            }
            if (className.equals(Role.class.getName())) {
                Role role = this.roleLocalService.getRole(classPK);
                if (role.isTeam()) {
                    Team team = this.teamLocalService.getTeam(role.getClassPK());
                    if (!GroupPermissionUtil.contains(permissionChecker, team.getGroupId(), "MANAGE_ANNOUNCEMENTS") || !RolePermissionUtil.contains(permissionChecker, team.getGroupId(), classPK, "MANAGE_ANNOUNCEMENTS")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, Team.class.getName(), classPK, "MANAGE_ANNOUNCEMENTS");
                    }
                } else if (!RolePermissionUtil.contains(permissionChecker, classPK, "MANAGE_ANNOUNCEMENTS")) {
                    throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, "MANAGE_ANNOUNCEMENTS");
                }
            }
            if (className.equals(UserGroup.class.getName()) && !UserGroupPermissionUtil.contains(permissionChecker, classPK, "MANAGE_ANNOUNCEMENTS")) {
                throw new PrincipalException.MustHavePermission(permissionChecker, className, classPK, "MANAGE_ANNOUNCEMENTS");
            }
        }
        return this.announcementsEntryLocalService.addEntry(this.getUserId(), classNameId, classPK, title, content, url, type, displayDate, expirationDate, priority, alert);
    }

    @Override
    public void deleteEntry(long entryId) throws PortalException {
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entryId, "DELETE");
        this.announcementsEntryLocalService.deleteEntry(entryId);
    }

    @Override
    public AnnouncementsEntry getEntry(long entryId) throws PortalException {
        AnnouncementsEntry entry = this.announcementsEntryLocalService.getEntry(entryId);
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entry, "VIEW");
        return entry;
    }

    @Override
    public AnnouncementsEntry updateEntry(long entryId, String title, String content, String url, String type, Date displayDate, Date expirationDate, int priority) throws PortalException {
        AnnouncementsEntryPermission.check(this.getPermissionChecker(), entryId, "UPDATE");
        return this.announcementsEntryLocalService.updateEntry(entryId, title, content, url, type, displayDate, expirationDate, priority);
    }

    @Override
    @Deprecated
    public AnnouncementsEntry updateEntry(long entryId, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority) throws PortalException {
        User user = this.getUser();
        Date displayDate = new Date();
        if (!displayImmediately) {
            displayDate = PortalUtil.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), EntryDisplayDateException.class);
        }
        Date expirationDate = PortalUtil.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), EntryExpirationDateException.class);
        return this.updateEntry(entryId, title, content, url, type, displayDate, expirationDate, priority);
    }
}

