/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.announcements.service.impl;

import com.liferay.announcements.kernel.exception.EntryContentException;
import com.liferay.announcements.kernel.exception.EntryDisplayDateException;
import com.liferay.announcements.kernel.exception.EntryExpirationDateException;
import com.liferay.announcements.kernel.exception.EntryTitleException;
import com.liferay.announcements.kernel.exception.EntryURLException;
import com.liferay.announcements.kernel.model.AnnouncementsDelivery;
import com.liferay.announcements.kernel.model.AnnouncementsEntry;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.mail.kernel.service.MailService;
import com.liferay.mail.kernel.template.MailTemplate;
import com.liferay.mail.kernel.template.MailTemplateContext;
import com.liferay.mail.kernel.template.MailTemplateContextBuilder;
import com.liferay.mail.kernel.template.MailTemplateFactoryUtil;
import com.liferay.petra.content.ContentUtil;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.interval.IntervalActionProcessor;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.EscapableLocalizableFunction;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.announcements.service.base.AnnouncementsEntryLocalServiceBaseImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.mail.internet.InternetAddress;

public class AnnouncementsEntryLocalServiceImpl
extends AnnouncementsEntryLocalServiceBaseImpl {
    @BeanReference(type=MailService.class)
    protected MailService mailService;
    private static final long _ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL = (long)PropsValues.ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL * 60000L;
    private static final Log _log = LogFactoryUtil.getLog(AnnouncementsEntryLocalServiceImpl.class);

    @Override
    public AnnouncementsEntry addEntry(long userId, long classNameId, long classPK, String title, String content, String url, String type, Date displayDate, Date expirationDate, int priority, boolean alert) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validate(title, content, url, displayDate, expirationDate);
        long entryId = this.counterLocalService.increment();
        AnnouncementsEntry entry = this.announcementsEntryPersistence.create(entryId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setClassNameId(classNameId);
        entry.setClassPK(classPK);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        entry.setAlert(alert);
        this.announcementsEntryPersistence.update(entry);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), AnnouncementsEntry.class.getName(), entry.getEntryId(), false, false, false);
        return entry;
    }

    @Override
    @Deprecated
    public AnnouncementsEntry addEntry(long userId, long classNameId, long classPK, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority, boolean alert) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = new Date();
        if (!displayImmediately) {
            displayDate = PortalUtil.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), EntryDisplayDateException.class);
        }
        Date expirationDate = PortalUtil.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), EntryExpirationDateException.class);
        return this.addEntry(userId, classNameId, classPK, title, content, url, type, displayDate, expirationDate, priority, alert);
    }

    @Override
    public void checkEntries() throws PortalException {
        Date now = new Date();
        Date previousCheckDate = new Date(now.getTime() - _ANNOUNCEMENTS_ENTRY_CHECK_INTERVAL);
        this.checkEntries(previousCheckDate, now);
    }

    @Override
    public void checkEntries(Date startDate, Date endDate) throws PortalException {
        List<AnnouncementsEntry> entries = this.announcementsEntryFinder.findByDisplayDate(endDate, startDate);
        if (_log.isDebugEnabled()) {
            _log.debug("Processing " + entries.size() + " entries");
        }
        for (AnnouncementsEntry entry : entries) {
            this.notifyUsers(entry);
        }
    }

    @Override
    public void deleteEntries(long classNameId, long classPK) throws PortalException {
        List<AnnouncementsEntry> entries = this.announcementsEntryPersistence.findByC_C(classNameId, classPK);
        for (AnnouncementsEntry entry : entries) {
            this.deleteEntry(entry);
        }
    }

    @Override
    public void deleteEntries(long companyId, long classNameId, long classPK) throws PortalException {
        List<AnnouncementsEntry> entries = this.announcementsEntryPersistence.findByC_C_C(companyId, classNameId, classPK);
        for (AnnouncementsEntry entry : entries) {
            this.deleteEntry(entry);
        }
    }

    @Override
    public void deleteEntry(AnnouncementsEntry entry) throws PortalException {
        this.announcementsEntryPersistence.remove(entry);
        this.resourceLocalService.deleteResource(entry.getCompanyId(), AnnouncementsEntry.class.getName(), 4, entry.getEntryId());
        this.announcementsFlagLocalService.deleteFlags(entry.getEntryId());
    }

    @Override
    public void deleteEntry(long entryId) throws PortalException {
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    @Override
    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue, int start, int end) {
        return this.getEntries(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue, start, end);
    }

    @Override
    public List<AnnouncementsEntry> getEntries(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        User user = this.userLocalService.fetchUser(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        return this.announcementsEntryFinder.findByScopes(user.getCompanyId(), userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    @Override
    @Deprecated
    public List<AnnouncementsEntry> getEntries(long classNameId, long classPK, boolean alert, int start, int end) {
        return this.getEntries((long)CompanyThreadLocal.getCompanyId(), classNameId, classPK, alert, start, end);
    }

    @Override
    public List<AnnouncementsEntry> getEntries(long companyId, long classNameId, long classPK, boolean alert, int start, int end) {
        return this.announcementsEntryPersistence.findByC_C_C_A(companyId, classNameId, classPK, alert, start, end);
    }

    @Override
    public List<AnnouncementsEntry> getEntries(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue, int start, int end) {
        User user = this.userLocalService.fetchUser(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        return this.announcementsEntryFinder.findByScope(user.getCompanyId(), userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue, start, end);
    }

    @Override
    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, boolean alert, int flagValue) {
        return this.getEntriesCount(userId, scopes, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    @Override
    public int getEntriesCount(long userId, LinkedHashMap<Long, long[]> scopes, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        User user = this.userLocalService.fetchUser(userId);
        if (user == null) {
            return 0;
        }
        return this.announcementsEntryFinder.countByScopes(user.getCompanyId(), userId, scopes, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    @Override
    @Deprecated
    public int getEntriesCount(long classNameId, long classPK, boolean alert) {
        return this.getEntriesCount((long)CompanyThreadLocal.getCompanyId(), classNameId, classPK, alert);
    }

    @Override
    public int getEntriesCount(long companyId, long classNameId, long classPK, boolean alert) {
        return this.announcementsEntryPersistence.countByC_C_C_A(companyId, classNameId, classPK, alert);
    }

    @Override
    public int getEntriesCount(long userId, long classNameId, long[] classPKs, boolean alert, int flagValue) {
        return this.getEntriesCount(userId, classNameId, classPKs, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, alert, flagValue);
    }

    @Override
    public int getEntriesCount(long userId, long classNameId, long[] classPKs, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, boolean alert, int flagValue) {
        User user = this.userLocalService.fetchUser(userId);
        if (user == null) {
            return 0;
        }
        return this.announcementsEntryFinder.countByScope(user.getCompanyId(), userId, classNameId, classPKs, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, alert, flagValue);
    }

    @Override
    public AnnouncementsEntry getEntry(long entryId) throws PortalException {
        return this.announcementsEntryPersistence.findByPrimaryKey(entryId);
    }

    @Override
    public List<AnnouncementsEntry> getUserEntries(long userId, int start, int end) {
        return this.announcementsEntryPersistence.findByUserId(userId, start, end);
    }

    @Override
    public int getUserEntriesCount(long userId) {
        return this.announcementsEntryPersistence.countByUserId(userId);
    }

    @Override
    @Deprecated
    public AnnouncementsEntry updateEntry(long userId, long entryId, String title, String content, String url, String type, int displayDateMonth, int displayDateDay, int displayDateYear, int displayDateHour, int displayDateMinute, boolean displayImmediately, int expirationDateMonth, int expirationDateDay, int expirationDateYear, int expirationDateHour, int expirationDateMinute, int priority) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date displayDate = new Date();
        if (!displayImmediately) {
            displayDate = PortalUtil.getDate(displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, user.getTimeZone(), EntryDisplayDateException.class);
        }
        Date expirationDate = PortalUtil.getDate(expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, user.getTimeZone(), EntryExpirationDateException.class);
        return this.updateEntry(entryId, title, content, url, type, displayDate, expirationDate, priority);
    }

    @Override
    public AnnouncementsEntry updateEntry(long entryId, String title, String content, String url, String type, Date displayDate, Date expirationDate, int priority) throws PortalException {
        this.validate(title, content, url, displayDate, expirationDate);
        AnnouncementsEntry entry = this.announcementsEntryPersistence.findByPrimaryKey(entryId);
        entry.setTitle(title);
        entry.setContent(content);
        entry.setUrl(url);
        entry.setType(type);
        entry.setDisplayDate(displayDate);
        entry.setExpirationDate(expirationDate);
        entry.setPriority(priority);
        this.announcementsEntryPersistence.update(entry);
        this.announcementsFlagLocalService.deleteFlags(entry.getEntryId());
        return entry;
    }

    protected void notifyUsers(AnnouncementsEntry entry) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(entry.getCompanyId());
        String className = entry.getClassName();
        long classPK = entry.getClassPK();
        String toName = PropsValues.ANNOUNCEMENTS_EMAIL_TO_NAME;
        long teamId = 0L;
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("announcementsDeliveryEmailOrSms", entry.getType());
        if (classPK > 0L) {
            if (className.equals(Group.class.getName())) {
                Group group = this.groupPersistence.findByPrimaryKey(classPK);
                toName = group.getDescriptiveName();
                params.put("inherit", Boolean.TRUE);
                params.put("usersGroups", classPK);
            } else if (className.equals(Organization.class.getName())) {
                Organization organization = this.organizationPersistence.findByPrimaryKey(classPK);
                toName = organization.getName();
                params.put("usersOrgsTree", ListUtil.fromArray(new Organization[]{organization}));
            } else if (className.equals(Role.class.getName())) {
                Role role = this.rolePersistence.findByPrimaryKey(classPK);
                toName = role.getName();
                if (role.getType() == 1) {
                    params.put("inherit", Boolean.TRUE);
                    params.put("usersRoles", classPK);
                } else if (role.isTeam()) {
                    teamId = role.getClassPK();
                } else {
                    params.put("userGroupRole", new Long[]{0L, classPK});
                }
            } else if (className.equals(UserGroup.class.getName())) {
                UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(classPK);
                toName = userGroup.getName();
                params.put("usersUserGroups", classPK);
            }
        }
        if (className.equals(User.class.getName())) {
            User user = this.userPersistence.findByPrimaryKey(classPK);
            if (Validator.isNull(user.getEmailAddress())) {
                return;
            }
            this.notifyUsers(ListUtil.fromArray(new User[]{user}), entry, company.getLocale(), user.getEmailAddress(), user.getFullName());
        } else {
            String toAddress = PropsValues.ANNOUNCEMENTS_EMAIL_TO_ADDRESS;
            this.notifyUsers(entry, teamId, params, toName, toAddress, company);
        }
    }

    protected void notifyUsers(final AnnouncementsEntry entry, final long teamId, final LinkedHashMap<String, Object> params, final String toName, final String toAddress, final Company company) throws PortalException {
        int total = 0;
        total = teamId > 0L ? this.userLocalService.getTeamUsersCount(teamId) : this.userLocalService.searchCount(company.getCompanyId(), null, 0, params);
        final IntervalActionProcessor<Void> intervalActionProcessor = new IntervalActionProcessor<Void>(total);
        intervalActionProcessor.setPerformIntervalActionMethod(new IntervalActionProcessor.PerformIntervalActionMethod<Void>(){

            @Override
            public Void performIntervalAction(int start, int end) throws PortalException {
                List<User> users = null;
                users = teamId > 0L ? AnnouncementsEntryLocalServiceImpl.this.userLocalService.getTeamUsers(teamId, start, end) : AnnouncementsEntryLocalServiceImpl.this.userLocalService.search(company.getCompanyId(), null, 0, (LinkedHashMap<String, Object>)params, start, end, (OrderByComparator<User>)null);
                AnnouncementsEntryLocalServiceImpl.this.notifyUsers(users, entry, company.getLocale(), toAddress, toName);
                intervalActionProcessor.incrementStart(users.size());
                return null;
            }
        });
        intervalActionProcessor.performIntervalActions();
    }

    protected void notifyUsers(List<User> users, AnnouncementsEntry entry, Locale locale, String toAddress, String toName) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug("Notifying " + users.size() + " users");
        }
        HashMap<String, String> notifyUsersFullNames = new HashMap<String, String>();
        for (User user : users) {
            AnnouncementsDelivery announcementsDelivery = this.announcementsDeliveryLocalService.getUserDelivery(user.getUserId(), entry.getType());
            if (announcementsDelivery.isEmail()) {
                notifyUsersFullNames.put(user.getEmailAddress(), user.getFullName());
            }
            if (!announcementsDelivery.isSms()) continue;
            Contact contact = user.getContact();
            notifyUsersFullNames.put(contact.getSmsSn(), user.getFullName());
        }
        if (notifyUsersFullNames.isEmpty()) {
            return;
        }
        Class<?> clazz = this.getClass();
        String body = ContentUtil.get(clazz.getClassLoader(), PropsValues.ANNOUNCEMENTS_EMAIL_BODY);
        String fromAddress = PrefsPropsUtil.getStringFromNames(entry.getCompanyId(), "announcements.email.from.address", "admin.email.from.address");
        String fromName = PrefsPropsUtil.getStringFromNames(entry.getCompanyId(), "announcements.email.from.name", "admin.email.from.name");
        String subject = ContentUtil.get(clazz.getClassLoader(), PropsValues.ANNOUNCEMENTS_EMAIL_SUBJECT);
        Company company = this.companyLocalService.getCompany(entry.getCompanyId());
        this._sendNotificationEmail(fromAddress, fromName, toAddress, toName, subject, body, company, entry);
        for (String curToAddress : notifyUsersFullNames.keySet()) {
            String curToName = (String)notifyUsersFullNames.get(toAddress);
            this._sendNotificationEmail(fromAddress, fromName, curToAddress, curToName, subject, body, company, entry);
        }
    }

    protected void validate(String title, String content, String url, Date displayDate, Date expirationDate) throws PortalException {
        if (Validator.isNull(title)) {
            throw new EntryTitleException();
        }
        if (Validator.isNull(content)) {
            throw new EntryContentException();
        }
        if (Validator.isNotNull(url) && !Validator.isUrl(url)) {
            throw new EntryURLException();
        }
        if (expirationDate != null && (expirationDate.before(new Date()) || displayDate != null && expirationDate.before(displayDate))) {
            throw new EntryExpirationDateException("Expiration date " + expirationDate + " is in the past");
        }
    }

    private void _sendNotificationEmail(String fromAddress, String fromName, String toAddress, String toName, String subject, String body, Company company, AnnouncementsEntry entry) throws PortalException {
        String portalURL = company.getPortalURL(0L);
        MailTemplateContextBuilder mailTemplateContextBuilder = MailTemplateFactoryUtil.createMailTemplateContextBuilder();
        mailTemplateContextBuilder.put("[$COMPANY_ID$]", String.valueOf(company.getCompanyId()));
        mailTemplateContextBuilder.put("[$COMPANY_MX$]", company.getMx());
        mailTemplateContextBuilder.put("[$COMPANY_NAME$]", HtmlUtil.escape(company.getName()));
        mailTemplateContextBuilder.put("[$ENTRY_CONTENT$]", entry.getContent());
        mailTemplateContextBuilder.put("[$ENTRY_ID$]", String.valueOf(entry.getEntryId()));
        mailTemplateContextBuilder.put("[$ENTRY_TITLE$]", HtmlUtil.escape(entry.getTitle()));
        mailTemplateContextBuilder.put("[$ENTRY_TYPE$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get(locale, entry.getType())));
        mailTemplateContextBuilder.put("[$ENTRY_URL$]", entry.getUrl());
        mailTemplateContextBuilder.put("[$FROM_ADDRESS$]", fromAddress);
        mailTemplateContextBuilder.put("[$FROM_NAME$]", HtmlUtil.escape(fromName));
        mailTemplateContextBuilder.put("[$PORTAL_URL$]", portalURL);
        mailTemplateContextBuilder.put("[$PORTLET_NAME$]", new EscapableLocalizableFunction(locale -> LanguageUtil.get(locale, entry.isAlert() ? "alert" : "announcement")));
        if (entry.getGroupId() > 0L) {
            Group group = this.groupLocalService.getGroup(entry.getGroupId());
            mailTemplateContextBuilder.put("[$SITE_NAME$]", HtmlUtil.escape(group.getDescriptiveName()));
        }
        mailTemplateContextBuilder.put("[$TO_ADDRESS$]", toAddress);
        mailTemplateContextBuilder.put("[$TO_NAME$]", HtmlUtil.escape(toName));
        MailTemplateContext mailTemplateContext = mailTemplateContextBuilder.build();
        try {
            MailTemplate subjectTemplate = MailTemplateFactoryUtil.createMailTemplate(subject, false);
            MailTemplate bodyTemplate = MailTemplateFactoryUtil.createMailTemplate(body, true);
            User user = this.userLocalService.fetchUserByEmailAddress(entry.getCompanyId(), toAddress);
            Locale locale2 = LocaleUtil.getSiteDefault();
            if (user != null) {
                locale2 = user.getLocale();
            }
            MailMessage mailMessage = new MailMessage(new InternetAddress(fromAddress, fromName), new InternetAddress(toAddress, toName), subjectTemplate.renderAsString(locale2, mailTemplateContext), bodyTemplate.renderAsString(locale2, mailTemplateContext), true);
            mailMessage.setMessageId(PortalUtil.getMailId(company.getMx(), "announcements_entry", entry.getEntryId()));
            this.mailService.sendEmail(mailMessage);
        }
        catch (IOException ioe) {
            throw new SystemException(ioe);
        }
    }
}

