/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.admin.util;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class CleanUpPermissionsUtil {
    public static void cleanUpAddToPagePermissions(ActionRequest actionRequest) throws Exception {
        long companyId = PortalUtil.getCompanyId((PortletRequest)actionRequest);
        Role role = RoleLocalServiceUtil.getRole(companyId, "Guest");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions(companyId, role.getRoleId(), false);
        role = RoleLocalServiceUtil.getRole(companyId, "Power User");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions(companyId, role.getRoleId(), true);
        role = RoleLocalServiceUtil.getRole(companyId, "User");
        CleanUpPermissionsUtil._cleanUpAddToPagePermissions(companyId, role.getRoleId(), false);
    }

    private static void _cleanUpAddToPagePermissions(long companyId, long roleId, boolean limitScope) throws Exception {
        List<ResourcePermission> roleResourcePermissions = ResourcePermissionLocalServiceUtil.getRoleResourcePermissions(roleId);
        Group userPersonalSite = GroupLocalServiceUtil.getGroup(companyId, "User Personal Site");
        String groupIdString = String.valueOf(userPersonalSite.getGroupId());
        for (ResourcePermission resourcePermission : roleResourcePermissions) {
            if (!resourcePermission.hasActionId("ADD_TO_PAGE")) continue;
            ResourcePermissionLocalServiceUtil.removeResourcePermission(companyId, resourcePermission.getName(), resourcePermission.getScope(), resourcePermission.getPrimKey(), roleId, "ADD_TO_PAGE");
            if (!limitScope) continue;
            ResourcePermissionLocalServiceUtil.addResourcePermission(companyId, resourcePermission.getName(), 2, groupIdString, roleId, "ADD_TO_PAGE");
        }
    }
}

