/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.CustomUserAttributes;
import com.liferay.portal.kernel.portlet.UserAttributes;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class UserInfoFactory {
    private static final Log _log = LogFactoryUtil.getLog(UserInfoFactory.class);

    public static LinkedHashMap<String, String> getUserInfo(HttpServletRequest httpServletRequest, Portlet portlet) {
        if (httpServletRequest.getRemoteUser() == null) {
            return null;
        }
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        try {
            User user = PortalUtil.getUser(httpServletRequest);
            userInfo = UserInfoFactory.getUserInfo(user, userInfo, portlet);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return userInfo;
    }

    public static LinkedHashMap<String, String> getUserInfo(long userId, Portlet portlet) {
        if (userId <= 0L) {
            return null;
        }
        LinkedHashMap<String, String> userInfo = new LinkedHashMap<String, String>();
        try {
            User user = UserLocalServiceUtil.getUserById(userId);
            userInfo = UserInfoFactory.getUserInfo(user, userInfo, portlet);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return userInfo;
    }

    public static LinkedHashMap<String, String> getUserInfo(User user, LinkedHashMap<String, String> userInfo, Portlet portlet) {
        PortletApp portletApp = portlet.getPortletApp();
        try {
            UserAttributes userAttributes = new UserAttributes(user);
            userInfo.put("liferay.company.id", userAttributes.getValue("liferay.company.id"));
            userInfo.put("liferay.user.id", userAttributes.getValue("liferay.user.id"));
            userInfo.put("user.name.full", userAttributes.getValue("user.name.full"));
            for (String userAttributeName : portletApp.getUserAttributes()) {
                String userAttributeValue = userAttributes.getValue(userAttributeName);
                if (userAttributeValue == null) continue;
                userInfo.put(userAttributeName, userAttributeValue);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        Map<String, String> unmodifiableUserInfo = Collections.unmodifiableMap((Map)userInfo.clone());
        HashMap<String, CustomUserAttributes> customUserAttributesMap = new HashMap<String, CustomUserAttributes>();
        Map<String, String> customUserAttributesClassNames = portletApp.getCustomUserAttributes();
        for (Map.Entry<String, String> entry : customUserAttributesClassNames.entrySet()) {
            String userAttributeName;
            String attrValue;
            String customUserAttributesClassName = entry.getValue();
            CustomUserAttributes customUserAttributes = (CustomUserAttributes)customUserAttributesMap.get(customUserAttributesClassName);
            if (customUserAttributes == null) {
                if (portletApp.isWARFile()) {
                    PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
                    Map<String, CustomUserAttributes> portletContextBagCustomUserAttributes = portletContextBag.getCustomUserAttributes();
                    customUserAttributes = portletContextBagCustomUserAttributes.get(customUserAttributesClassName);
                    if (customUserAttributes != null) {
                        customUserAttributes = (CustomUserAttributes)customUserAttributes.clone();
                    }
                } else {
                    customUserAttributes = UserInfoFactory._newInstance(customUserAttributesClassName);
                }
                if (customUserAttributes != null) {
                    customUserAttributesMap.put(customUserAttributesClassName, customUserAttributes);
                }
            }
            if (customUserAttributes == null || (attrValue = customUserAttributes.getValue(userAttributeName = entry.getKey(), unmodifiableUserInfo)) == null) continue;
            userInfo.put(userAttributeName, attrValue);
        }
        return userInfo;
    }

    private static CustomUserAttributes _newInstance(String className) {
        try {
            return (CustomUserAttributes)InstanceFactory.newInstance(className);
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }
}

