/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypeAccessPolicy;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.PortletContainerUtil;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.security.auth.AuthTokenWhitelistUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.TempAttributesServletRequest;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.util.LayoutTypeAccessPolicyTracker;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class SecurityPortletContainerWrapper
implements PortletContainer {
    private static final Log _log = LogFactoryUtil.getLog(SecurityPortletContainerWrapper.class);
    private final PortletContainer _portletContainer;

    public static PortletContainer createSecurityPortletContainerWrapper(PortletContainer portletContainer) {
        if (!SPIUtil.isSPI()) {
            portletContainer = new SecurityPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public SecurityPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    @Override
    public void preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(httpServletRequest, portlet);
    }

    @Override
    public ActionResult processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutHttpServletRequest = this.getOwnerLayoutRequestWrapper(httpServletRequest, portlet);
            this.checkAction(ownerLayoutHttpServletRequest, portlet);
            return this._portletContainer.processAction(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException pe) {
            return this.processActionException(httpServletRequest, httpServletResponse, portlet, pe);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
    }

    @Override
    public List<Event> processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        return this._portletContainer.processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
    }

    @Override
    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout);
    }

    @Override
    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout, portlet);
    }

    @Override
    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            this.checkRender(httpServletRequest, portlet);
            this._portletContainer.render(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            this.processRenderException(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
    }

    @Override
    public void renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            this.checkRender(httpServletRequest, portlet);
            this._portletContainer.renderHeaders(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            this.processRenderException(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
    }

    @Override
    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        try {
            HttpServletRequest ownerLayoutHttpServletRequest = this.getOwnerLayoutRequestWrapper(httpServletRequest, portlet);
            this.checkResource(ownerLayoutHttpServletRequest, portlet);
            this._portletContainer.serveResource(httpServletRequest, httpServletResponse, portlet);
        }
        catch (PrincipalException pe) {
            this.processServeResourceException(httpServletRequest, httpServletResponse, portlet, pe);
        }
        catch (PortletContainerException pce) {
            throw pce;
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
    }

    protected void check(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        if (portlet == null) {
            return;
        }
        if (!this.isValidPortletId(portlet.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn("Invalid portlet ID " + portlet.getPortletId());
            }
            throw new PrincipalException("Invalid portlet ID " + portlet.getPortletId());
        }
        if (portlet.isUndeployedPortlet()) {
            return;
        }
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        LayoutTypeAccessPolicy layoutTypeAccessPolicy = LayoutTypeAccessPolicyTracker.getLayoutTypeAccessPolicy(layout);
        layoutTypeAccessPolicy.checkAccessAllowedToPortlet(httpServletRequest, layout, portlet);
    }

    protected void checkAction(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        this.checkCSRFProtection(httpServletRequest, portlet);
        this.check(httpServletRequest, portlet);
    }

    protected void checkCSRFProtection(HttpServletRequest httpServletRequest, Portlet portlet) throws PortalException {
        Map<String, String> initParams = portlet.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean(initParams.get("check-auth-token"), true);
        if (AuthTokenWhitelistUtil.isPortletCSRFWhitelisted(httpServletRequest, portlet)) {
            checkAuthToken = false;
        }
        if (checkAuthToken) {
            AuthTokenUtil.checkCSRFToken(httpServletRequest, SecurityPortletContainerWrapper.class.getName());
        }
    }

    protected void checkRender(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        this.check(httpServletRequest, portlet);
    }

    protected void checkResource(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        this.check(httpServletRequest, portlet);
    }

    protected String getOriginalURL(HttpServletRequest httpServletRequest) {
        LastPath lastPath = (LastPath)httpServletRequest.getAttribute("LAST_PATH");
        if (lastPath == null) {
            return String.valueOf(httpServletRequest.getRequestURI());
        }
        String portalURL = PortalUtil.getPortalURL(httpServletRequest);
        return portalURL.concat(lastPath.getContextPath()).concat(lastPath.getPath());
    }

    protected HttpServletRequest getOwnerLayoutRequestWrapper(HttpServletRequest httpServletRequest, Portlet portlet) throws Exception {
        if (!PropsValues.PORTLET_EVENT_DISTRIBUTION_LAYOUT_SET || PropsValues.PORTLET_CROSS_LAYOUT_INVOCATION_MODE.equals("render")) {
            return httpServletRequest;
        }
        Layout ownerLayout = null;
        LayoutTypePortlet ownerLayoutTypePortlet = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout requestLayout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        List<LayoutTypePortlet> layoutTypePortlets = PortletContainerUtil.getLayoutTypePortlets(requestLayout);
        for (LayoutTypePortlet layoutTypePortlet : layoutTypePortlets) {
            if (!layoutTypePortlet.hasPortletId(portlet.getPortletId())) continue;
            ownerLayoutTypePortlet = layoutTypePortlet;
            ownerLayout = layoutTypePortlet.getLayout();
            break;
        }
        if (ownerLayout == null) {
            return httpServletRequest;
        }
        Layout currentLayout = themeDisplay.getLayout();
        if (currentLayout.equals(ownerLayout)) {
            return httpServletRequest;
        }
        ThemeDisplay themeDisplayClone = (ThemeDisplay)themeDisplay.clone();
        themeDisplayClone.setLayout(ownerLayout);
        themeDisplayClone.setLayoutTypePortlet(ownerLayoutTypePortlet);
        TempAttributesServletRequest tempAttributesServletRequest = new TempAttributesServletRequest(httpServletRequest);
        tempAttributesServletRequest.setTempAttribute("LAYOUT", ownerLayout);
        tempAttributesServletRequest.setTempAttribute("LIFERAY_SHARED_THEME_DISPLAY", themeDisplayClone);
        return tempAttributesServletRequest;
    }

    protected boolean isValidPortletId(String portletId) {
        for (int i = 0; i < portletId.length(); ++i) {
            char c = portletId.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$' || c == '#' || c == '_') continue;
            return false;
        }
        return true;
    }

    protected ActionResult processActionException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, PrincipalException pe) {
        if (_log.isDebugEnabled()) {
            _log.debug(pe, pe);
        }
        if (_log.isWarnEnabled()) {
            String url = this.getOriginalURL(httpServletRequest);
            _log.warn(String.format("User %s is not allowed to access URL %s and portlet %s", PortalUtil.getUserId(httpServletRequest), url, portlet.getPortletId()));
        }
        return ActionResult.EMPTY_ACTION_RESULT;
    }

    protected void processRenderException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        String portletContent = null;
        if (portlet.isShowPortletAccessDenied()) {
            portletContent = "/html/portal/portlet_access_denied.jsp";
        }
        try {
            if (portletContent != null) {
                HttpServletRequest originalHttpServletRequest = PortalUtil.getOriginalServletRequest(httpServletRequest);
                RequestDispatcher requestDispatcher = originalHttpServletRequest.getRequestDispatcher(portletContent);
                requestDispatcher.include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
    }

    protected void processServeResourceException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, PrincipalException pe) {
        if (_log.isDebugEnabled()) {
            _log.debug(pe, pe);
        }
        httpServletResponse.setHeader("Cache-Control", "private, no-cache, no-store, must-revalidate");
        httpServletResponse.setStatus(400);
        if (_log.isWarnEnabled()) {
            String url = this.getOriginalURL(httpServletRequest);
            _log.warn(String.format("User %s is not allowed to serve resource for %s on %s", PortalUtil.getUserId(httpServletRequest), url, portlet.getPortletId()));
        }
    }
}

