/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.ActionResult;
import com.liferay.portal.kernel.portlet.PortletContainer;
import com.liferay.portal.kernel.portlet.PortletContainerException;
import com.liferay.portal.kernel.portlet.RestrictPortletServletRequest;
import com.liferay.portal.util.PropsValues;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class RestrictPortletContainerWrapper
implements PortletContainer {
    private final PortletContainer _portletContainer;

    public static PortletContainer createRestrictPortletContainerWrapper(PortletContainer portletContainer) {
        if (PropsValues.PORTLET_CONTAINER_RESTRICT) {
            portletContainer = new RestrictPortletContainerWrapper(portletContainer);
        }
        return portletContainer;
    }

    public RestrictPortletContainerWrapper(PortletContainer portletContainer) {
        this._portletContainer = portletContainer;
    }

    @Override
    public void preparePortlet(HttpServletRequest httpServletRequest, Portlet portlet) throws PortletContainerException {
        this._portletContainer.preparePortlet(httpServletRequest, portlet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActionResult processAction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(httpServletRequest);
        try {
            ActionResult actionResult = this._portletContainer.processAction(httpServletRequest, httpServletResponse, portlet);
            return actionResult;
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Event> processEvent(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet, Layout layout, Event event) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(httpServletRequest);
        try {
            List<Event> list = this._portletContainer.processEvent(httpServletRequest, httpServletResponse, portlet, layout, event);
            return list;
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    @Override
    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout);
    }

    @Override
    public void processPublicRenderParameters(HttpServletRequest httpServletRequest, Layout layout, Portlet portlet) {
        this._portletContainer.processPublicRenderParameters(httpServletRequest, layout, portlet);
    }

    @Override
    public void render(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._render(httpServletRequest, () -> this._portletContainer.render(httpServletRequest, httpServletResponse, portlet));
    }

    @Override
    public void renderHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        this._render(httpServletRequest, () -> this._portletContainer.renderHeaders(httpServletRequest, httpServletResponse, portlet));
    }

    @Override
    public void serveResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Portlet portlet) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = new RestrictPortletServletRequest(httpServletRequest);
        try {
            this._portletContainer.serveResource(httpServletRequest, httpServletResponse, portlet);
        }
        catch (Exception e) {
            throw new PortletContainerException(e);
        }
        finally {
            restrictPortletServletRequest.mergeSharedAttributes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _render(HttpServletRequest httpServletRequest, Renderable renderable) throws PortletContainerException {
        RestrictPortletServletRequest restrictPortletServletRequest = null;
        if (httpServletRequest instanceof RestrictPortletServletRequest) {
            restrictPortletServletRequest = (RestrictPortletServletRequest)httpServletRequest;
            Map<String, Object> attributes = restrictPortletServletRequest.getAttributes();
            if (attributes.containsKey("RENDER_PORTLET")) {
                restrictPortletServletRequest = new RestrictPortletServletRequest(httpServletRequest);
            }
        } else {
            restrictPortletServletRequest = new RestrictPortletServletRequest(httpServletRequest);
        }
        try {
            renderable.render();
        }
        finally {
            restrictPortletServletRequest.removeAttribute("RENDER_PATH");
            restrictPortletServletRequest.removeAttribute("RENDER_PORTLET_COLUMN_COUNT");
            restrictPortletServletRequest.removeAttribute("RENDER_PORTLET_COLUMN_ID");
            restrictPortletServletRequest.removeAttribute("RENDER_PORTLET_COLUMN_POS");
            Object lock = httpServletRequest.getAttribute("PARALLEL_RENDERING_MERGE_LOCK");
            if (lock == null) {
                restrictPortletServletRequest.mergeSharedAttributes();
            }
        }
    }

    @FunctionalInterface
    private static interface Renderable {
        public void render() throws PortletContainerException;
    }
}

