/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.servlet.PortalSessionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RenderParametersPool {
    public static Map<String, Map<String, String[]>> clear(HttpServletRequest httpServletRequest, long plid) {
        if (plid <= 0L) {
            return null;
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(httpServletRequest, false);
        if (pool == null) {
            return null;
        }
        return pool.remove(plid);
    }

    public static Map<String, String[]> clear(HttpServletRequest httpServletRequest, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(httpServletRequest, plid);
        if (plidPool == null) {
            return null;
        }
        return plidPool.remove(portletId);
    }

    public static Map<String, Map<String, String[]>> get(HttpServletRequest httpServletRequest, long plid) {
        if (plid <= 0L) {
            return null;
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(httpServletRequest, false);
        if (pool == null) {
            return null;
        }
        return pool.get(plid);
    }

    public static Map<String, String[]> get(HttpServletRequest httpServletRequest, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.get(httpServletRequest, plid);
        if (plidPool == null) {
            return null;
        }
        return plidPool.get(portletId);
    }

    public static Map<String, Map<String, String[]>> getOrCreate(HttpServletRequest httpServletRequest, long plid) {
        if (plid <= 0L) {
            return new ConcurrentHashMap<String, Map<String, String[]>>();
        }
        Map<Long, Map<String, Map<String, String[]>>> pool = RenderParametersPool._getRenderParametersPool(httpServletRequest, true);
        return pool.computeIfAbsent(plid, key -> new ConcurrentHashMap());
    }

    public static Map<String, String[]> getOrCreate(HttpServletRequest httpServletRequest, long plid, String portletId) {
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.getOrCreate(httpServletRequest, plid);
        return plidPool.computeIfAbsent(portletId, key -> new HashMap());
    }

    public static void put(HttpServletRequest httpServletRequest, long plid, String portletId, Map<String, String[]> params) {
        if (params.isEmpty()) {
            return;
        }
        Map<String, Map<String, String[]>> plidPool = RenderParametersPool.getOrCreate(httpServletRequest, plid);
        plidPool.put(portletId, params);
    }

    private static Map<Long, Map<String, Map<String, String[]>>> _getRenderParametersPool(HttpServletRequest httpServletRequest, boolean createIfAbsent) {
        HttpSession session = httpServletRequest.getSession();
        HttpSession portalSession = PortalSessionContext.get(session.getId());
        if (portalSession != null) {
            session = portalSession;
        }
        ConcurrentHashMap renderParametersPool = (ConcurrentHashMap)session.getAttribute("PORTLET_RENDER_PARAMETERS_");
        if (createIfAbsent && renderParametersPool == null) {
            renderParametersPool = new ConcurrentHashMap();
            session.setAttribute("PORTLET_RENDER_PARAMETERS_", renderParametersPool);
        }
        return renderParametersPool;
    }
}

