/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletException;
import javax.portlet.PortletURLGenerationListener;
import javax.portlet.UnavailableException;
import javax.servlet.ServletContext;

public class PortletURLListenerFactory {
    private static final PortletURLListenerFactory _instance = new PortletURLListenerFactory();
    private final Map<String, Map<String, PortletURLGenerationListener>> _pool = new ConcurrentHashMap<String, Map<String, PortletURLGenerationListener>>();

    public static PortletURLGenerationListener create(PortletURLListener portletURLListener) throws PortletException {
        return _instance._create(portletURLListener);
    }

    public static void destroy(PortletURLListener portletURLListener) {
        _instance._destroy(portletURLListener);
    }

    private PortletURLListenerFactory() {
    }

    private PortletURLGenerationListener _create(PortletURLListener portletURLListener) throws PortletException {
        PortletURLGenerationListener portletURLGenerationListener;
        PortletApp portletApp = portletURLListener.getPortletApp();
        Map<String, PortletURLGenerationListener> portletURLGenerationListeners = this._pool.get(portletApp.getServletContextName());
        if (portletURLGenerationListeners == null) {
            portletURLGenerationListeners = new ConcurrentHashMap<String, PortletURLGenerationListener>();
            this._pool.put(portletApp.getServletContextName(), portletURLGenerationListeners);
        }
        if ((portletURLGenerationListener = portletURLGenerationListeners.get(portletURLListener.getListenerClass())) != null) {
            return portletURLGenerationListener;
        }
        if (portletApp.isWARFile()) {
            ServletContext servletContext = portletApp.getServletContext();
            PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
            Map<String, PortletURLGenerationListener> portletURLListenersMap = portletContextBag.getPortletURLListeners();
            portletURLGenerationListener = portletURLListenersMap.get(portletURLListener.getListenerClass());
            portletURLGenerationListener = this._init(servletContext.getClassLoader(), portletURLListener, portletURLGenerationListener);
        } else {
            portletURLGenerationListener = this._init(portletURLListener);
        }
        portletURLGenerationListeners.put(portletURLListener.getListenerClass(), portletURLGenerationListener);
        return portletURLGenerationListener;
    }

    private void _destroy(PortletURLListener portletURLListener) {
        PortletApp portletApp = portletURLListener.getPortletApp();
        Map<String, PortletURLGenerationListener> portletURLGenerationListeners = this._pool.get(portletApp.getServletContextName());
        if (portletURLGenerationListeners == null) {
            return;
        }
        PortletURLGenerationListener portletURLGenerationListener = portletURLGenerationListeners.get(portletURLListener.getListenerClass());
        if (portletURLGenerationListener == null) {
            return;
        }
        portletURLGenerationListeners.remove(portletURLListener.getListenerClass());
    }

    private PortletURLGenerationListener _init(ClassLoader classLoader, PortletURLListener portletURLListener, PortletURLGenerationListener portletURLGenerationListener) throws PortletException {
        try {
            if (portletURLGenerationListener == null) {
                portletURLGenerationListener = (PortletURLGenerationListener)InstanceFactory.newInstance(classLoader, portletURLListener.getListenerClass());
            }
        }
        catch (Exception e) {
            throw new UnavailableException(e.getMessage());
        }
        return portletURLGenerationListener;
    }

    private PortletURLGenerationListener _init(PortletURLListener portletURLListener) throws PortletException {
        return this._init(null, portletURLListener, null);
    }
}

