/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.util.MappingEnumeration;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;

public class PortletSessionAttributeMap
extends AbstractMap<String, Object> {
    protected final String scopePrefix;
    protected final HttpSession session;

    public PortletSessionAttributeMap(HttpSession session) {
        this(session, null);
    }

    public PortletSessionAttributeMap(HttpSession session, String scopePrefix) {
        this.session = session;
        this.scopePrefix = scopePrefix;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        key = this.encodeKey(String.valueOf(key));
        Enumeration<String> enumeration = this.getAttributeNames(false);
        while (enumeration.hasMoreElements()) {
            String attributeName = enumeration.nextElement();
            if (!attributeName.equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Enumeration<String> enumeration = this.getAttributeNames(false);
        while (enumeration.hasMoreElements()) {
            Object attributeValue = this.session.getAttribute(enumeration.nextElement());
            if (!attributeValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration<String> enumeration = this.getAttributeNames(true);
        while (enumeration.hasMoreElements()) {
            String attributeName = enumeration.nextElement();
            map.put(attributeName, this.get(attributeName));
        }
        return Collections.unmodifiableSet(map.entrySet());
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        return this.session.getAttribute(this.encodeKey(String.valueOf(key)));
    }

    @Override
    public boolean isEmpty() {
        Enumeration<String> enumeration = this.getAttributeNames(false);
        return !enumeration.hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(SetUtil.fromEnumeration(this.getAttributeNames(true)));
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        int size = 0;
        Enumeration<String> enumeration = this.getAttributeNames(false);
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++size;
        }
        return size;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> attributeValues = new ArrayList<Object>();
        Enumeration<String> enumeration = this.getAttributeNames(false);
        while (enumeration.hasMoreElements()) {
            attributeValues.add(this.session.getAttribute(enumeration.nextElement()));
        }
        return attributeValues;
    }

    protected String encodeKey(String key) {
        if (this.scopePrefix == null) {
            return key;
        }
        return this.scopePrefix.concat(key);
    }

    protected Enumeration<String> getAttributeNames(boolean removePrefix) {
        Enumeration enumeration = this.session.getAttributeNames();
        if (this.scopePrefix == null) {
            return enumeration;
        }
        return new MappingEnumeration<String, String>(enumeration, new AttributeNameMapper(this.scopePrefix, removePrefix));
    }

    protected static class AttributeNameMapper
    implements MappingEnumeration.Mapper<String, String> {
        private final String _attributeNamespace;
        private final boolean _removePrefix;

        @Override
        public String map(String attributeName) {
            if (attributeName.startsWith(this._attributeNamespace)) {
                if (this._removePrefix) {
                    return attributeName.substring(this._attributeNamespace.length());
                }
                return attributeName;
            }
            return null;
        }

        protected AttributeNameMapper(String attributeNamespace, boolean removePrefix) {
            this._attributeNamespace = attributeNamespace;
            this._removePrefix = removePrefix;
        }
    }
}

