/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.PortletResourceAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class PortletResourceStaticURLGenerator {
    private HttpServletRequest _httpServletRequest;
    private ThemeDisplay _themeDisplay;
    private Set<String> _visitedURLs;

    public List<String> generate(Portlet portlet, PortletResourceAccessor ... portletResourceAccessors) {
        ArrayList<String> urls = new ArrayList<String>();
        for (PortletResourceAccessor portletResourceAccessor : portletResourceAccessors) {
            String contextPath = null;
            contextPath = portletResourceAccessor.isPortalResource() ? PortalUtil.getPathContext() : PortalUtil.getPathProxy() + portlet.getContextPath();
            List portletResources = (List)portletResourceAccessor.get(portlet);
            for (String portletResource : portletResources) {
                if (!HttpUtil.hasProtocol(portletResource)) {
                    Portlet rootPortlet = portlet.getRootPortlet();
                    portletResource = PortalUtil.getStaticResourceURL(this._httpServletRequest, contextPath + portletResource, rootPortlet.getTimestamp());
                }
                if (!portletResource.contains("://")) {
                    String cdnBaseURL = this._themeDisplay.getCDNBaseURL();
                    portletResource = cdnBaseURL.concat(portletResource);
                }
                if (this._visitedURLs.contains(portletResource)) continue;
                urls.add(portletResource);
                this._visitedURLs.add(portletResource);
            }
        }
        return urls;
    }

    public void setRequest(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public void setVisitedURLs(Set<String> visitedURLs) {
        this._visitedURLs = visitedURLs;
    }
}

