/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.cache.key.CacheKeyGenerator;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferences;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactory;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.PortalPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletPreferencesLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.StAXReaderUtil;
import com.liferay.portlet.PortalPreferencesImpl;
import com.liferay.portlet.PortalPreferencesWrapper;
import com.liferay.portlet.PortalPreferencesWrapperCacheUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.Preference;
import com.liferay.portlet.StrictPortletPreferencesImpl;
import com.liferay.portlet.portletconfiguration.util.ConfigurationPortletRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class PortletPreferencesFactoryImpl
implements PortletPreferencesFactory {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesFactoryImpl.class);
    private Map<String, Preference> _defaultPreferencesMap;
    private final PortalCache<String, Map<String, Preference>> _preferencesMapPortalCache = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", PortletPreferencesFactoryImpl.class.getName());

    public static Map<String, Preference> createPreferencesMap(String xml) {
        XMLEventReader xmlEventReader = null;
        HashMap<String, Preference> preferencesMap = new HashMap<String, Preference>();
        try {
            XMLInputFactory xmlInputFactory = StAXReaderUtil.getXMLInputFactory();
            xmlEventReader = xmlInputFactory.createXMLEventReader(new UnsyncStringReader(xml));
            while (xmlEventReader.hasNext()) {
                StartElement startElement;
                QName startElementName;
                String elementName;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement() || !(elementName = (startElementName = (startElement = xmlEvent.asStartElement()).getName()).getLocalPart()).equals("preference")) continue;
                Preference preference = PortletPreferencesFactoryImpl.readPreference(xmlEventReader);
                preferencesMap.put(preference.getName(), preference);
            }
        }
        catch (XMLStreamException xmlse) {
            throw new SystemException(xmlse);
        }
        finally {
            block12: {
                if (xmlEventReader != null) {
                    try {
                        xmlEventReader.close();
                    }
                    catch (XMLStreamException xmlse) {
                        if (!_log.isDebugEnabled()) break block12;
                        _log.debug(xmlse, xmlse);
                    }
                }
            }
        }
        return preferencesMap;
    }

    @Override
    public void checkControlPanelPortletPreferences(ThemeDisplay themeDisplay, Portlet portlet) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        Group group = layout.getGroup();
        if (!group.isControlPanel()) {
            return;
        }
        String portletId = portlet.getPortletId();
        boolean hasControlPanelAccessPermission = PortletPermissionUtil.hasControlPanelAccessPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletId);
        if (!hasControlPanelAccessPermission) {
            return;
        }
        javax.portlet.PortletPreferences portletSetup = this.getStrictLayoutPortletSetup(layout, portletId);
        if (portletSetup instanceof StrictPortletPreferencesImpl) {
            this.getLayoutPortletSetup(layout, portletId);
        }
        if (portlet.isInstanceable()) {
            return;
        }
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(themeDisplay.getScopeGroupId(), themeDisplay.getUserId(), layout, portletId, false);
        PortletPreferencesLocalServiceUtil.getPreferences(portletPreferencesIds);
    }

    @Override
    public javax.portlet.PortletPreferences fromDefaultXML(String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortletPreferencesImpl(xml, preferencesMap);
    }

    @Override
    public PortalPreferencesImpl fromXML(long ownerId, int ownerType, String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortalPreferencesImpl(ownerId, ownerType, xml, preferencesMap, false);
    }

    @Override
    public PortletPreferencesImpl fromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new PortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, xml, preferencesMap);
    }

    @Override
    public javax.portlet.PortletPreferences getExistingPortletSetup(Layout layout, String portletId) throws PortalException {
        if (Validator.isNull(portletId)) {
            return null;
        }
        javax.portlet.PortletPreferences portletPreferences = this.getStrictPortletSetup(layout, portletId);
        if (portletPreferences instanceof StrictPortletPreferencesImpl) {
            throw new PrincipalException();
        }
        return portletPreferences;
    }

    @Override
    public javax.portlet.PortletPreferences getExistingPortletSetup(PortletRequest portletRequest) throws PortalException {
        String portletResource = ParamUtil.getString(portletRequest, "portletResource");
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getExistingPortletSetup(themeDisplay.getLayout(), portletResource);
    }

    @Override
    public javax.portlet.PortletPreferences getLayoutPortletSetup(Layout layout, String portletId) {
        return this.getLayoutPortletSetup(layout, portletId, null);
    }

    @Override
    public javax.portlet.PortletPreferences getLayoutPortletSetup(Layout layout, String portletId, String defaultPreferences) {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletIdCodec.hasUserId(portletId)) {
            ownerId = PortletIdCodec.decodeUserId(portletId);
            ownerType = 4;
        }
        return this.getLayoutPortletSetup(layout.getCompanyId(), ownerId, ownerType, layout.getPlid(), portletId, defaultPreferences);
    }

    @Override
    public javax.portlet.PortletPreferences getLayoutPortletSetup(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        return PortletPreferencesLocalServiceUtil.getPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences);
    }

    @Override
    public PortalPreferences getPortalPreferences(HttpServletRequest httpServletRequest) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getPortalPreferences(httpServletRequest.getSession(), themeDisplay.getUserId(), themeDisplay.isSignedIn());
    }

    @Override
    public PortalPreferences getPortalPreferences(HttpSession session, long userId, boolean signedIn) {
        long ownerId = userId;
        int ownerType = 4;
        PortalPreferences portalPreferences = null;
        if (signedIn) {
            PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
            if (portalPreferencesWrapper == null) {
                portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences(ownerId, ownerType);
                portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
            } else {
                PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
                portalPreferences = portalPreferencesImpl.clone();
            }
        } else {
            if (session != null) {
                portalPreferences = (PortalPreferences)session.getAttribute("PORTAL_PREFERENCES");
            }
            if (portalPreferences == null) {
                PortalPreferencesWrapper portalPreferencesWrapper = PortalPreferencesWrapperCacheUtil.get(ownerId, ownerType);
                if (portalPreferencesWrapper == null) {
                    portalPreferencesWrapper = (PortalPreferencesWrapper)PortalPreferencesLocalServiceUtil.getPreferences(ownerId, ownerType);
                    portalPreferences = portalPreferencesWrapper.getPortalPreferencesImpl();
                } else {
                    PortalPreferencesImpl portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
                    portalPreferences = portalPreferencesImpl.clone();
                }
                if (session != null) {
                    session.setAttribute("PORTAL_PREFERENCES", (Object)portalPreferences);
                }
            }
        }
        portalPreferences.setSignedIn(signedIn);
        portalPreferences.setUserId(userId);
        return portalPreferences;
    }

    @Override
    public PortalPreferences getPortalPreferences(long userId, boolean signedIn) {
        return this.getPortalPreferences(null, userId, signedIn);
    }

    @Override
    public PortalPreferences getPortalPreferences(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        return this.getPortalPreferences(httpServletRequest);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletPreferences(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        PortletPreferencesIds portletPreferencesIds = this.getPortletPreferencesIds(httpServletRequest, portletId);
        return PortletPreferencesLocalServiceUtil.getPreferences(portletPreferencesIds);
    }

    @Override
    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest httpServletRequest, Layout layout, String portletId) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long siteGroupId = themeDisplay.getSiteGroupId();
        LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
        boolean modeEditGuest = false;
        String portletMode = ParamUtil.getString(httpServletRequest, "p_p_mode");
        if (portletMode.equals(LiferayPortletMode.EDIT_GUEST.toString()) || layoutTypePortlet != null && layoutTypePortlet.hasModeEditGuestPortletId(portletId)) {
            modeEditGuest = true;
        }
        return this._getPortletPreferencesIds(themeDisplay, siteGroupId, PortalUtil.getUserId(httpServletRequest), layout, portletId, modeEditGuest);
    }

    @Override
    public PortletPreferencesIds getPortletPreferencesIds(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        return this.getPortletPreferencesIds(httpServletRequest, layout, portletId);
    }

    @Override
    public PortletPreferencesIds getPortletPreferencesIds(long siteGroupId, long userId, Layout layout, String portletId, boolean modeEditGuest) throws PortalException {
        return this._getPortletPreferencesIds(null, siteGroupId, userId, layout, portletId, modeEditGuest);
    }

    @Override
    public PortletPreferencesIds getPortletPreferencesIds(long companyId, long siteGroupId, long plid, String portletId, String settingsScope) {
        int ownerType = 0;
        long ownerId = 0L;
        if (settingsScope.equals("company")) {
            ownerId = companyId;
            ownerType = 1;
            plid = 0L;
        } else if (settingsScope.equals("group")) {
            ownerId = siteGroupId;
            ownerType = 2;
            plid = 0L;
        } else if (settingsScope.equals("portletInstance")) {
            ownerId = 0L;
            ownerType = 3;
            if (PortletIdCodec.hasUserId(portletId)) {
                ownerId = PortletIdCodec.decodeUserId(portletId);
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(companyId, ownerId, ownerType, plid, portletId);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletSetup(HttpServletRequest httpServletRequest, String portletId) {
        return this.getPortletSetup(httpServletRequest, portletId, null);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletSetup(HttpServletRequest httpServletRequest, String portletId, String defaultPreferences) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        if (portletRequest instanceof ConfigurationPortletRequest) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return portletRequestWrapper.getPreferences();
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getPortletSetup(themeDisplay.getSiteGroupId(), themeDisplay.getLayout(), portletId, defaultPreferences);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletSetup(Layout layout, String portletId, String defaultPreferences) {
        return this.getPortletSetup(0L, layout, portletId, defaultPreferences);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletSetup(long siteGroupId, Layout layout, String portletId, String defaultPreferences) {
        return this.getPortletSetup(layout.getCompanyId(), siteGroupId, layout.getGroupId(), layout.getPlid(), portletId, defaultPreferences, false);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletSetup(PortletRequest portletRequest) {
        String portletId = PortalUtil.getPortletId(portletRequest);
        return this.getPortletSetup(portletRequest, portletId);
    }

    @Override
    public javax.portlet.PortletPreferences getPortletSetup(PortletRequest portletRequest, String portletId) {
        if (portletRequest instanceof ConfigurationPortletRequest) {
            PortletRequestWrapper portletRequestWrapper = (PortletRequestWrapper)portletRequest;
            return portletRequestWrapper.getPreferences();
        }
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest(portletRequest);
        return this.getPortletSetup(httpServletRequest, portletId);
    }

    @Override
    public Map<Long, javax.portlet.PortletPreferences> getPortletSetupMap(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) {
        HashMap<Long, javax.portlet.PortletPreferences> portletSetupMap = new HashMap<Long, javax.portlet.PortletPreferences>();
        List<PortletPreferences> portletPreferencesList = PortletPreferencesLocalServiceUtil.getPortletPreferences(companyId, groupId, ownerId, ownerType, portletId, privateLayout);
        for (PortletPreferences portletPreferences : portletPreferencesList) {
            javax.portlet.PortletPreferences portletSetup = PortletPreferencesLocalServiceUtil.getPreferences(companyId, ownerId, ownerType, portletPreferences.getPlid(), portletId);
            portletSetupMap.put(portletPreferences.getPlid(), portletSetup);
        }
        return portletSetupMap;
    }

    @Override
    public javax.portlet.PortletPreferences getPreferences(HttpServletRequest httpServletRequest) {
        PortletRequest portletRequest = (PortletRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (portletRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    @Override
    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        return PortalUtil.getPreferencesValidator(portlet);
    }

    @Override
    public javax.portlet.PortletPreferences getStrictLayoutPortletSetup(Layout layout, String portletId) {
        long ownerId = 0L;
        int ownerType = 3;
        if (PortletIdCodec.hasUserId(portletId)) {
            ownerId = PortletIdCodec.decodeUserId(portletId);
            ownerType = 4;
        }
        return PortletPreferencesLocalServiceUtil.getStrictPreferences(layout.getCompanyId(), ownerId, ownerType, layout.getPlid(), portletId);
    }

    @Override
    public javax.portlet.PortletPreferences getStrictPortletSetup(Layout layout, String portletId) {
        return this.getPortletSetup(layout.getCompanyId(), 0L, layout.getGroupId(), layout.getPlid(), portletId, "", true);
    }

    @Override
    public javax.portlet.PortletPreferences getStrictPortletSetup(long companyId, long groupId, String portletId) {
        return this.getPortletSetup(companyId, 0L, groupId, 0L, portletId, "", true);
    }

    @Override
    public StrictPortletPreferencesImpl strictFromXML(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) {
        Map<String, Preference> preferencesMap = this.toPreferencesMap(xml);
        return new StrictPortletPreferencesImpl(companyId, ownerId, ownerType, plid, portletId, xml, preferencesMap);
    }

    @Override
    public String toXML(PortalPreferences portalPreferences) {
        PortalPreferencesImpl portalPreferencesImpl = null;
        if (portalPreferences instanceof PortalPreferencesWrapper) {
            PortalPreferencesWrapper portalPreferencesWrapper = (PortalPreferencesWrapper)((Object)portalPreferences);
            portalPreferencesImpl = portalPreferencesWrapper.getPortalPreferencesImpl();
        } else {
            portalPreferencesImpl = (PortalPreferencesImpl)portalPreferences;
        }
        return portalPreferencesImpl.toXML();
    }

    @Override
    public String toXML(javax.portlet.PortletPreferences portletPreferences) {
        PortletPreferencesImpl portletPreferencesImpl = null;
        if (portletPreferences instanceof PortletPreferencesWrapper) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletPreferences;
            portletPreferencesImpl = portletPreferencesWrapper.getPortletPreferencesImpl();
        } else {
            portletPreferencesImpl = (PortletPreferencesImpl)portletPreferences;
        }
        return portletPreferencesImpl.toXML();
    }

    protected static Preference readPreference(XMLEventReader xmlEventReader) throws XMLStreamException {
        String name = null;
        ArrayList<String> values = new ArrayList<String>();
        boolean readOnly = false;
        while (xmlEventReader.hasNext()) {
            EndElement endElement;
            QName endElementName;
            String elementName;
            XMLEvent xmlEvent = xmlEventReader.nextEvent();
            if (xmlEvent.isStartElement()) {
                String value;
                StartElement startElement = xmlEvent.asStartElement();
                QName startElementName = startElement.getName();
                elementName = startElementName.getLocalPart();
                if (elementName.equals("name")) {
                    name = StAXReaderUtil.read(xmlEventReader);
                    continue;
                }
                if (elementName.equals("value")) {
                    value = StAXReaderUtil.read(xmlEventReader);
                    values.add(value);
                    continue;
                }
                if (!elementName.equals("read-only")) continue;
                value = StAXReaderUtil.read(xmlEventReader);
                readOnly = GetterUtil.getBoolean(value);
                continue;
            }
            if (!xmlEvent.isEndElement() || !(elementName = (endElementName = (endElement = xmlEvent.asEndElement()).getName()).getLocalPart()).equals("preference")) continue;
            break;
        }
        return new Preference(name, values.toArray(new String[0]), readOnly);
    }

    protected javax.portlet.PortletPreferences getPortletSetup(long companyId, long siteGroupId, long layoutGroupId, long plid, String portletId, String defaultPreferences, boolean strictMode) {
        String originalPortletId = portletId;
        Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
        boolean uniquePerLayout = false;
        boolean uniquePerGroup = false;
        if (portlet.isPreferencesCompanyWide()) {
            portletId = PortletIdCodec.decodePortletName(portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            uniquePerLayout = true;
            if (portlet.isPreferencesOwnedByGroup()) {
                uniquePerGroup = true;
            }
        } else if (portlet.isPreferencesOwnedByGroup()) {
            uniquePerGroup = true;
            portletId = PortletIdCodec.decodePortletName(portletId);
        }
        long ownerId = 0L;
        int ownerType = 3;
        Group group = GroupLocalServiceUtil.fetchGroup(siteGroupId);
        if (group != null && group.isLayout()) {
            plid = group.getClassPK();
        }
        if (PortletIdCodec.hasUserId(originalPortletId)) {
            ownerId = PortletIdCodec.decodeUserId(originalPortletId);
            ownerType = 4;
        } else if (!uniquePerLayout) {
            plid = 0L;
            if (uniquePerGroup) {
                ownerId = siteGroupId > 0L ? siteGroupId : layoutGroupId;
                ownerType = 2;
            } else {
                ownerId = companyId;
                ownerType = 1;
            }
        }
        if (strictMode) {
            return PortletPreferencesLocalServiceUtil.getStrictPreferences(companyId, ownerId, ownerType, plid, portletId);
        }
        return PortletPreferencesLocalServiceUtil.getPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences);
    }

    protected Map<String, Preference> toPreferencesMap(String xml) {
        if (Objects.equals(xml, "<portlet-preferences />")) {
            if (this._defaultPreferencesMap == null) {
                this._defaultPreferencesMap = PortletPreferencesFactoryImpl.createPreferencesMap("<portlet-preferences />");
            }
            return this._defaultPreferencesMap;
        }
        if (Validator.isNull(xml)) {
            return Collections.emptyMap();
        }
        String cacheKey = this._encodeCacheKey(xml);
        Map<String, Preference> preferencesMap = this._preferencesMapPortalCache.get(cacheKey);
        if (preferencesMap != null) {
            return preferencesMap;
        }
        preferencesMap = PortletPreferencesFactoryImpl.createPreferencesMap(xml);
        this._preferencesMapPortalCache.put(cacheKey, preferencesMap);
        return preferencesMap;
    }

    private String _encodeCacheKey(String xml) {
        if (xml.length() <= PropsValues.PORTLET_PREFERENCES_CACHE_KEY_THRESHOLD_SIZE) {
            return xml;
        }
        CacheKeyGenerator cacheKeyGenerator = CacheKeyGeneratorUtil.getCacheKeyGenerator(PortletPreferencesFactoryImpl.class.getName());
        if (_log.isDebugEnabled()) {
            _log.debug("Cache key generator " + cacheKeyGenerator.getClass());
        }
        return String.valueOf(cacheKeyGenerator.getCacheKey(xml));
    }

    private PortletPreferencesIds _getPortletPreferencesIds(ThemeDisplay themeDisplay, long siteGroupId, long userId, Layout layout, String portletId, boolean modeEditGuest) throws PortalException {
        String originalPortletId = portletId;
        Portlet portlet = PortletLocalServiceUtil.getPortletById(layout.getCompanyId(), portletId);
        long ownerId = 0L;
        int ownerType = 0;
        long plid = 0L;
        if (modeEditGuest) {
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            boolean hasUpdateLayoutPermission = LayoutPermissionUtil.contains(permissionChecker, layout, "UPDATE");
            if (layout.isPrivateLayout() || !hasUpdateLayoutPermission) {
                throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getLayoutId(), "UPDATE");
            }
        }
        if (PortletIdCodec.hasUserId(originalPortletId) && PortletIdCodec.decodeUserId(originalPortletId) == userId) {
            ownerId = userId;
            ownerType = 4;
            plid = layout.getPlid();
        } else if (portlet.isPreferencesCompanyWide()) {
            ownerId = layout.getCompanyId();
            ownerType = 1;
            plid = 0L;
            portletId = PortletIdCodec.decodePortletName(portletId);
        } else if (portlet.isPreferencesUniquePerLayout()) {
            ownerId = 0L;
            ownerType = 3;
            plid = layout.getPlid();
            if (themeDisplay != null) {
                if (themeDisplay.isPortletEmbedded(layout.getGroupId(), layout, portletId)) {
                    ownerId = layout.getGroupId();
                    plid = 0L;
                }
            } else if (layout.isPortletEmbedded(portletId, layout.getGroupId())) {
                ownerId = layout.getGroupId();
                plid = 0L;
            }
            if (!portlet.isPreferencesOwnedByGroup()) {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId(layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        } else {
            plid = 0L;
            if (portlet.isPreferencesOwnedByGroup()) {
                ownerId = siteGroupId;
                ownerType = 2;
                portletId = PortletIdCodec.decodePortletName(portletId);
            } else {
                if (userId <= 0L || modeEditGuest) {
                    userId = UserLocalServiceUtil.getDefaultUserId(layout.getCompanyId());
                }
                ownerId = userId;
                ownerType = 4;
            }
        }
        return new PortletPreferencesIds(layout.getCompanyId(), ownerId, ownerType, plid, portletId);
    }
}

