/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.expando.kernel.model.CustomAttributesDisplay;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.notifications.UserNotificationDefinition;
import com.liferay.portal.kernel.notifications.UserNotificationDeliveryType;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.poller.PollerProcessor;
import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.ControlPanelEntry;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperTracker;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletLayoutListener;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListener;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerEventMessageListenerWrapper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.OpenSearch;
import com.liferay.portal.kernel.security.permission.propagator.PermissionPropagator;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.servlet.URLEncoder;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.kernel.xmlrpc.Method;
import com.liferay.portal.notifications.UserNotificationHandlerImpl;
import com.liferay.portal.util.JavaFieldsParser;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.internal.FriendlyURLMapperTrackerImpl;
import com.liferay.portlet.internal.PortletBagImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.social.kernel.model.SocialActivityInterpreter;
import com.liferay.social.kernel.model.SocialRequestInterpreter;
import com.liferay.social.kernel.model.impl.SocialActivityInterpreterImpl;
import com.liferay.social.kernel.model.impl.SocialRequestInterpreterImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.Portlet;
import javax.portlet.PreferencesValidator;
import javax.servlet.ServletContext;

public class PortletBagFactory {
    private static final Log _log = LogFactoryUtil.getLog(PortletBagFactory.class);
    private ClassLoader _classLoader;
    private Configuration _configuration;
    private ServletContext _servletContext;
    private Boolean _warFile;

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        return this.create(portlet, false);
    }

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet, boolean destroyPrevious) throws Exception {
        this._validate();
        Portlet portletInstance = this._getPortletInstance(portlet);
        return this.create(portlet, portletInstance, destroyPrevious);
    }

    public PortletBag create(com.liferay.portal.kernel.model.Portlet portlet, Portlet portletInstance, boolean destroyPrevious) throws Exception {
        this._validate();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.portlet.name", portlet.getPortletName());
        Registry registry = RegistryUtil.getRegistry();
        ArrayList serviceRegistrations = new ArrayList();
        this._registerConfigurationActions(registry, portlet, properties, serviceRegistrations);
        this._registerIndexers(registry, portlet, properties, serviceRegistrations);
        this._registerOpenSearches(registry, portlet, properties, serviceRegistrations);
        this._registerSchedulerEventMessageListeners(registry, portlet, properties, serviceRegistrations);
        FriendlyURLMapperTracker friendlyURLMapperTracker = this._registerFriendlyURLMappers(portlet);
        this._registerURLEncoders(registry, portlet, properties, serviceRegistrations);
        this._registerPortletDataHandlers(registry, portlet, properties, serviceRegistrations);
        this._registerStagedModelDataHandler(registry, portlet, properties, serviceRegistrations);
        this._registerTemplateHandlers(registry, portlet, properties, serviceRegistrations);
        this._registerPortletLayoutListeners(registry, portlet, properties, serviceRegistrations);
        this._registerPollerProcessors(registry, portlet, properties, serviceRegistrations);
        this._registerPOPMessageListeners(registry, portlet, properties, serviceRegistrations);
        this._registerSocialActivityInterpreterInstances(registry, portlet, properties, serviceRegistrations);
        this._registerSocialRequestInterpreterInstances(registry, portlet, properties, serviceRegistrations);
        this._registerUserNotificationDefinitionInstances(registry, portlet, properties, serviceRegistrations);
        this._registerUserNotificationHandlerInstances(registry, portlet, properties, serviceRegistrations);
        this._registerWebDAVStorageInstances(registry, portlet);
        this._registerXmlRpcMethodInstances(registry, portlet, properties, serviceRegistrations);
        this._registerControlPanelEntryInstances(registry, portlet, properties, serviceRegistrations);
        this._registerAssetRendererFactoryInstances(registry, portlet, properties, serviceRegistrations);
        this._registerAtomCollectionAdapterInstances(registry, portlet, properties, serviceRegistrations);
        this._registerCustomAttributesDisplayInstances(registry, portlet, properties, serviceRegistrations);
        this._registerPermissionPropagators(registry, portlet, properties, serviceRegistrations);
        this._registerTrashHandlerInstances(registry, portlet, properties, serviceRegistrations);
        this._registerWorkflowHandlerInstances(registry, portlet, properties, serviceRegistrations);
        this._registerPreferencesValidatorInstances(registry, portlet, properties, serviceRegistrations);
        PortletBagImpl portletBag = new PortletBagImpl(portlet.getPortletName(), this._servletContext, portletInstance, portlet.getResourceBundle(), friendlyURLMapperTracker, serviceRegistrations);
        PortletBagPool.put(portlet.getRootPortletId(), portletBag);
        try {
            PortletInstanceFactoryUtil.create(portlet, this._servletContext, destroyPrevious);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return portletBag;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    public void setWARFile(boolean warFile) {
        this._warFile = warFile;
    }

    private String _getContent(String fileName) throws Exception {
        String queryString = HttpUtil.getQueryString(fileName);
        if (Validator.isNull(queryString)) {
            return StringUtil.read(this._classLoader, fileName);
        }
        int pos = fileName.indexOf("?");
        String xml = StringUtil.read(this._classLoader, fileName.substring(0, pos));
        Map<String, String[]> parameterMap = HttpUtil.getParameterMap(queryString);
        if (parameterMap == null) {
            return xml;
        }
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            String[] values = entry.getValue();
            if (values.length == 0) continue;
            String value = values[0];
            xml = StringUtil.replace(xml, "@" + entry.getKey() + "@", value);
        }
        return xml;
    }

    private String _getPluginPropertyValue(String propertyKey) throws Exception {
        if (this._configuration == null) {
            this._configuration = ConfigurationFactoryUtil.getConfiguration(this._classLoader, "portlet");
        }
        return this._configuration.get(propertyKey);
    }

    private Portlet _getPortletInstance(com.liferay.portal.kernel.model.Portlet portlet) throws IllegalAccessException, InstantiationException {
        Class<?> portletClass = null;
        try {
            portletClass = this._classLoader.loadClass(portlet.getPortletClass());
        }
        catch (Throwable t) {
            _log.error(t, t);
            PortletLocalServiceUtil.destroyPortlet(portlet);
            return null;
        }
        return (Portlet)portletClass.newInstance();
    }

    private <T> T _newInstance(Class<? extends T> interfaceClass, String implClassName) throws Exception {
        if (this._warFile.booleanValue()) {
            return (T)ProxyFactory.newInstance(this._classLoader, new Class[]{interfaceClass}, implClassName);
        }
        Class<?> clazz = this._classLoader.loadClass(implClassName);
        return (T)clazz.newInstance();
    }

    private void _registerAssetRendererFactoryInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String assetRendererFactoryClass : portlet.getAssetRendererFactoryClasses()) {
            String assetRendererEnabledPropertyKey = "asset.renderer.enabled." + assetRendererFactoryClass;
            String assetRendererEnabledPropertyValue = null;
            assetRendererEnabledPropertyValue = this._warFile != false ? this._getPluginPropertyValue(assetRendererEnabledPropertyKey) : PropsUtil.get(assetRendererEnabledPropertyKey);
            boolean assetRendererEnabledValue = GetterUtil.getBoolean(assetRendererEnabledPropertyValue, true);
            if (!assetRendererEnabledValue) continue;
            AssetRendererFactory assetRendererFactoryInstance = this._newInstance(AssetRendererFactory.class, assetRendererFactoryClass);
            assetRendererFactoryInstance.setClassName(assetRendererFactoryInstance.getClassName());
            assetRendererFactoryInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration<AssetRendererFactory> serviceRegistration = registry.registerService(AssetRendererFactory.class, assetRendererFactoryInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerAtomCollectionAdapterInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String atomCollectionAdapterClass : portlet.getAtomCollectionAdapterClasses()) {
            AtomCollectionAdapter atomCollectionAdapterInstance = this._newInstance(AtomCollectionAdapter.class, atomCollectionAdapterClass);
            ServiceRegistration<AtomCollectionAdapter> serviceRegistration = registry.registerService(AtomCollectionAdapter.class, atomCollectionAdapterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerConfigurationActions(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getConfigurationActionClass())) {
            ConfigurationAction configurationAction = this._newInstance(ConfigurationAction.class, portlet.getConfigurationActionClass());
            ServiceRegistration<ConfigurationAction> serviceRegistration = registry.registerService(ConfigurationAction.class, configurationAction, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerControlPanelEntryInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getControlPanelEntryClass())) {
            ControlPanelEntry controlPanelEntryInstance = this._newInstance(ControlPanelEntry.class, portlet.getControlPanelEntryClass());
            ServiceRegistration<ControlPanelEntry> serviceRegistration = registry.registerService(ControlPanelEntry.class, controlPanelEntryInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerCustomAttributesDisplayInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String customAttributesDisplayClass : portlet.getCustomAttributesDisplayClasses()) {
            CustomAttributesDisplay customAttributesDisplayInstance = this._newInstance(CustomAttributesDisplay.class, customAttributesDisplayClass);
            customAttributesDisplayInstance.setClassNameId(PortalUtil.getClassNameId(customAttributesDisplayInstance.getClassName()));
            customAttributesDisplayInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration<CustomAttributesDisplay> serviceRegistration = registry.registerService(CustomAttributesDisplay.class, customAttributesDisplayInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private FriendlyURLMapperTracker _registerFriendlyURLMappers(com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        FriendlyURLMapperTrackerImpl friendlyURLMapperTracker = new FriendlyURLMapperTrackerImpl(portlet);
        if (Validator.isNotNull(portlet.getFriendlyURLMapperClass())) {
            FriendlyURLMapper friendlyURLMapper = this._newInstance(FriendlyURLMapper.class, portlet.getFriendlyURLMapperClass());
            friendlyURLMapperTracker.register(friendlyURLMapper);
        }
        return friendlyURLMapperTracker;
    }

    private void _registerIndexers(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String indexerClass : portlet.getIndexerClasses()) {
            Indexer indexerInstance = this._newInstance(Indexer.class, indexerClass);
            ServiceRegistration<Indexer> serviceRegistration = registry.registerService(Indexer.class, indexerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerOpenSearches(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getOpenSearchClass())) {
            OpenSearch openSearch = this._newInstance(OpenSearch.class, portlet.getOpenSearchClass());
            ServiceRegistration<OpenSearch> serviceRegistration = registry.registerService(OpenSearch.class, openSearch, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPermissionPropagators(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getPermissionPropagatorClass())) {
            PermissionPropagator permissionPropagatorInstance = this._newInstance(PermissionPropagator.class, portlet.getPermissionPropagatorClass());
            ServiceRegistration<PermissionPropagator> serviceRegistration = registry.registerService(PermissionPropagator.class, permissionPropagatorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPollerProcessors(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getPollerProcessorClass())) {
            PollerProcessor pollerProcessorInstance = this._newInstance(PollerProcessor.class, portlet.getPollerProcessorClass());
            ServiceRegistration<PollerProcessor> serviceRegistration = registry.registerService(PollerProcessor.class, pollerProcessorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPOPMessageListeners(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getPopMessageListenerClass())) {
            com.liferay.portal.kernel.pop.MessageListener popMessageListenerInstance = this._newInstance(com.liferay.portal.kernel.pop.MessageListener.class, portlet.getPopMessageListenerClass());
            ServiceRegistration<com.liferay.portal.kernel.pop.MessageListener> serviceRegistration = registry.registerService(com.liferay.portal.kernel.pop.MessageListener.class, popMessageListenerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPortletDataHandlers(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getPortletDataHandlerClass())) {
            PortletDataHandler portletDataHandlerInstance = this._newInstance(PortletDataHandler.class, portlet.getPortletDataHandlerClass());
            portletDataHandlerInstance.setPortletId(portlet.getPortletId());
            ServiceRegistration<PortletDataHandler> serviceRegistration = registry.registerService(PortletDataHandler.class, portletDataHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPortletLayoutListeners(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getPortletLayoutListenerClass())) {
            PortletLayoutListener portletLayoutListener = this._newInstance(PortletLayoutListener.class, portlet.getPortletLayoutListenerClass());
            ServiceRegistration<PortletLayoutListener> serviceRegistration = registry.registerService(PortletLayoutListener.class, portletLayoutListener, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerPreferencesValidatorInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getPreferencesValidator())) {
            PreferencesValidator preferencesValidatorInstance;
            block4: {
                preferencesValidatorInstance = this._newInstance(PreferencesValidator.class, portlet.getPreferencesValidator());
                try {
                    if (PropsValues.PREFERENCE_VALIDATE_ON_STARTUP) {
                        preferencesValidatorInstance.validate(PortletPreferencesFactoryUtil.fromDefaultXML(portlet.getDefaultPreferences()));
                    }
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn("Portlet with the name " + portlet.getPortletId() + " does not have valid default preferences");
                }
            }
            ServiceRegistration<PreferencesValidator> serviceRegistration = registry.registerService(PreferencesValidator.class, preferencesValidatorInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSchedulerEventMessageListeners(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (SchedulerEntry schedulerEntry : portlet.getSchedulerEntries()) {
            SchedulerEventMessageListenerWrapper schedulerEventMessageListenerWrapper = new SchedulerEventMessageListenerWrapper();
            MessageListener messageListener = (MessageListener)InstanceFactory.newInstance(this._classLoader, schedulerEntry.getEventListenerClass());
            schedulerEventMessageListenerWrapper.setMessageListener(messageListener);
            schedulerEventMessageListenerWrapper.setSchedulerEntry(schedulerEntry);
            ServiceRegistration<SchedulerEventMessageListenerWrapper> serviceRegistration = registry.registerService(SchedulerEventMessageListener.class, schedulerEventMessageListenerWrapper, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSocialActivityInterpreterInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String socialActivityInterpreterClass : portlet.getSocialActivityInterpreterClasses()) {
            SocialActivityInterpreter socialActivityInterpreterInstance = this._newInstance(SocialActivityInterpreter.class, socialActivityInterpreterClass);
            socialActivityInterpreterInstance = new SocialActivityInterpreterImpl(portlet.getPortletId(), socialActivityInterpreterInstance);
            ServiceRegistration<SocialActivityInterpreter> serviceRegistration = registry.registerService(SocialActivityInterpreter.class, socialActivityInterpreterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerSocialRequestInterpreterInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getSocialRequestInterpreterClass())) {
            SocialRequestInterpreter socialRequestInterpreterInstance = this._newInstance(SocialRequestInterpreter.class, portlet.getSocialRequestInterpreterClass());
            socialRequestInterpreterInstance = new SocialRequestInterpreterImpl(portlet.getPortletId(), socialRequestInterpreterInstance);
            ServiceRegistration<SocialRequestInterpreter> serviceRegistration = registry.registerService(SocialRequestInterpreter.class, socialRequestInterpreterInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerStagedModelDataHandler(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String stagedModelDataHandlerClass : portlet.getStagedModelDataHandlerClasses()) {
            StagedModelDataHandler stagedModelDataHandler = this._newInstance(StagedModelDataHandler.class, stagedModelDataHandlerClass);
            ServiceRegistration<StagedModelDataHandler> serviceRegistration = registry.registerService(StagedModelDataHandler.class, stagedModelDataHandler, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerTemplateHandlers(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getTemplateHandlerClass())) {
            TemplateHandler templateHandler = this._newInstance(TemplateHandler.class, portlet.getTemplateHandlerClass());
            ServiceRegistration<TemplateHandler> serviceRegistration = registry.registerService(TemplateHandler.class, templateHandler, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerTrashHandlerInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String trashHandlerClass : portlet.getTrashHandlerClasses()) {
            TrashHandler trashHandlerInstance = this._newInstance(TrashHandler.class, trashHandlerClass);
            ServiceRegistration<TrashHandler> serviceRegistration = registry.registerService(TrashHandler.class, trashHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerURLEncoders(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getURLEncoderClass())) {
            URLEncoder urlEncoder = this._newInstance(URLEncoder.class, portlet.getURLEncoderClass());
            ServiceRegistration<URLEncoder> serviceRegistration = registry.registerService(URLEncoder.class, urlEncoder, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerUserNotificationDefinitionInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNull(portlet.getUserNotificationDefinitions())) {
            return;
        }
        String xml = this._getContent(portlet.getUserNotificationDefinitions());
        xml = JavaFieldsParser.parse(this._classLoader, xml);
        Document document = UnsecureSAXReaderUtil.read(xml);
        Element rootElement = document.getRootElement();
        for (Element definitionElement : rootElement.elements("definition")) {
            String modelName = definitionElement.elementText("model-name");
            long classNameId = 0L;
            if (Validator.isNotNull(modelName)) {
                classNameId = PortalUtil.getClassNameId(modelName);
            }
            int notificationType = GetterUtil.getInteger(definitionElement.elementText("notification-type"));
            String description = GetterUtil.getString(definitionElement.elementText("description"));
            UserNotificationDefinition userNotificationDefinition = new UserNotificationDefinition(portlet.getPortletId(), classNameId, notificationType, description);
            for (Element deliveryTypeElement : definitionElement.elements("delivery-type")) {
                String name = deliveryTypeElement.elementText("name");
                int type = GetterUtil.getInteger(deliveryTypeElement.elementText("type"));
                boolean defaultValue = GetterUtil.getBoolean(deliveryTypeElement.elementText("default"));
                boolean modifiable = GetterUtil.getBoolean(deliveryTypeElement.elementText("modifiable"));
                userNotificationDefinition.addUserNotificationDeliveryType(new UserNotificationDeliveryType(name, type, defaultValue, modifiable));
            }
            ServiceRegistration<UserNotificationDefinition> serviceRegistration = registry.registerService(UserNotificationDefinition.class, userNotificationDefinition, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerUserNotificationHandlerInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String userNotificationHandlerClass : portlet.getUserNotificationHandlerClasses()) {
            UserNotificationHandler userNotificationHandlerInstance = this._newInstance(UserNotificationHandler.class, userNotificationHandlerClass);
            userNotificationHandlerInstance = new UserNotificationHandlerImpl(userNotificationHandlerInstance);
            ServiceRegistration<UserNotificationHandler> serviceRegistration = registry.registerService(UserNotificationHandler.class, userNotificationHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerWebDAVStorageInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet) throws Exception {
        if (Validator.isNotNull(portlet.getWebDAVStorageClass())) {
            WebDAVStorage webDAVStorageInstance = this._newInstance(WebDAVStorage.class, portlet.getWebDAVStorageClass());
            HashMap<String, Object> webDAVProperties = new HashMap<String, Object>();
            webDAVProperties.put("javax.portlet.name", portlet.getPortletId());
            webDAVProperties.put("webdav.storage.token", portlet.getWebDAVStorageToken());
            registry.registerService(WebDAVStorage.class, webDAVStorageInstance, webDAVProperties);
        }
    }

    private void _registerWorkflowHandlerInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        for (String workflowHandlerClass : portlet.getWorkflowHandlerClasses()) {
            WorkflowHandler workflowHandlerInstance = this._newInstance(WorkflowHandler.class, workflowHandlerClass);
            ServiceRegistration<WorkflowHandler> serviceRegistration = registry.registerService(WorkflowHandler.class, workflowHandlerInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _registerXmlRpcMethodInstances(Registry registry, com.liferay.portal.kernel.model.Portlet portlet, Map<String, Object> properties, List<ServiceRegistration<?>> serviceRegistrations) throws Exception {
        if (Validator.isNotNull(portlet.getXmlRpcMethodClass())) {
            Method xmlRpcMethodInstance = this._newInstance(Method.class, portlet.getXmlRpcMethodClass());
            ServiceRegistration<Method> serviceRegistration = registry.registerService(Method.class, xmlRpcMethodInstance, properties);
            serviceRegistrations.add(serviceRegistration);
        }
    }

    private void _validate() {
        if (this._classLoader == null) {
            throw new IllegalStateException("Class loader is null");
        }
        if (this._servletContext == null) {
            throw new IllegalStateException("Servlet context is null");
        }
        if (this._warFile == null) {
            throw new IllegalStateException("WAR file is null");
        }
    }
}

