/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletAsyncContext;
import javax.portlet.PortletAsyncEvent;
import javax.portlet.PortletAsyncListener;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;

public class PortletAsyncListenerAdapter
implements AsyncListener {
    private static final Log _log = LogFactoryUtil.getLog(PortletAsyncListenerAdapter.class);
    private boolean _firedOnComplete;
    private boolean _firedOnError;
    private boolean _firedOnTimeout;
    private final PortletAsyncContext _portletAsyncContext;
    private final List<PortletAsyncListenerAdapterEntry> _portletAsyncListenerAdapterEntries = new ArrayList<PortletAsyncListenerAdapterEntry>();

    public PortletAsyncListenerAdapter(PortletAsyncContext portletAsyncContext) {
        this._portletAsyncContext = portletAsyncContext;
    }

    public void addListener(PortletAsyncListener portletAsyncListener) throws IllegalStateException {
        this.addListener(portletAsyncListener, null, null);
    }

    public void addListener(PortletAsyncListener portletAsyncListener, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IllegalStateException {
        if (this._firedOnError) {
            try {
                portletAsyncListener.onError(new PortletAsyncEvent(this._portletAsyncContext, resourceRequest, resourceResponse));
            }
            catch (IOException ioe) {
                _log.error("Unable to notify listener for onError", ioe);
            }
        }
        if (this._firedOnTimeout) {
            try {
                portletAsyncListener.onTimeout(new PortletAsyncEvent(this._portletAsyncContext, resourceRequest, resourceResponse));
            }
            catch (IOException ioe) {
                _log.error("Unable to notify listener for onTimeout", ioe);
            }
        }
        if (this._firedOnComplete) {
            try {
                portletAsyncListener.onComplete(new PortletAsyncEvent(this._portletAsyncContext, resourceRequest, resourceResponse));
            }
            catch (IOException ioe) {
                _log.error("Unable to notify listener for onComplete", ioe);
            }
        }
        this._portletAsyncListenerAdapterEntries.add(new PortletAsyncListenerAdapterEntry(portletAsyncListener, resourceRequest, resourceResponse));
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this._firedOnComplete = true;
        for (PortletAsyncListenerAdapterEntry asyncListenerAdapterEntry : this._portletAsyncListenerAdapterEntries) {
            PortletAsyncListener portletAsyncListener = asyncListenerAdapterEntry.getPortletAsyncListener();
            portletAsyncListener.onComplete(new PortletAsyncEvent(this._portletAsyncContext, asyncListenerAdapterEntry.getResourceRequest(), asyncListenerAdapterEntry.getResourceResponse()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(AsyncEvent asyncEvent) throws IOException {
        this._firedOnError = true;
        Throwable t = asyncEvent.getThrowable();
        if (this._portletAsyncListenerAdapterEntries.isEmpty()) {
            _log.error(t, t);
        }
        try {
            for (PortletAsyncListenerAdapterEntry asyncListenerAdapterEntry : this._portletAsyncListenerAdapterEntries) {
                PortletAsyncListener portletAsyncListener = asyncListenerAdapterEntry.getPortletAsyncListener();
                portletAsyncListener.onError(new PortletAsyncEvent(this._portletAsyncContext, asyncListenerAdapterEntry.getResourceRequest(), asyncListenerAdapterEntry.getResourceResponse(), t));
            }
        }
        finally {
            try {
                this._portletAsyncContext.complete();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        this._firedOnComplete = false;
        this._firedOnError = false;
        this._firedOnTimeout = false;
        ArrayList<PortletAsyncListenerAdapterEntry> portletAsyncListenerAdapterEntries = new ArrayList<PortletAsyncListenerAdapterEntry>(this._portletAsyncListenerAdapterEntries);
        this._portletAsyncListenerAdapterEntries.clear();
        try {
            for (PortletAsyncListenerAdapterEntry asyncListenerAdapterEntry : portletAsyncListenerAdapterEntries) {
                PortletAsyncListener portletAsyncListener = asyncListenerAdapterEntry.getPortletAsyncListener();
                portletAsyncListener.onStartAsync(new PortletAsyncEvent(this._portletAsyncContext, asyncListenerAdapterEntry.getResourceRequest(), asyncListenerAdapterEntry.getResourceResponse()));
            }
        }
        finally {
            AsyncContext asyncContext = asyncEvent.getAsyncContext();
            asyncContext.addListener((AsyncListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        this._firedOnTimeout = true;
        try {
            for (PortletAsyncListenerAdapterEntry asyncListenerAdapterEntry : this._portletAsyncListenerAdapterEntries) {
                PortletAsyncListener portletAsyncListener = asyncListenerAdapterEntry.getPortletAsyncListener();
                portletAsyncListener.onTimeout(new PortletAsyncEvent(this._portletAsyncContext, asyncListenerAdapterEntry.getResourceRequest(), asyncListenerAdapterEntry.getResourceResponse()));
            }
        }
        finally {
            try {
                this._portletAsyncContext.complete();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    private static class PortletAsyncListenerAdapterEntry {
        private final PortletAsyncListener _portletAsyncListener;
        private final ResourceRequest _resourceRequest;
        private final ResourceResponse _resourceResponse;

        public PortletAsyncListener getPortletAsyncListener() {
            return this._portletAsyncListener;
        }

        public ResourceRequest getResourceRequest() {
            return this._resourceRequest;
        }

        public ResourceResponse getResourceResponse() {
            return this._resourceResponse;
        }

        private PortletAsyncListenerAdapterEntry(PortletAsyncListener portletAsyncListener, ResourceRequest resourceRequest, ResourceResponse resourceResponse) {
            this._portletAsyncListener = portletAsyncListener;
            this._resourceRequest = resourceRequest;
            this._resourceResponse = resourceResponse;
        }
    }
}

