/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.petra.memory.DeleteFileFinalizeAction;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.kernel.zip.ZipWriter;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.zip.TrueZIPHelperUtil;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.ZipDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ZipWriterImpl
implements ZipWriter {
    private static final Log _log = LogFactoryUtil.getLog(ZipWriterImpl.class);
    private final de.schlichtherle.io.File _file;

    public ZipWriterImpl() {
        this._file = new de.schlichtherle.io.File(StringBundler.concat(SystemProperties.get("java.io.tmpdir"), "/", PortalUUIDUtil.generate(), ".zip"));
        this._file.mkdir();
        FinalizeManager.register(this._file.getDelegate(), new DeleteFileFinalizeAction(this._file.getAbsolutePath()), FinalizeManager.PHANTOM_REFERENCE_FACTORY);
    }

    public ZipWriterImpl(File file) {
        this._file = new de.schlichtherle.io.File(file.getAbsolutePath());
        this._file.mkdir();
    }

    @Override
    public void addEntry(String name, byte[] bytes) throws IOException {
        try (UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(bytes);){
            this.addEntry(name, unsyncByteArrayInputStream);
        }
    }

    @Override
    public void addEntry(String name, InputStream inputStream) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (inputStream == null) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Adding " + name);
        }
        try (FileOutputStream outputStream = new FileOutputStream((File)new de.schlichtherle.io.File(this.getPath() + "/" + name));){
            de.schlichtherle.io.File.cat((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    @Override
    public void addEntry(String name, String s) throws IOException {
        if (s == null) {
            return;
        }
        this.addEntry(name, s.getBytes("UTF-8"));
    }

    @Override
    public void addEntry(String name, StringBuilder sb) throws IOException {
        if (sb == null) {
            return;
        }
        this.addEntry(name, sb.toString());
    }

    @Override
    public byte[] finish() throws IOException {
        File file = this.getFile();
        return FileUtil.getBytes(file);
    }

    @Override
    public File getFile() {
        try {
            de.schlichtherle.io.File.umount((de.schlichtherle.io.File)this._file);
        }
        catch (ArchiveException ae) {
            _log.error((Object)ae, ae);
        }
        return this._file.getDelegate();
    }

    @Override
    public String getPath() {
        return this._file.getPath();
    }

    @Override
    public void umount() {
        block2: {
            try {
                de.schlichtherle.io.File.umount((de.schlichtherle.io.File)this._file);
            }
            catch (ArchiveException ae) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Unable to unmount file entry", ae);
            }
        }
    }

    static {
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)new DefaultArchiveDetector(ArchiveDetector.ALL, "lar|" + ArchiveDetector.ALL.getSuffixes(), (ArchiveDriver)new ZipDriver(PropsValues.ZIP_FILE_NAME_ENCODING)));
        TrueZIPHelperUtil.initialize();
    }
}

