/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.zip;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.zip.TrueZIPHelperUtil;
import de.schlichtherle.io.ArchiveBusyWarningException;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.DefaultArchiveDetector;
import de.schlichtherle.io.FileInputStream;
import de.schlichtherle.io.FileOutputStream;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.ZipDriver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ZipReaderImpl
implements ZipReader {
    private static final Log _log = LogFactoryUtil.getLog(ZipReaderImpl.class);
    private final de.schlichtherle.io.File _zipFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipReaderImpl(InputStream inputStream) throws IOException {
        this._zipFile = new de.schlichtherle.io.File(FileUtil.createTempFile("zip"));
        try (FileOutputStream outputStream = new FileOutputStream((File)this._zipFile);){
            de.schlichtherle.io.File.cat((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            inputStream.close();
        }
    }

    public ZipReaderImpl(File file) {
        this._zipFile = new de.schlichtherle.io.File(file);
    }

    @Override
    public void close() {
        try {
            de.schlichtherle.io.File.umount((de.schlichtherle.io.File)this._zipFile);
        }
        catch (ArchiveBusyWarningException abwe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)abwe, abwe);
            }
        }
        catch (ArchiveException ae) {
            _log.error((Object)ae, ae);
        }
    }

    @Override
    public List<String> getEntries() {
        de.schlichtherle.io.File[] files = (de.schlichtherle.io.File[])this._zipFile.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList<String> folderEntries = new ArrayList<String>();
        for (de.schlichtherle.io.File file : files) {
            if (!file.isDirectory()) {
                folderEntries.add(file.getEnclEntryName());
                continue;
            }
            this.processDirectory(file, folderEntries);
        }
        return folderEntries;
    }

    @Override
    public byte[] getEntryAsByteArray(String name) {
        if (Validator.isNull(name)) {
            return null;
        }
        byte[] bytes = null;
        try {
            InputStream is = this.getEntryAsInputStream(name);
            if (is != null) {
                bytes = FileUtil.getBytes(is);
            }
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
        }
        return bytes;
    }

    @Override
    public InputStream getEntryAsInputStream(String name) {
        de.schlichtherle.io.File file;
        if (Validator.isNull(name)) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((file = new de.schlichtherle.io.File((File)this._zipFile, name, (ArchiveDetector)DefaultArchiveDetector.NULL)).exists() && !file.isDirectory()) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug("Extracting " + name);
                }
                return new FileInputStream((File)file);
            }
            catch (IOException ioe) {
                _log.error(ioe, ioe);
            }
        }
        return null;
    }

    @Override
    public String getEntryAsString(String name) {
        if (Validator.isNull(name)) {
            return null;
        }
        byte[] bytes = this.getEntryAsByteArray(name);
        if (bytes != null) {
            return new String(bytes);
        }
        return null;
    }

    @Override
    public List<String> getFolderEntries(String path) {
        de.schlichtherle.io.File[] files;
        if (Validator.isNull(path)) {
            return Collections.emptyList();
        }
        ArrayList<String> folderEntries = new ArrayList<String>();
        de.schlichtherle.io.File directory = new de.schlichtherle.io.File(this._zipFile.getPath() + "/" + path);
        if (!directory.exists()) {
            return folderEntries;
        }
        for (de.schlichtherle.io.File file : files = (de.schlichtherle.io.File[])directory.listFiles()) {
            if (file.isDirectory()) continue;
            folderEntries.add(file.getEnclEntryName());
        }
        return folderEntries;
    }

    protected void processDirectory(de.schlichtherle.io.File directory, List<String> folderEntries) {
        de.schlichtherle.io.File[] files;
        for (de.schlichtherle.io.File file : files = (de.schlichtherle.io.File[])directory.listFiles()) {
            if (!file.isDirectory()) {
                folderEntries.add(file.getEnclEntryName());
                continue;
            }
            this.processDirectory(file, folderEntries);
        }
    }

    static {
        de.schlichtherle.io.File.setDefaultArchiveDetector((ArchiveDetector)new DefaultArchiveDetector(ArchiveDetector.ALL, "lar|" + ArchiveDetector.ALL.getSuffixes(), (ArchiveDriver)new ZipDriver(PropsValues.ZIP_FILE_NAME_ENCODING)));
        TrueZIPHelperUtil.initialize();
    }
}

