/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.xsl;

import com.liferay.petra.lang.HashUtil;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.xsl.XSLURIResolver;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.util.Objects;

public class XSLTemplateResource
implements TemplateResource {
    private long _lastModified = System.currentTimeMillis();
    private String _templateId;
    private String _xml;
    private String _xsl;
    private XSLURIResolver _xslURIResolver;

    public XSLTemplateResource() {
    }

    public XSLTemplateResource(String templateId, String xsl, XSLURIResolver xslURIResolver, String xml) {
        if (Validator.isNull(templateId)) {
            throw new IllegalArgumentException("Template ID is null");
        }
        if (Validator.isNull(xsl)) {
            throw new IllegalArgumentException("XSL is null");
        }
        if (Validator.isNull(xml)) {
            throw new IllegalArgumentException("XML is null");
        }
        this._templateId = templateId;
        this._xsl = xsl;
        this._xslURIResolver = xslURIResolver;
        this._xml = xml;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof XSLTemplateResource)) {
            return false;
        }
        XSLTemplateResource xslTemplateResource = (XSLTemplateResource)obj;
        return this._templateId.equals(xslTemplateResource._templateId) && this._xsl.equals(xslTemplateResource._xsl) && Objects.equals(this._xslURIResolver, xslTemplateResource._xslURIResolver) && this._xml.equals(xslTemplateResource._xml);
    }

    @Override
    public long getLastModified() {
        return this._lastModified;
    }

    @Override
    public Reader getReader() {
        return new UnsyncStringReader(this._xsl);
    }

    @Override
    public String getTemplateId() {
        return this._templateId;
    }

    public Reader getXMLReader() {
        return new UnsyncStringReader(this._xml);
    }

    public XSLURIResolver getXSLURIResolver() {
        return this._xslURIResolver;
    }

    public int hashCode() {
        int hashCode = HashUtil.hash(0, this._templateId);
        hashCode = HashUtil.hash(hashCode, this._xsl);
        hashCode = HashUtil.hash(hashCode, this._xslURIResolver);
        hashCode = HashUtil.hash(hashCode, this._xml);
        return hashCode;
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._templateId = objectInput.readUTF();
        this._lastModified = objectInput.readLong();
        this._xsl = objectInput.readUTF();
        this._xslURIResolver = (XSLURIResolver)objectInput.readObject();
        this._xml = objectInput.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this._templateId);
        objectOutput.writeLong(this._lastModified);
        objectOutput.writeUTF(this._xsl);
        objectOutput.writeObject(this._xslURIResolver);
        objectOutput.writeUTF(this._xml);
    }
}

