/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.runtime.notification;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.workflow.kaleo.definition.NotificationReceptionType;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class NotificationRecipient {
    private final long _companyId;
    private final String _emailAddress;
    private final String _fullName;
    private final NotificationReceptionType _notificationReceptionType;
    private final String _screenName;
    private final long _userId;

    public NotificationRecipient(String emailAddress, NotificationReceptionType notificationReceptionType) {
        this._companyId = 0L;
        this._emailAddress = emailAddress;
        this._fullName = null;
        this._notificationReceptionType = notificationReceptionType;
        this._screenName = null;
        this._userId = 0L;
    }

    public NotificationRecipient(User user, NotificationReceptionType notificationReceptionType) {
        this._companyId = user.getCompanyId();
        this._emailAddress = user.getEmailAddress();
        this._fullName = user.getFullName();
        this._notificationReceptionType = notificationReceptionType;
        this._screenName = user.getScreenName();
        this._userId = user.getUserId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NotificationRecipient)) {
            return false;
        }
        NotificationRecipient notificationRecipient = (NotificationRecipient)obj;
        return this._companyId == notificationRecipient._companyId && Objects.equals(this._emailAddress, notificationRecipient._emailAddress) && this._userId == notificationRecipient._userId;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getEmailAddress() {
        return this._emailAddress;
    }

    public String getFullName() {
        return this._fullName;
    }

    public InternetAddress getInternetAddress() throws AddressException, UnsupportedEncodingException {
        if (Validator.isNull(this._fullName)) {
            return new InternetAddress(this._emailAddress);
        }
        return new InternetAddress(this._emailAddress, this._fullName);
    }

    public NotificationReceptionType getNotificationReceptionType() {
        return this._notificationReceptionType;
    }

    public String getScreenName() {
        return this._screenName;
    }

    public long getUserId() {
        return this._userId;
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this._companyId);
        if (Validator.isNotNull(this._emailAddress)) {
            hashCode.append(this._emailAddress);
        }
        hashCode.append(this._userId);
        return hashCode.toHashCode();
    }
}

