/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.kaleo.definition;

import com.liferay.portal.workflow.kaleo.definition.NodeType;
import java.util.HashMap;
import java.util.Map;

public class NodeTypeDependentObjectRegistry<T> {
    private final Map<NodeType, T> _nodeTypeDependentObjects = new HashMap<NodeType, T>();

    public void addNodeTypeDependentObject(String nodeTypeString, T nodeTypeDependentObject) {
        NodeType nodeType = NodeType.valueOf(nodeTypeString);
        this._nodeTypeDependentObjects.put(nodeType, nodeTypeDependentObject);
    }

    public T getNodeTypeDependentObjects(NodeType nodeType) {
        T nodeTypeDependentObject = this._nodeTypeDependentObjects.get((Object)nodeType);
        if (nodeTypeDependentObject == null) {
            throw new IllegalArgumentException("Invalid node type " + (Object)((Object)nodeType));
        }
        return nodeTypeDependentObject;
    }

    public T getNodeTypeDependentObjects(String nodeTypeString) {
        NodeType nodeType = NodeType.valueOf(nodeTypeString);
        return this.getNodeTypeDependentObjects(nodeType);
    }

    public T removeNodeTypeDependentObjects(String nodeTypeString) {
        NodeType nodeType = NodeType.valueOf(nodeTypeString);
        return this._nodeTypeDependentObjects.remove((Object)nodeType);
    }

    public void setNodeTypeDependentObjects(Map<String, T> nodeTypeDependentObjects) {
        for (Map.Entry<String, T> entry : nodeTypeDependentObjects.entrySet()) {
            NodeType nodeType = NodeType.valueOf(entry.getKey());
            this._nodeTypeDependentObjects.put(nodeType, entry.getValue());
        }
    }
}

