/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow;

import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.workflow.WorkflowTaskManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;

public class WorkflowPermissionAdvice {
    private static final Method _METHOD_ASSIGN_WORKFLOW_TASK_TO_USER;

    public static WorkflowTaskManager create(WorkflowTaskManager workflowTaskManager) {
        return (WorkflowTaskManager)ProxyUtil.newProxyInstance(WorkflowPermissionAdvice.class.getClassLoader(), new Class[]{WorkflowTaskManager.class}, new WorkflowPermissionInvocationHandler(workflowTaskManager));
    }

    static {
        try {
            _METHOD_ASSIGN_WORKFLOW_TASK_TO_USER = WorkflowTaskManager.class.getMethod("assignWorkflowTaskToUser", Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, String.class, Date.class, Map.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }

    private static class WorkflowPermissionInvocationHandler
    implements InvocationHandler {
        private final WorkflowTaskManager _workflowTaskManager;

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            if (_METHOD_ASSIGN_WORKFLOW_TASK_TO_USER.equals(method)) {
                long userId = (Long)arguments[1];
                PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
                if (permissionChecker.getUserId() != userId) {
                    throw new PrincipalException();
                }
            }
            try {
                return method.invoke((Object)this._workflowTaskManager, arguments);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        private WorkflowPermissionInvocationHandler(WorkflowTaskManager workflowTaskManager) {
            this._workflowTaskManager = workflowTaskManager;
        }
    }
}

