/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.lock.LockManagerUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowDefinition;
import com.liferay.portal.kernel.workflow.WorkflowDefinitionManager;
import com.liferay.portal.kernel.workflow.WorkflowException;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class WorkflowLockingAdvice {
    private static final Method _METHOD_START_WORKFLOW_INSTANCE;
    private static final Method _METHOD_UNDEPLOY_WORKFLOW_DEFINITION;

    public static WorkflowDefinitionManager create(WorkflowDefinitionManager workflowDefinitionManager) {
        return (WorkflowDefinitionManager)ProxyUtil.newProxyInstance(WorkflowLockingAdvice.class.getClassLoader(), new Class[]{WorkflowDefinitionManager.class}, new WorkflowLockingInvocationHandler(workflowDefinitionManager));
    }

    public static WorkflowInstanceManager create(WorkflowInstanceManager workflowInstanceManager) {
        return (WorkflowInstanceManager)ProxyUtil.newProxyInstance(WorkflowLockingAdvice.class.getClassLoader(), new Class[]{WorkflowInstanceManager.class}, new WorkflowLockingInvocationHandler(workflowInstanceManager));
    }

    private static String _encodeKey(String name, int version) {
        return name.concat("#").concat(StringUtil.toHexString(version));
    }

    static {
        try {
            _METHOD_START_WORKFLOW_INSTANCE = WorkflowInstanceManager.class.getMethod("startWorkflowInstance", Long.TYPE, Long.TYPE, Long.TYPE, String.class, Integer.class, String.class, Map.class);
            _METHOD_UNDEPLOY_WORKFLOW_DEFINITION = WorkflowDefinitionManager.class.getMethod("undeployWorkflowDefinition", Long.TYPE, Long.TYPE, String.class, Integer.TYPE);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }

    private static class WorkflowLockingInvocationHandler
    implements InvocationHandler {
        private final Object _targetObject;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            String key;
            if (_METHOD_START_WORKFLOW_INSTANCE.equals(method)) {
                String key2;
                String workflowDefinitionName = (String)arguments[3];
                Integer workflowDefinitionVersion = (Integer)arguments[4];
                String className = WorkflowDefinition.class.getName();
                if (LockManagerUtil.isLocked(className, key2 = WorkflowLockingAdvice._encodeKey(workflowDefinitionName, workflowDefinitionVersion))) {
                    throw new WorkflowException(StringBundler.concat("Workflow definition name ", workflowDefinitionName, " and version ", workflowDefinitionVersion, " is being undeployed"));
                }
                return this._invoke(method, arguments);
            }
            if (!_METHOD_UNDEPLOY_WORKFLOW_DEFINITION.equals(method)) {
                return this._invoke(method, arguments);
            }
            long userId = (Long)arguments[1];
            String name = (String)arguments[2];
            Integer version = (Integer)arguments[3];
            String className = WorkflowDefinition.class.getName();
            if (LockManagerUtil.isLocked(className, key = WorkflowLockingAdvice._encodeKey(name, version))) {
                throw new WorkflowException(StringBundler.concat("Workflow definition name ", name, " and version ", version, " is being undeployed"));
            }
            try {
                LockManagerUtil.lock(userId, className, key, String.valueOf(userId), false, 3600000L);
                Object object = this._invoke(method, arguments);
                return object;
            }
            finally {
                LockManagerUtil.unlock(className, key);
            }
        }

        private WorkflowLockingInvocationHandler(Object targetObject) {
            this._targetObject = targetObject;
        }

        private Object _invoke(Method method, Object[] arguments) throws Throwable {
            try {
                return method.invoke(this._targetObject, arguments);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

